/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import org.monetdb.jdbc.MonetConnection;
import org.monetdb.jdbc.MonetResultSet;
import org.monetdb.jdbc.MonetVirtualResultSet;
import org.monetdb.jdbc.MonetWrapper;

public class MonetStatement
extends MonetWrapper
implements Statement,
AutoCloseable {
    protected final MonetConnection connection;
    private MonetConnection.ResponseList lastResponseList;
    MonetConnection.Response header;
    private SQLWarning warnings;
    protected boolean closed = false;
    protected boolean poolable = false;
    private boolean closeOnCompletion = false;
    private int queryTimeout;
    private int fetchSize;
    private long maxRows;
    private int resultSetType = 1003;
    private int fetchDirection = 1000;
    private int resultSetConcurrency = 1007;
    private ArrayList<String> batch;
    private ReentrantLock batchLock;

    MonetStatement(MonetConnection monetConnection, int n, int n2, int n3) throws SQLException, IllegalArgumentException {
        if (monetConnection == null) {
            throw new IllegalArgumentException("No Connection given!");
        }
        this.connection = monetConnection;
        this.queryTimeout = monetConnection.lastSetQueryTimeout;
        this.fetchSize = monetConnection.getDefaultFetchSize();
        this.resultSetType = n;
        this.resultSetConcurrency = n2;
        if (this.resultSetConcurrency != 1007) {
            this.addWarning("No concurrency mode other then read only is supported, continuing with concurrency level READ_ONLY", "01M13");
            this.resultSetConcurrency = 1007;
        }
        if (this.resultSetType == 1005) {
            this.addWarning("Change sensitive scrolling ResultSet objects are not supported, continuing with a change non-sensitive scrollable cursor.", "01M14");
            this.resultSetType = 1004;
        }
        if (n3 != 1) {
            this.addWarning("Close cursors at commit not supported, continuing with holdability to hold cursors open over commit.", "01M15");
        }
    }

    @Override
    public void addBatch(String string) throws SQLException {
        if (string == null || string.isEmpty()) {
            throw new SQLException("Missing SQL statement", "M1M05");
        }
        if (this.batch == null) {
            this.batch = new ArrayList();
        }
        this.batch.add(string);
    }

    @Override
    public void clearBatch() {
        if (this.batch != null) {
            this.batch.clear();
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (this.batch == null || this.batch.isEmpty()) {
            return new int[0];
        }
        long[] lArray = this.executeLargeBatch();
        int[] nArray = new int[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            nArray[i] = lArray[i] >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)lArray[i];
        }
        return nArray;
    }

    @Override
    public void cancel() throws SQLException {
        throw new SQLFeatureNotSupportedException("Query cancelling is currently not supported by the driver.", "0A000");
    }

    @Override
    public void clearWarnings() {
        this.warnings = null;
    }

    @Override
    public void close() {
        this.clearBatch();
        this.clearWarnings();
        if (this.lastResponseList != null) {
            this.lastResponseList.close();
            this.lastResponseList = null;
        }
        this.header = null;
        this.batchLock = null;
        this.closed = true;
    }

    @Override
    public boolean execute(String string) throws SQLException {
        return this.internalExecute(string);
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        if (n != 1 && n != 2) {
            throw new SQLException("Invalid argument, expected RETURN_GENERATED_KEYS or NO_GENERATED_KEYS", "M1M05");
        }
        return this.internalExecute(string);
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        this.addWarning("execute: generated keys for fixed set of columns not supported", "01M18");
        return this.execute(string, 1);
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        this.addWarning("execute: generated keys for fixed set of columns not supported", "01M18");
        return this.execute(string, 1);
    }

    private boolean internalExecute(String string) throws SQLException {
        if (this.lastResponseList != null) {
            this.lastResponseList.close();
            this.lastResponseList = null;
        }
        if (string == null || string.isEmpty()) {
            throw new SQLException("Missing SQL statement", "M1M05");
        }
        if (this.queryTimeout != this.connection.lastSetQueryTimeout) {
            this.connection.setQueryTimeout(this.queryTimeout);
        }
        MonetConnection monetConnection = this.connection;
        Objects.requireNonNull(monetConnection);
        this.lastResponseList = monetConnection.new MonetConnection.ResponseList(this.fetchSize, this.maxRows, this.resultSetType, this.resultSetConcurrency);
        this.lastResponseList.processQuery(string);
        return this.getMoreResults();
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        if (!this.execute(string)) {
            throw new SQLException("Query did not produce a result set", "M1M19");
        }
        return this.getResultSet();
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        if (this.execute(string)) {
            throw new SQLException("Statement produced a result set", "M1M17");
        }
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        if (n != 1 && n != 2) {
            throw new SQLException("Invalid argument, expected RETURN_GENERATED_KEYS or NO_GENERATED_KEYS", "M1M05");
        }
        if (this.execute(string)) {
            throw new SQLException("Statement produced a result set", "M1M17");
        }
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        this.addWarning("executeUpdate: generated keys for fixed set of columns not supported", "01M18");
        return this.executeUpdate(string, 1);
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        this.addWarning("executeUpdate: generated keys for fixed set of columns not supported", "01M18");
        return this.executeUpdate(string, 1);
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public int getFetchDirection() {
        return this.fetchDirection;
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        String[][] stringArray;
        String[] stringArray2 = new String[1];
        String[] stringArray3 = new String[1];
        stringArray2[0] = "GENERATED_KEY";
        stringArray3[0] = "BIGINT";
        if (this.header != null && this.header instanceof MonetConnection.UpdateResponse) {
            String string = ((MonetConnection.UpdateResponse)this.header).lastid;
            if (string.equals("-1")) {
                stringArray = new String[0][1];
            } else {
                stringArray = new String[1][1];
                stringArray[0][0] = string;
            }
        } else {
            stringArray = new String[0][1];
        }
        try {
            return new MonetVirtualResultSet((Statement)this, stringArray2, stringArray3, stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SQLException("Internal driver error: " + illegalArgumentException.getMessage(), "M0M03");
        }
    }

    @Override
    public int getMaxFieldSize() {
        return 0x7FFFFFFE;
    }

    @Override
    public int getMaxRows() {
        if (this.maxRows >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(3);
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        if (this.lastResponseList == null) {
            this.header = null;
            return false;
        }
        if (n == 1) {
            this.lastResponseList.closeCurrentResponse();
        } else if (n == 3) {
            this.lastResponseList.closeCurOldResponses();
        }
        this.header = this.lastResponseList.getNextResponse();
        return this.header != null && this.header instanceof MonetConnection.ResultSetResponse;
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.header != null && this.header instanceof MonetConnection.ResultSetResponse) {
            return new MonetResultSet(this, (MonetConnection.ResultSetResponse)this.header);
        }
        return null;
    }

    @Override
    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetHoldability() {
        return 1;
    }

    @Override
    public int getResultSetType() {
        return this.resultSetType;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        long l = this.getLargeUpdateCount();
        if (l >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.closed) {
            throw new SQLException("Cannot call on closed Statement", "M1M20");
        }
        return this.warnings;
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        this.addWarning("setCursorName: positioned updates/deletes not supported", "01M21");
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        if (this.connection.getDatabaseMajorVersion() == 11 && this.connection.getDatabaseMinorVersion() <= 45) {
            if (bl) {
                this.addWarning("setEscapeProcessing(true): JDBC escape syntax is not supported by this driver or server", "01M22");
            }
        } else if (!bl) {
            this.addWarning("setEscapeProcessing(false): Cannot disable JDBC escape processing.", "M1M05");
        }
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        if (n != 1000 && n != 1001 && n != 1002) {
            throw new SQLException("Illegal direction: " + n, "M1M05");
        }
        this.fetchDirection = n;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        if (n < 0 || this.maxRows != 0L && n > this.getMaxRows()) {
            throw new SQLException("Illegal fetch size value: " + n, "M1M05");
        }
        this.fetchSize = n;
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("Illegal max value: " + n, "M1M05");
        }
        if (n > 0) {
            this.addWarning("setMaxFieldSize: field size limitation not supported", "01M23");
        }
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("Illegal max value: " + n, "M1M05");
        }
        this.maxRows = n;
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("Illegal timeout value: " + n, "M1M05");
        }
        this.queryTimeout = n;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void setPoolable(boolean bl) {
        this.poolable = bl;
    }

    @Override
    public boolean isPoolable() {
        return this.poolable;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        if (this.closed) {
            throw new SQLException("Cannot call on closed Statement", "M1M20");
        }
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        if (this.closed) {
            throw new SQLException("Cannot call on closed Statement", "M1M20");
        }
        return this.closeOnCompletion;
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        if (this.header != null) {
            if (this.header instanceof MonetConnection.UpdateResponse) {
                return ((MonetConnection.UpdateResponse)this.header).count;
            }
            if (this.header instanceof MonetConnection.SchemaResponse) {
                Objects.requireNonNull((MonetConnection.SchemaResponse)this.header);
                return -2L;
            }
        }
        return -1L;
    }

    @Override
    public void setLargeMaxRows(long l) throws SQLException {
        if (l < 0L) {
            throw new SQLException("Illegal max value: " + l, "M1M05");
        }
        this.maxRows = l;
    }

    @Override
    public long getLargeMaxRows() {
        return this.maxRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] executeLargeBatch() throws SQLException {
        if (this.batch == null || this.batch.isEmpty()) {
            return new long[0];
        }
        if (this.batchLock == null) {
            this.batchLock = new ReentrantLock();
        }
        this.batchLock.lock();
        try {
            long[] lArray = new long[this.batch.size()];
            String string = this.connection.queryTempl[2];
            int n = string.length();
            BatchUpdateException batchUpdateException = new BatchUpdateException("Error(s) occurred while executing the batch, see chained SQLExceptions for details", "22000", 22000, lArray, null);
            StringBuilder stringBuilder = new StringBuilder(8190);
            int n2 = 0;
            boolean bl = true;
            boolean bl2 = false;
            for (int i = 0; i < this.batch.size(); ++i) {
                String string2 = this.batch.get(i);
                if (n + string2.length() > 8190) {
                    if (!bl) {
                        stringBuilder.append(string);
                    }
                    stringBuilder.append(string2);
                    bl2 |= this.internalBatch(stringBuilder, lArray, n2, i + 1, batchUpdateException);
                    n2 = i;
                    stringBuilder.setLength(0);
                    bl = true;
                    continue;
                }
                if (stringBuilder.length() + n + string2.length() >= 8190) {
                    bl2 |= this.internalBatch(stringBuilder, lArray, n2, i + 1, batchUpdateException);
                    n2 = i;
                    stringBuilder.setLength(0);
                    bl = true;
                }
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(string);
                }
                stringBuilder.append(string2);
            }
            if (bl2 |= this.internalBatch(stringBuilder, lArray, n2, lArray.length, batchUpdateException)) {
                throw batchUpdateException;
            }
            long[] lArray2 = lArray;
            return lArray2;
        }
        finally {
            this.batch.clear();
            this.batchLock.unlock();
        }
    }

    private boolean internalBatch(StringBuilder stringBuilder, long[] lArray, int n, int n2, BatchUpdateException batchUpdateException) throws BatchUpdateException {
        if (stringBuilder.length() == 0) {
            return false;
        }
        try {
            long l = -1L;
            boolean bl = this.internalExecute(stringBuilder.toString());
            if (!bl) {
                l = this.getLargeUpdateCount();
            }
            do {
                if (n >= n2) {
                    throw new SQLException("Overflow: don't use multi statements when batching (" + n2 + ")", "M1M16");
                }
                if (bl) {
                    batchUpdateException.setNextException(new SQLException("Batch query produced a ResultSet! Ignoring and setting update count to value -3", "M1M17"));
                    lArray[n] = -3L;
                } else if (l >= 0L) {
                    lArray[n] = l;
                }
                ++n;
            } while ((bl = this.getMoreResults()) || (l = this.getLargeUpdateCount()) != -1L);
        }
        catch (SQLException sQLException) {
            batchUpdateException.setNextException(sQLException);
            while (n < n2) {
                lArray[n] = -3L;
                ++n;
            }
            return true;
        }
        return false;
    }

    @Override
    public long executeLargeUpdate(String string) throws SQLException {
        if (this.execute(string)) {
            throw new SQLException("Statement produced a result set", "M1M17");
        }
        return this.getLargeUpdateCount();
    }

    @Override
    public long executeLargeUpdate(String string, int n) throws SQLException {
        if (n != 1 && n != 2) {
            throw new SQLException("Invalid argument, expected RETURN_GENERATED_KEYS or NO_GENERATED_KEYS", "M1M05");
        }
        if (this.execute(string)) {
            throw new SQLException("Statement produced a result set", "M1M17");
        }
        return this.getLargeUpdateCount();
    }

    @Override
    public long executeLargeUpdate(String string, int[] nArray) throws SQLException {
        this.addWarning("executeLargeUpdate: generated keys for fixed set of columns not supported", "01M18");
        return this.executeLargeUpdate(string, 1);
    }

    @Override
    public long executeLargeUpdate(String string, String[] stringArray) throws SQLException {
        this.addWarning("executeLargeUpdate: generated keys for fixed set of columns not supported", "01M18");
        return this.executeLargeUpdate(string, 1);
    }

    private void addWarning(String string, String string2) {
        SQLWarning sQLWarning = new SQLWarning(string, string2);
        if (this.warnings == null) {
            this.warnings = sQLWarning;
        } else {
            this.warnings.setNextWarning(sQLWarning);
        }
    }

    void closeIfCompletion() {
        if (!this.closeOnCompletion || this.lastResponseList == null) {
            return;
        }
        if (!this.lastResponseList.hasUnclosedResponses()) {
            this.close();
        }
    }
}

