/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.transport;

import java.io.IOException;
import java.io.OutputStream;

public class LimitingOutputStream
extends OutputStream {
    private int size = 0;
    private int maxSize;
    private OutputStream out;

    public LimitingOutputStream(int maxSize, OutputStream out) {
        this.maxSize = maxSize;
        this.out = out;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public void write(int b) throws IOException {
        ++this.size;
        this.checkSizeLimit();
        this.out.write(b);
    }

    private void checkSizeLimit() throws IOException {
        if (this.size > this.maxSize) {
            throw new IOException("Exceeded max size limit of " + this.maxSize + " with request size " + this.size);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.size += b.length;
        this.checkSizeLimit();
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.size += len;
        this.checkSizeLimit();
        this.out.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

