/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.s3;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.commons.codec.digest.DigestUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public class SSECustomerKey {
    private final @Nullable @UnknownKeyFor @Initialized String key;
    private final @Nullable @UnknownKeyFor @Initialized String algorithm;
    private final @Nullable @UnknownKeyFor @Initialized String md5;

    private SSECustomerKey(@UnknownKeyFor @NonNull @Initialized Builder builder) {
        Preconditions.checkArgument((builder.key == null && builder.algorithm == null || builder.key != null && builder.algorithm != null ? 1 : 0) != 0, (Object)"Encryption key and algorithm for SSE-C encryption must be specified in pairs");
        this.key = builder.key;
        this.algorithm = builder.algorithm;
        this.md5 = builder.md5 == null && this.key != null ? Base64.getEncoder().encodeToString(DigestUtils.md5((byte[])Base64.getDecoder().decode(this.key.getBytes(StandardCharsets.UTF_8)))) : builder.md5;
    }

    public @Nullable @UnknownKeyFor @Initialized String getKey() {
        return this.key;
    }

    public @Nullable @UnknownKeyFor @Initialized String getAlgorithm() {
        return this.algorithm;
    }

    public @Nullable @UnknownKeyFor @Initialized String getMD5() {
        return this.md5;
    }

    public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new Builder();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private @Nullable @UnknownKeyFor @Initialized String key;
        private @Nullable @UnknownKeyFor @Initialized String algorithm;
        private @Nullable @UnknownKeyFor @Initialized String md5;

        private Builder() {
        }

        public @UnknownKeyFor @NonNull @Initialized Builder key(@Nullable @UnknownKeyFor @Initialized String key) {
            this.key = key;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder algorithm(@Nullable @UnknownKeyFor @Initialized String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder md5(@Nullable @UnknownKeyFor @Initialized String md5) {
            this.md5 = md5;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized SSECustomerKey build() {
            return new SSECustomerKey(this);
        }
    }
}

