/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p69p0.io.grpc.alts;

import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.Attributes;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.ExperimentalApi;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.ServerCall;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.alts.AltsContext;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.alts.internal.AltsInternalContext;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.alts.internal.AltsProtocolNegotiator;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/7864")
public final class AltsContextUtil {
    private AltsContextUtil() {
    }

    public static AltsContext createFrom(ServerCall<?, ?> call) {
        Object authContext = call.getAttributes().get(AltsProtocolNegotiator.AUTH_CONTEXT_KEY);
        if (!(authContext instanceof AltsInternalContext)) {
            throw new IllegalArgumentException("No ALTS context information found");
        }
        return new AltsContext((AltsInternalContext)authContext);
    }

    public static boolean check(ServerCall<?, ?> call) {
        return AltsContextUtil.check(call.getAttributes());
    }

    public static boolean check(Attributes attributes) {
        Object authContext = attributes.get(AltsProtocolNegotiator.AUTH_CONTEXT_KEY);
        return authContext instanceof AltsInternalContext;
    }
}

