/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.cmd;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AntPathMatcher {
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\{[^/]+?\\}");
    public static final String DEFAULT_PATH_SEPARATOR = "/";
    private String pathSeparator = "/";
    private final Map<String, AntPathStringMatcher> stringMatcherCache = new ConcurrentHashMap<String, AntPathStringMatcher>(256);
    private boolean trimTokens = true;

    public Iterable<File> findFiles(File relativeRoot, String pattern) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i != pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c == '?' || c == '*') {
                sb.setLength(sb.lastIndexOf(this.pathSeparator));
                break;
            }
            sb.append(c);
        }
        if (sb.length() == pattern.length()) {
            File f = this.path2file(relativeRoot, pattern);
            if (f.exists()) {
                return Collections.singleton(f);
            }
            return Collections.emptyList();
        }
        String base = sb.toString();
        File root = this.path2file(relativeRoot, base);
        return this.findFiles(root, base, pattern);
    }

    protected File path2file(File relativeRoot, String pattern) {
        File f = pattern.startsWith(this.pathSeparator) || pattern.length() > 2 && pattern.charAt(1) == ':' ? new File(pattern) : new File(relativeRoot, pattern);
        return f;
    }

    protected Iterable<File> findFiles(final File root, final String prefix, final String pattern) {
        return new Iterable<File>(){

            @Override
            public Iterator<File> iterator() {
                return new SeekerIterator(root, prefix, pattern);
            }
        };
    }

    public void setPathSeparator(String pathSeparator) {
        this.pathSeparator = pathSeparator != null ? pathSeparator : DEFAULT_PATH_SEPARATOR;
    }

    public void setTrimTokens(boolean trimTokens) {
        this.trimTokens = trimTokens;
    }

    public boolean isPattern(String path) {
        return path.indexOf(42) != -1 || path.indexOf(63) != -1;
    }

    public boolean match(String pattern, String path) {
        return this.doMatch(pattern, path, true, null);
    }

    public boolean matchStart(String pattern, String path) {
        return this.doMatch(pattern, path, false, null);
    }

    protected boolean doMatch(String pattern, String path, boolean fullMatch, Map<String, String> uriTemplateVariables) {
        String patDir;
        int pathIdxStart;
        if (path.startsWith(this.pathSeparator) != pattern.startsWith(this.pathSeparator)) {
            return false;
        }
        String[] pattDirs = AntPathMatcher.tokenizeToStringArray(pattern, this.pathSeparator, this.trimTokens, true);
        String[] pathDirs = AntPathMatcher.tokenizeToStringArray(path, this.pathSeparator, this.trimTokens, true);
        int pattIdxStart = 0;
        int pattIdxEnd = pattDirs.length - 1;
        int pathIdxEnd = pathDirs.length - 1;
        for (pathIdxStart = 0; pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd && !"**".equals(patDir = pattDirs[pattIdxStart]); ++pattIdxStart, ++pathIdxStart) {
            if (this.matchStrings(patDir, pathDirs[pathIdxStart], uriTemplateVariables)) continue;
            return false;
        }
        if (pathIdxStart > pathIdxEnd) {
            if (pattIdxStart > pattIdxEnd) {
                return pattern.endsWith(this.pathSeparator) ? path.endsWith(this.pathSeparator) : !path.endsWith(this.pathSeparator);
            }
            if (!fullMatch) {
                return true;
            }
            if (pattIdxStart == pattIdxEnd && pattDirs[pattIdxStart].equals("*") && path.endsWith(this.pathSeparator)) {
                return true;
            }
            for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
                if (pattDirs[i].equals("**")) continue;
                return false;
            }
            return true;
        }
        if (pattIdxStart > pattIdxEnd) {
            return false;
        }
        if (!fullMatch && "**".equals(pattDirs[pattIdxStart])) {
            return true;
        }
        while (pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd && !(patDir = pattDirs[pattIdxEnd]).equals("**")) {
            if (!this.matchStrings(patDir, pathDirs[pathIdxEnd], uriTemplateVariables)) {
                return false;
            }
            --pattIdxEnd;
            --pathIdxEnd;
        }
        if (pathIdxStart > pathIdxEnd) {
            for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
                if (pattDirs[i].equals("**")) continue;
                return false;
            }
            return true;
        }
        while (pattIdxStart != pattIdxEnd && pathIdxStart <= pathIdxEnd) {
            int patIdxTmp = -1;
            for (int i = pattIdxStart + 1; i <= pattIdxEnd; ++i) {
                if (!pattDirs[i].equals("**")) continue;
                patIdxTmp = i;
                break;
            }
            if (patIdxTmp == pattIdxStart + 1) {
                ++pattIdxStart;
                continue;
            }
            int patLength = patIdxTmp - pattIdxStart - 1;
            int strLength = pathIdxEnd - pathIdxStart + 1;
            int foundIdx = -1;
            block6: for (int i = 0; i <= strLength - patLength; ++i) {
                for (int j = 0; j < patLength; ++j) {
                    String subPat = pattDirs[pattIdxStart + j + 1];
                    String subStr = pathDirs[pathIdxStart + i + j];
                    if (!this.matchStrings(subPat, subStr, uriTemplateVariables)) continue block6;
                }
                foundIdx = pathIdxStart + i;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            pattIdxStart = patIdxTmp;
            pathIdxStart = foundIdx + patLength;
        }
        for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
            if (pattDirs[i].equals("**")) continue;
            return false;
        }
        return true;
    }

    private boolean matchStrings(String pattern, String str, Map<String, String> uriTemplateVariables) {
        AntPathStringMatcher matcher = this.stringMatcherCache.get(pattern);
        if (matcher == null) {
            matcher = new AntPathStringMatcher(pattern);
            this.stringMatcherCache.put(pattern, matcher);
        }
        return matcher.matchStrings(str, uriTemplateVariables);
    }

    public String extractPathWithinPattern(String pattern, String path) {
        int i;
        String[] patternParts = AntPathMatcher.tokenizeToStringArray(pattern, this.pathSeparator, this.trimTokens, true);
        String[] pathParts = AntPathMatcher.tokenizeToStringArray(path, this.pathSeparator, this.trimTokens, true);
        StringBuilder builder = new StringBuilder();
        int puts = 0;
        for (i = 0; i < patternParts.length; ++i) {
            String patternPart = patternParts[i];
            if (patternPart.indexOf(42) <= -1 && patternPart.indexOf(63) <= -1 || pathParts.length < i + 1) continue;
            if (puts > 0 || i == 0 && !pattern.startsWith(this.pathSeparator)) {
                builder.append(this.pathSeparator);
            }
            builder.append(pathParts[i]);
            ++puts;
        }
        for (i = patternParts.length; i < pathParts.length; ++i) {
            if (puts > 0 || i > 0) {
                builder.append(this.pathSeparator);
            }
            builder.append(pathParts[i]);
        }
        return builder.toString();
    }

    public Map<String, String> extractUriTemplateVariables(String pattern, String path) {
        LinkedHashMap<String, String> variables = new LinkedHashMap<String, String>();
        boolean result = this.doMatch(pattern, path, true, variables);
        if (!result) {
            throw new IllegalArgumentException("Pattern \"" + pattern + "\" is not a match for \"" + path + "\"");
        }
        return variables;
    }

    public String combine(String pattern1, String pattern2) {
        String extension2;
        String fileName2;
        boolean pattern1ContainsUriVar;
        if (!AntPathMatcher.hasText(pattern1) && !AntPathMatcher.hasText(pattern2)) {
            return "";
        }
        if (!AntPathMatcher.hasText(pattern1)) {
            return pattern2;
        }
        if (!AntPathMatcher.hasText(pattern2)) {
            return pattern1;
        }
        boolean bl = pattern1ContainsUriVar = pattern1.indexOf(123) != -1;
        if (!pattern1.equals(pattern2) && !pattern1ContainsUriVar && this.match(pattern1, pattern2)) {
            return pattern2;
        }
        if (pattern1.endsWith("/*")) {
            if (pattern2.startsWith(DEFAULT_PATH_SEPARATOR)) {
                return pattern1.substring(0, pattern1.length() - 1) + pattern2.substring(1);
            }
            return pattern1.substring(0, pattern1.length() - 1) + pattern2;
        }
        if (pattern1.endsWith("/**")) {
            if (pattern2.startsWith(DEFAULT_PATH_SEPARATOR)) {
                return pattern1 + pattern2;
            }
            return pattern1 + DEFAULT_PATH_SEPARATOR + pattern2;
        }
        int dotPos1 = pattern1.indexOf(46);
        if (dotPos1 == -1 || pattern1ContainsUriVar) {
            if (pattern1.endsWith(DEFAULT_PATH_SEPARATOR) || pattern2.startsWith(DEFAULT_PATH_SEPARATOR)) {
                return pattern1 + pattern2;
            }
            return pattern1 + DEFAULT_PATH_SEPARATOR + pattern2;
        }
        String fileName1 = pattern1.substring(0, dotPos1);
        String extension1 = pattern1.substring(dotPos1);
        int dotPos2 = pattern2.indexOf(46);
        if (dotPos2 != -1) {
            fileName2 = pattern2.substring(0, dotPos2);
            extension2 = pattern2.substring(dotPos2);
        } else {
            fileName2 = pattern2;
            extension2 = "";
        }
        String fileName = fileName1.endsWith("*") ? fileName2 : fileName1;
        String extension = extension1.startsWith("*") ? extension2 : extension1;
        return fileName + extension;
    }

    public Comparator<String> getPatternComparator(String path) {
        return new AntPatternComparator(path);
    }

    private static String[] tokenizeToStringArray(String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (str == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return AntPathMatcher.toStringArray(tokens);
    }

    private static String[] toStringArray(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new String[collection.size()]);
    }

    private static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }

    private static boolean hasText(CharSequence str) {
        if (!AntPathMatcher.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean hasText(String str) {
        return AntPathMatcher.hasText((CharSequence)str);
    }

    private static int countOccurrencesOf(String str, String sub) {
        int idx;
        if (str == null || sub == null || str.length() == 0 || sub.length() == 0) {
            return 0;
        }
        int count = 0;
        int pos = 0;
        while ((idx = str.indexOf(sub, pos)) != -1) {
            ++count;
            pos = idx + sub.length();
        }
        return count;
    }

    static class SeekState {
        File node;
        SeekState prev;
        List<File> files = new ArrayList<File>();
        int pathLength;

        SeekState() {
        }
    }

    class SeekerIterator
    implements Iterator<File> {
        final String pattern;
        SeekState stack;
        File next;
        StringBuffer buffer = new StringBuffer();

        public SeekerIterator(File root, String spath, String pattern) {
            this.pattern = pattern;
            this.buffer.append(spath);
            this.stack = new SeekState();
            File[] files = root.listFiles();
            if (files != null) {
                this.stack.files.addAll(Arrays.asList(files));
            }
            this.stack.pathLength = this.buffer.length();
            this.seek();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public File next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            File n = this.next;
            this.seek();
            return n;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void seek() {
            this.next = null;
            while (this.stack != null) {
                if (this.stack.files.isEmpty()) {
                    this.stack = this.stack.prev;
                    continue;
                }
                File file = this.stack.files.remove(0);
                this.buffer.setLength(this.stack.pathLength);
                this.buffer.append(AntPathMatcher.this.pathSeparator);
                this.buffer.append(file.getName());
                String path = this.buffer.toString();
                if (file.isDirectory() && AntPathMatcher.this.matchStart(this.pattern, path)) {
                    SeekState nstate = new SeekState();
                    nstate.pathLength = this.buffer.length();
                    nstate.node = file;
                    nstate.prev = this.stack;
                    nstate.files.addAll(Arrays.asList(file.listFiles()));
                    this.stack = nstate;
                }
                if (!AntPathMatcher.this.match(this.pattern, path)) continue;
                this.next = file;
                break;
            }
        }
    }

    private static class AntPathStringMatcher {
        private static final Pattern GLOB_PATTERN = Pattern.compile("\\?|\\*|\\{((?:\\{[^/]+?\\}|[^/{}]|\\\\[{}])+?)\\}");
        private static final String DEFAULT_VARIABLE_PATTERN = "(.*)";
        private final Pattern pattern;
        private final List<String> variableNames = new LinkedList<String>();

        public AntPathStringMatcher(String pattern) {
            StringBuilder patternBuilder = new StringBuilder();
            Matcher m = GLOB_PATTERN.matcher(pattern);
            int end = 0;
            while (m.find()) {
                patternBuilder.append(this.quote(pattern, end, m.start()));
                String match = m.group();
                if ("?".equals(match)) {
                    patternBuilder.append('.');
                } else if ("*".equals(match)) {
                    patternBuilder.append(".*");
                } else if (match.startsWith("{") && match.endsWith("}")) {
                    int colonIdx = match.indexOf(58);
                    if (colonIdx == -1) {
                        patternBuilder.append(DEFAULT_VARIABLE_PATTERN);
                        this.variableNames.add(m.group(1));
                    } else {
                        String variablePattern = match.substring(colonIdx + 1, match.length() - 1);
                        patternBuilder.append('(');
                        patternBuilder.append(variablePattern);
                        patternBuilder.append(')');
                        String variableName = match.substring(1, colonIdx);
                        this.variableNames.add(variableName);
                    }
                }
                end = m.end();
            }
            patternBuilder.append(this.quote(pattern, end, pattern.length()));
            this.pattern = Pattern.compile(patternBuilder.toString());
        }

        private String quote(String s, int start, int end) {
            if (start == end) {
                return "";
            }
            return Pattern.quote(s.substring(start, end));
        }

        public boolean matchStrings(String str, Map<String, String> uriTemplateVariables) {
            Matcher matcher = this.pattern.matcher(str);
            if (matcher.matches()) {
                if (uriTemplateVariables != null) {
                    if (this.variableNames.size() != matcher.groupCount()) {
                        throw new IllegalArgumentException("The number of capturing groups in the pattern segment " + this.pattern + " does not match the number of URI template variables it defines, which can occur if " + " capturing groups are used in a URI template regex. Use non-capturing groups instead.");
                    }
                    for (int i = 1; i <= matcher.groupCount(); ++i) {
                        String name = this.variableNames.get(i - 1);
                        String value = matcher.group(i);
                        uriTemplateVariables.put(name, value);
                    }
                }
                return true;
            }
            return false;
        }
    }

    private static class AntPatternComparator
    implements Comparator<String> {
        private final String path;

        private AntPatternComparator(String path) {
            this.path = path;
        }

        @Override
        public int compare(String pattern1, String pattern2) {
            int pattern2Length;
            int bracketCount2;
            int totalCount2;
            if (pattern1 == null && pattern2 == null) {
                return 0;
            }
            if (pattern1 == null) {
                return 1;
            }
            if (pattern2 == null) {
                return -1;
            }
            boolean pattern1EqualsPath = pattern1.equals(this.path);
            boolean pattern2EqualsPath = pattern2.equals(this.path);
            if (pattern1EqualsPath && pattern2EqualsPath) {
                return 0;
            }
            if (pattern1EqualsPath) {
                return -1;
            }
            if (pattern2EqualsPath) {
                return 1;
            }
            int wildCardCount1 = this.getWildCardCount(pattern1);
            int wildCardCount2 = this.getWildCardCount(pattern2);
            int bracketCount1 = AntPathMatcher.countOccurrencesOf(pattern1, "{");
            int totalCount1 = wildCardCount1 + bracketCount1;
            if (totalCount1 != (totalCount2 = wildCardCount2 + (bracketCount2 = AntPathMatcher.countOccurrencesOf(pattern2, "{")))) {
                return totalCount1 - totalCount2;
            }
            int pattern1Length = this.getPatternLength(pattern1);
            if (pattern1Length != (pattern2Length = this.getPatternLength(pattern2))) {
                return pattern2Length - pattern1Length;
            }
            if (wildCardCount1 < wildCardCount2) {
                return -1;
            }
            if (wildCardCount2 < wildCardCount1) {
                return 1;
            }
            if (bracketCount1 < bracketCount2) {
                return -1;
            }
            if (bracketCount2 < bracketCount1) {
                return 1;
            }
            return 0;
        }

        private int getWildCardCount(String pattern) {
            if (pattern.endsWith(".*")) {
                pattern = pattern.substring(0, pattern.length() - 2);
            }
            return AntPathMatcher.countOccurrencesOf(pattern, "*");
        }

        private int getPatternLength(String pattern) {
            Matcher m = VARIABLE_PATTERN.matcher(pattern);
            return m.replaceAll("#").length();
        }
    }
}

