/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import com.google.auto.value.AutoValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.runners.core.KeyedWorkItem;
import org.apache.beam.runners.core.KeyedWorkItems;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.runners.direct.AutoValue_QuiescenceDriver_WorkUpdate;
import org.apache.beam.runners.direct.BundleProcessor;
import org.apache.beam.runners.direct.CommittedBundle;
import org.apache.beam.runners.direct.CommittedResult;
import org.apache.beam.runners.direct.CompletionCallback;
import org.apache.beam.runners.direct.DirectGraph;
import org.apache.beam.runners.direct.EvaluationContext;
import org.apache.beam.runners.direct.TransformResult;
import org.apache.beam.runners.direct.WatermarkManager;
import org.apache.beam.runners.local.ExecutionDriver;
import org.apache.beam.runners.local.PipelineMessageReceiver;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.WindowedValues;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QuiescenceDriver
implements ExecutionDriver {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(QuiescenceDriver.class);
    private final @UnknownKeyFor @NonNull @Initialized EvaluationContext evaluationContext;
    private final @UnknownKeyFor @NonNull @Initialized DirectGraph graph;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized BundleProcessor<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> bundleProcessor;
    private final @UnknownKeyFor @NonNull @Initialized PipelineMessageReceiver pipelineMessageReceiver;
    private final @UnknownKeyFor @NonNull @Initialized CompletionCallback defaultCompletionCallback = new TimerIterableCompletionCallback(Collections.emptyList());
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Queue<@UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> pendingRootBundles;
    private final @UnknownKeyFor @NonNull @Initialized Queue<@UnknownKeyFor @NonNull @Initialized WorkUpdate> pendingWork = new ConcurrentLinkedQueue<WorkUpdate>();
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> inflightBundles = Maps.newHashMap();
    private final @UnknownKeyFor @NonNull @Initialized AtomicReference<@UnknownKeyFor @NonNull @Initialized ExecutorState> state = new AtomicReference<ExecutorState>(ExecutorState.QUIESCENT);
    private final @UnknownKeyFor @NonNull @Initialized AtomicLong outstandingWork = new AtomicLong(0L);
    private @UnknownKeyFor @NonNull @Initialized boolean exceptionThrown = false;

    public static @UnknownKeyFor @NonNull @Initialized ExecutionDriver create(@UnknownKeyFor @NonNull @Initialized EvaluationContext context, @UnknownKeyFor @NonNull @Initialized DirectGraph graph, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized BundleProcessor<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> bundleProcessor, @UnknownKeyFor @NonNull @Initialized PipelineMessageReceiver messageReceiver, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Queue<@UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> initialBundles) {
        return new QuiescenceDriver(context, graph, bundleProcessor, messageReceiver, initialBundles);
    }

    private QuiescenceDriver(@UnknownKeyFor @NonNull @Initialized EvaluationContext evaluationContext, @UnknownKeyFor @NonNull @Initialized DirectGraph graph, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized BundleProcessor<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> bundleProcessor, @UnknownKeyFor @NonNull @Initialized PipelineMessageReceiver pipelineMessageReceiver, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Queue<@UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> pendingRootBundles) {
        this.evaluationContext = evaluationContext;
        this.graph = graph;
        this.bundleProcessor = bundleProcessor;
        this.pipelineMessageReceiver = pipelineMessageReceiver;
        this.pendingRootBundles = pendingRootBundles;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized ExecutionDriver.DriverState drive() {
        boolean noWorkOutstanding = this.outstandingWork.get() == 0L;
        ExecutorState startingState = this.state.get();
        if (startingState == ExecutorState.ACTIVE) {
            this.state.compareAndSet(ExecutorState.ACTIVE, ExecutorState.PROCESSING);
        } else if (startingState == ExecutorState.PROCESSING && noWorkOutstanding) {
            this.state.compareAndSet(ExecutorState.PROCESSING, ExecutorState.QUIESCING);
        } else if (startingState == ExecutorState.QUIESCING && noWorkOutstanding) {
            this.state.compareAndSet(ExecutorState.QUIESCING, ExecutorState.QUIESCENT);
        }
        this.fireTimers();
        ArrayList<WorkUpdate> updates = new ArrayList<WorkUpdate>();
        WorkUpdate pendingUpdate = this.pendingWork.poll();
        while (pendingUpdate != null) {
            updates.add(pendingUpdate);
            pendingUpdate = this.pendingWork.poll();
        }
        for (WorkUpdate update : updates) {
            this.applyUpdate(noWorkOutstanding, startingState, update);
        }
        this.addWorkIfNecessary();
        if (this.exceptionThrown) {
            return ExecutionDriver.DriverState.FAILED;
        }
        if (this.evaluationContext.isDone()) {
            return ExecutionDriver.DriverState.SHUTDOWN;
        }
        return ExecutionDriver.DriverState.CONTINUE;
    }

    private void applyUpdate(@UnknownKeyFor @NonNull @Initialized boolean noWorkOutstanding, @UnknownKeyFor @NonNull @Initialized ExecutorState startingState, @UnknownKeyFor @NonNull @Initialized WorkUpdate update) {
        LOG.debug("Executor Update: {}", (Object)update);
        if (update.getBundle().isPresent()) {
            if (ExecutorState.ACTIVE == startingState || ExecutorState.PROCESSING == startingState && noWorkOutstanding) {
                CommittedBundle<?> bundle = update.getBundle().get();
                for (AppliedPTransform<?, ?, ?> consumer : update.getConsumers()) {
                    this.processBundle(bundle, consumer);
                }
            } else {
                this.pendingWork.offer(update);
            }
        } else if (update.getException().isPresent()) {
            this.pipelineMessageReceiver.failed(update.getException().get());
            this.exceptionThrown = true;
        }
    }

    private void processBundle(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> bundle, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> consumer) {
        this.processBundle(bundle, consumer, this.defaultCompletionCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBundle(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> bundle, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> consumer, @UnknownKeyFor @NonNull @Initialized CompletionCallback callback) {
        Map<AppliedPTransform<?, ?, ?>, Collection<CommittedBundle<?>>> map = this.inflightBundles;
        synchronized (map) {
            this.inflightBundles.compute(consumer, (k, v) -> {
                if (v == null) {
                    v = new ArrayList<CommittedBundle>();
                }
                v.add(bundle);
                return v;
            });
        }
        this.outstandingWork.incrementAndGet();
        this.bundleProcessor.process(bundle, consumer, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTimers() {
        try {
            Map<AppliedPTransform<?, ?, ?>, Collection<CommittedBundle<?>>> map = this.inflightBundles;
            synchronized (map) {
                for (WatermarkManager.FiredTimers<AppliedPTransform<?, ?, ?>> transformTimers : this.evaluationContext.extractFiredTimers(this.inflightBundles.keySet())) {
                    Collection<TimerInternals.TimerData> delivery = transformTimers.getTimers();
                    KeyedWorkItem work = KeyedWorkItems.timersWorkItem(transformTimers.getKey().getKey(), delivery);
                    CommittedBundle bundle = this.evaluationContext.createKeyedBundle(transformTimers.getKey(), (PCollection)Iterables.getOnlyElement(transformTimers.getExecutable().getMainInputs().values())).add(WindowedValues.valueInGlobalWindow(work)).commit(this.evaluationContext.now());
                    this.processBundle(bundle, transformTimers.getExecutable(), new TimerIterableCompletionCallback(delivery));
                    this.state.set(ExecutorState.ACTIVE);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Internal Error while delivering timers", (Throwable)e);
            this.pipelineMessageReceiver.failed(e);
            this.exceptionThrown = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWorkIfNecessary() {
        if (this.state.get() == ExecutorState.QUIESCENT) {
            Map<AppliedPTransform<?, ?, ?>, Queue<CommittedBundle<?>>> map = this.pendingRootBundles;
            synchronized (map) {
                for (Map.Entry<AppliedPTransform<?, ?, ?>, Queue<CommittedBundle<?>>> pendingRootEntry : this.pendingRootBundles.entrySet()) {
                    ArrayList bundles = new ArrayList();
                    while (!pendingRootEntry.getValue().isEmpty()) {
                        CommittedBundle<?> bundle = pendingRootEntry.getValue().poll();
                        bundles.add(bundle);
                    }
                    for (CommittedBundle committedBundle : bundles) {
                        this.processBundle(committedBundle, pendingRootEntry.getKey());
                        this.state.set(ExecutorState.ACTIVE);
                    }
                }
            }
        }
    }

    @AutoValue
    static abstract class WorkUpdate {
        WorkUpdate() {
        }

        private static @UnknownKeyFor @NonNull @Initialized WorkUpdate fromBundle(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> bundle, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> consumers) {
            return new AutoValue_QuiescenceDriver_WorkUpdate(Optional.of(bundle), consumers, Optional.empty());
        }

        private static @UnknownKeyFor @NonNull @Initialized WorkUpdate fromException(@UnknownKeyFor @NonNull @Initialized Exception e) {
            return new AutoValue_QuiescenceDriver_WorkUpdate(Optional.empty(), Collections.emptyList(), Optional.of(e));
        }

        public abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Optional<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getBundle();

        public abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> getConsumers();

        public abstract @UnknownKeyFor @NonNull @Initialized Optional<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Exception> getException();
    }

    private class TimerIterableCompletionCallback
    implements CompletionCallback {
        private final @UnknownKeyFor @NonNull @Initialized Iterable< @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> timers;

        TimerIterableCompletionCallback(Iterable<TimerInternals.TimerData> timers) {
            this.timers = timers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final @UnknownKeyFor @NonNull @Initialized CommittedResult handleResult(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> inputBundle, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TransformResult<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> result) {
            Map map;
            CommittedResult<AppliedPTransform<?, ?, ?>> committedResult = QuiescenceDriver.this.evaluationContext.handleResult(inputBundle, this.timers, result);
            for (CommittedBundle<?> outputBundle : committedResult.getOutputs()) {
                QuiescenceDriver.this.pendingWork.offer(WorkUpdate.fromBundle(outputBundle, QuiescenceDriver.this.graph.getPerElementConsumers((PValue)outputBundle.getPCollection())));
            }
            Optional<CommittedBundle<?>> unprocessedInputs = committedResult.getUnprocessedInputs();
            if (unprocessedInputs.isPresent()) {
                if (inputBundle.getPCollection() == null) {
                    map = QuiescenceDriver.this.pendingRootBundles;
                    synchronized (map) {
                        ((Queue)QuiescenceDriver.this.pendingRootBundles.get(result.getTransform())).offer(unprocessedInputs.get());
                    }
                } else {
                    QuiescenceDriver.this.pendingWork.offer(WorkUpdate.fromBundle(unprocessedInputs.get(), Collections.singleton(committedResult.getExecutable())));
                }
            }
            if (!committedResult.getProducedOutputTypes().isEmpty()) {
                QuiescenceDriver.this.state.set(ExecutorState.ACTIVE);
            }
            map = QuiescenceDriver.this.inflightBundles;
            synchronized (map) {
                QuiescenceDriver.this.inflightBundles.compute(result.getTransform(), (k, v) -> {
                    v.remove(inputBundle);
                    return v.isEmpty() ? null : v;
                });
            }
            QuiescenceDriver.this.outstandingWork.decrementAndGet();
            return committedResult;
        }

        @Override
        public void handleEmpty(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
            QuiescenceDriver.this.outstandingWork.decrementAndGet();
        }

        @Override
        public final void handleException(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> inputBundle, @UnknownKeyFor @NonNull @Initialized Exception e) {
            QuiescenceDriver.this.pendingWork.offer(WorkUpdate.fromException(e));
            QuiescenceDriver.this.outstandingWork.decrementAndGet();
        }

        @Override
        public void handleError(@UnknownKeyFor @NonNull @Initialized Error err) {
            QuiescenceDriver.this.pipelineMessageReceiver.failed(err);
        }
    }

    private static enum ExecutorState {
        ACTIVE,
        PROCESSING,
        QUIESCING,
        QUIESCENT;

    }
}

