/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.channel;

import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.fn.channel.SocketAddressFactory;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.ClientInterceptor;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.ManagedChannel;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.ManagedChannelBuilder;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.inprocess.InProcessChannelBuilder;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.netty.NettyChannelBuilder;
import org.apache.beam.vendor.grpc.v1p69p0.io.netty.channel.EventLoopGroup;
import org.apache.beam.vendor.grpc.v1p69p0.io.netty.channel.epoll.Epoll;
import org.apache.beam.vendor.grpc.v1p69p0.io.netty.channel.epoll.EpollDomainSocketChannel;
import org.apache.beam.vendor.grpc.v1p69p0.io.netty.channel.epoll.EpollEventLoopGroup;
import org.apache.beam.vendor.grpc.v1p69p0.io.netty.channel.epoll.EpollSocketChannel;
import org.apache.beam.vendor.grpc.v1p69p0.io.netty.channel.unix.DomainSocketAddress;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ManagedChannelFactory {
    private final @UnknownKeyFor @NonNull @Initialized Type type;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ClientInterceptor> interceptors;
    private final @UnknownKeyFor @NonNull @Initialized boolean directExecutor;

    public static @UnknownKeyFor @NonNull @Initialized ManagedChannelFactory createDefault() {
        return new ManagedChannelFactory(Type.DEFAULT, Collections.emptyList(), false);
    }

    public static @UnknownKeyFor @NonNull @Initialized ManagedChannelFactory createEpoll() {
        Epoll.ensureAvailability();
        return new ManagedChannelFactory(Type.EPOLL, Collections.emptyList(), false);
    }

    public static @UnknownKeyFor @NonNull @Initialized ManagedChannelFactory createInProcess() {
        return new ManagedChannelFactory(Type.IN_PROCESS, Collections.emptyList(), false);
    }

    public @UnknownKeyFor @NonNull @Initialized ManagedChannel forDescriptor(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Endpoints.ApiServiceDescriptor apiServiceDescriptor) {
        ManagedChannelBuilder channelBuilder;
        switch (this.type) {
            case EPOLL: {
                SocketAddress address = SocketAddressFactory.createFrom(apiServiceDescriptor.getUrl());
                channelBuilder = NettyChannelBuilder.forAddress((SocketAddress)address).channelType(address instanceof DomainSocketAddress ? EpollDomainSocketChannel.class : EpollSocketChannel.class).eventLoopGroup((EventLoopGroup)new EpollEventLoopGroup());
                break;
            }
            case DEFAULT: {
                channelBuilder = ManagedChannelBuilder.forTarget((String)apiServiceDescriptor.getUrl());
                break;
            }
            case IN_PROCESS: {
                channelBuilder = InProcessChannelBuilder.forName((String)apiServiceDescriptor.getUrl());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type " + (Object)((Object)this.type));
            }
        }
        channelBuilder = channelBuilder.usePlaintext().maxInboundMessageSize(Integer.MAX_VALUE).disableRetry().intercept(this.interceptors);
        if (this.directExecutor) {
            channelBuilder = channelBuilder.directExecutor();
        }
        return channelBuilder.build();
    }

    private ManagedChannelFactory(@UnknownKeyFor @NonNull @Initialized Type type, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ClientInterceptor> interceptors, @UnknownKeyFor @NonNull @Initialized boolean directExecutor) {
        this.type = type;
        this.interceptors = interceptors;
        this.directExecutor = directExecutor;
    }

    public @UnknownKeyFor @NonNull @Initialized ManagedChannelFactory withInterceptors(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ClientInterceptor> interceptors) {
        return new ManagedChannelFactory(this.type, (List<ClientInterceptor>)ImmutableList.builder().addAll(this.interceptors).addAll(interceptors).build(), this.directExecutor);
    }

    public @UnknownKeyFor @NonNull @Initialized ManagedChannelFactory withDirectExecutor() {
        return new ManagedChannelFactory(this.type, this.interceptors, true);
    }

    private static enum Type {
        EPOLL,
        DEFAULT,
        IN_PROCESS;

    }
}

