/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode.coder;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.erasurecode.ECBlock;
import org.apache.hadoop.io.erasurecode.ECChunk;
import org.apache.hadoop.io.erasurecode.coder.HHErasureCodingStep;
import org.apache.hadoop.io.erasurecode.coder.util.HHUtil;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureDecoder;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureEncoder;

@InterfaceAudience.Private
public class HHXORErasureDecodingStep
extends HHErasureCodingStep {
    private int pbIndex;
    private int[] piggyBackIndex;
    private int[] piggyBackFullIndex;
    private int[] erasedIndexes;
    private RawErasureDecoder rsRawDecoder;
    private RawErasureEncoder xorRawEncoder;

    public HHXORErasureDecodingStep(ECBlock[] inputBlocks, int[] erasedIndexes, ECBlock[] outputBlocks, RawErasureDecoder rawDecoder, RawErasureEncoder rawEncoder) {
        super(inputBlocks, outputBlocks);
        this.pbIndex = rawDecoder.getNumParityUnits() - 1;
        this.erasedIndexes = erasedIndexes;
        this.rsRawDecoder = rawDecoder;
        this.xorRawEncoder = rawEncoder;
        this.piggyBackIndex = HHUtil.initPiggyBackIndexWithoutPBVec(rawDecoder.getNumDataUnits(), rawDecoder.getNumParityUnits());
        this.piggyBackFullIndex = HHUtil.initPiggyBackFullIndexVec(rawDecoder.getNumDataUnits(), this.piggyBackIndex);
    }

    @Override
    public void performCoding(ECChunk[] inputChunks, ECChunk[] outputChunks) throws IOException {
        if (this.erasedIndexes.length == 0) {
            return;
        }
        ByteBuffer[] inputBuffers = ECChunk.toBuffers(inputChunks);
        ByteBuffer[] outputBuffers = ECChunk.toBuffers(outputChunks);
        this.performCoding(inputBuffers, outputBuffers);
    }

    private void performCoding(ByteBuffer[] inputs, ByteBuffer[] outputs) throws IOException {
        int numDataUnits = this.rsRawDecoder.getNumDataUnits();
        int numParityUnits = this.rsRawDecoder.getNumParityUnits();
        int numTotalUnits = numDataUnits + numParityUnits;
        int subPacketSize = this.getSubPacketSize();
        ByteBuffer fisrtValidInput = HHUtil.findFirstValidInput(inputs);
        int bufSize = fisrtValidInput.remaining();
        if (inputs.length != numTotalUnits * this.getSubPacketSize()) {
            throw new IllegalArgumentException("Invalid inputs length");
        }
        if (outputs.length != this.erasedIndexes.length * this.getSubPacketSize()) {
            throw new IllegalArgumentException("Invalid outputs length");
        }
        ByteBuffer[][] newIn = new ByteBuffer[subPacketSize][numTotalUnits];
        for (int i = 0; i < subPacketSize; ++i) {
            for (int j = 0; j < numTotalUnits; ++j) {
                newIn[i][j] = inputs[i * numTotalUnits + j];
            }
        }
        ByteBuffer[][] newOut = new ByteBuffer[subPacketSize][this.erasedIndexes.length];
        for (int i = 0; i < subPacketSize; ++i) {
            for (int j = 0; j < this.erasedIndexes.length; ++j) {
                newOut[i][j] = outputs[i * this.erasedIndexes.length + j];
            }
        }
        if (this.erasedIndexes.length == 1 && this.erasedIndexes[0] < numDataUnits) {
            this.doDecodeSingle(newIn, newOut, this.erasedIndexes[0], bufSize, fisrtValidInput.isDirect());
        } else {
            this.doDecodeMultiAndParity(newIn, newOut, this.erasedIndexes, bufSize);
        }
    }

    private void doDecodeSingle(ByteBuffer[][] inputs, ByteBuffer[][] outputs, int erasedLocationToFix, int bufSize, boolean isDirect) throws IOException {
        int numDataUnits = this.rsRawDecoder.getNumDataUnits();
        int numParityUnits = this.rsRawDecoder.getNumParityUnits();
        int subPacketSize = this.getSubPacketSize();
        int[][] inputPositions = new int[subPacketSize][inputs[0].length];
        for (int i = 0; i < subPacketSize; ++i) {
            for (int j = 0; j < inputs[i].length; ++j) {
                if (inputs[i][j] == null) continue;
                inputPositions[i][j] = inputs[i][j].position();
            }
        }
        ByteBuffer[] tempInputs = new ByteBuffer[numDataUnits + numParityUnits];
        for (int i = 0; i < tempInputs.length; ++i) {
            tempInputs[i] = inputs[1][i];
        }
        ByteBuffer[][] tmpOutputs = new ByteBuffer[subPacketSize][numParityUnits];
        for (int i = 0; i < this.getSubPacketSize(); ++i) {
            for (int j = 0; j < this.erasedIndexes.length; ++j) {
                tmpOutputs[i][j] = outputs[i][j];
            }
            for (int m3 = this.erasedIndexes.length; m3 < numParityUnits; ++m3) {
                tmpOutputs[i][m3] = HHUtil.allocateByteBuffer(isDirect, bufSize);
            }
        }
        int[] erasedLocation = new int[numParityUnits];
        erasedLocation[0] = erasedLocationToFix;
        for (int i = 1; i < numParityUnits; ++i) {
            erasedLocation[i] = numDataUnits + i;
            tempInputs[numDataUnits + i] = null;
        }
        this.rsRawDecoder.decode(tempInputs, erasedLocation, tmpOutputs[1]);
        int piggyBackParityIndex = this.piggyBackFullIndex[erasedLocationToFix];
        ByteBuffer piggyBack = HHUtil.getPiggyBackForDecode(inputs, tmpOutputs, piggyBackParityIndex, numDataUnits, numParityUnits, this.pbIndex);
        if (isDirect) {
            int idxToWrite = 0;
            this.doDecodeByPiggyBack(inputs[0], tmpOutputs[0][idxToWrite], piggyBack, erasedLocationToFix);
        } else {
            ByteBuffer buffer;
            int j;
            int i;
            byte[][][] newInputs = new byte[this.getSubPacketSize()][inputs[0].length][];
            int[][] inputOffsets = new int[this.getSubPacketSize()][inputs[0].length];
            byte[][][] newOutputs = new byte[this.getSubPacketSize()][numParityUnits][];
            int[][] outOffsets = new int[this.getSubPacketSize()][numParityUnits];
            for (i = 0; i < this.getSubPacketSize(); ++i) {
                for (j = 0; j < inputs[0].length; ++j) {
                    buffer = inputs[i][j];
                    if (buffer == null) continue;
                    inputOffsets[i][j] = buffer.arrayOffset() + buffer.position();
                    newInputs[i][j] = buffer.array();
                }
            }
            for (i = 0; i < this.getSubPacketSize(); ++i) {
                for (j = 0; j < numParityUnits; ++j) {
                    buffer = tmpOutputs[i][j];
                    if (buffer == null) continue;
                    outOffsets[i][j] = buffer.arrayOffset() + buffer.position();
                    newOutputs[i][j] = buffer.array();
                }
            }
            byte[] newPiggyBack = piggyBack.array();
            int idxToWrite = 0;
            this.doDecodeByPiggyBack(newInputs[0], inputOffsets[0], newOutputs[0][idxToWrite], outOffsets[0][idxToWrite], newPiggyBack, erasedLocationToFix, bufSize);
        }
        for (int i = 0; i < subPacketSize; ++i) {
            for (int j = 0; j < inputs[i].length; ++j) {
                if (inputs[i][j] == null) continue;
                inputs[i][j].position(inputPositions[i][j] + bufSize);
            }
        }
    }

    private void doDecodeByPiggyBack(ByteBuffer[] inputs, ByteBuffer outputs, ByteBuffer piggyBack, int erasedLocationToFix) {
        int thisPiggyBackSetIdx = this.piggyBackFullIndex[erasedLocationToFix];
        int startIndex = this.piggyBackIndex[thisPiggyBackSetIdx - 1];
        int endIndex = this.piggyBackIndex[thisPiggyBackSetIdx];
        int bufSize = piggyBack.remaining();
        for (int i = piggyBack.position(); i < piggyBack.position() + bufSize; ++i) {
            for (int j = startIndex; j < endIndex; ++j) {
                if (inputs[j] == null) continue;
                piggyBack.put(i, (byte)(piggyBack.get(i) ^ inputs[j].get(inputs[j].position() + i)));
            }
            outputs.put(outputs.position() + i, piggyBack.get(i));
        }
    }

    private void doDecodeByPiggyBack(byte[][] inputs, int[] inputOffsets, byte[] outputs, int outOffset, byte[] piggyBack, int erasedLocationToFix, int bufSize) {
        int thisPiggyBackSetIdx = this.piggyBackFullIndex[erasedLocationToFix];
        int startIndex = this.piggyBackIndex[thisPiggyBackSetIdx - 1];
        int endIndex = this.piggyBackIndex[thisPiggyBackSetIdx];
        for (int i = 0; i < bufSize; ++i) {
            for (int j = startIndex; j < endIndex; ++j) {
                if (inputs[j] == null) continue;
                piggyBack[i] = (byte)(piggyBack[i] ^ inputs[j][i + inputOffsets[j]]);
            }
            outputs[i + outOffset] = piggyBack[i];
        }
    }

    private void doDecodeMultiAndParity(ByteBuffer[][] inputs, ByteBuffer[][] outputs, int[] erasedLocationToFix, int bufSize) throws IOException {
        int j;
        int i;
        int i2;
        int numDataUnits = this.rsRawDecoder.getNumDataUnits();
        int numParityUnits = this.rsRawDecoder.getNumParityUnits();
        int numTotalUnits = numDataUnits + numParityUnits;
        int[] parityToFixFlag = new int[numTotalUnits];
        for (int i3 = 0; i3 < erasedLocationToFix.length; ++i3) {
            if (erasedLocationToFix[i3] < numDataUnits) continue;
            parityToFixFlag[erasedLocationToFix[i3]] = 1;
        }
        int[] inputPositions = new int[inputs[0].length];
        for (i2 = 0; i2 < inputPositions.length; ++i2) {
            if (inputs[0][i2] == null) continue;
            inputPositions[i2] = inputs[0][i2].position();
        }
        this.rsRawDecoder.decode(inputs[0], erasedLocationToFix, outputs[0]);
        for (i2 = 0; i2 < inputs[0].length; ++i2) {
            if (inputs[0][i2] == null) continue;
            inputs[0][i2].position(inputPositions[i2]);
        }
        ByteBuffer[] tempInput = new ByteBuffer[numDataUnits];
        for (i = 0; i < numDataUnits; ++i) {
            tempInput[i] = inputs[0][i];
        }
        for (i = 0; i < erasedLocationToFix.length; ++i) {
            if (erasedLocationToFix[i] >= numDataUnits) continue;
            tempInput[erasedLocationToFix[i]] = outputs[0][i];
        }
        ByteBuffer[] piggyBack = HHUtil.getPiggyBacksFromInput(tempInput, this.piggyBackIndex, numParityUnits, 0, this.xorRawEncoder);
        for (j = numDataUnits + 1; j < numTotalUnits; ++j) {
            if (parityToFixFlag[j] != 0 || inputs[1][j] == null) continue;
            int k = inputs[1][j].position();
            int m3 = piggyBack[j - numDataUnits - 1].position();
            while (k < inputs[1][j].limit()) {
                inputs[1][j].put(k, (byte)(inputs[1][j].get(k) ^ piggyBack[j - numDataUnits - 1].get(m3)));
                ++k;
                ++m3;
            }
        }
        this.rsRawDecoder.decode(inputs[1], erasedLocationToFix, outputs[1]);
        for (j = 0; j < erasedLocationToFix.length; ++j) {
            if (erasedLocationToFix[j] >= numTotalUnits || erasedLocationToFix[j] <= numDataUnits) continue;
            int parityIndex = erasedLocationToFix[j] - numDataUnits - 1;
            int k = outputs[1][j].position();
            int m4 = piggyBack[parityIndex].position();
            while (k < outputs[1][j].limit()) {
                outputs[1][j].put(k, (byte)(outputs[1][j].get(k) ^ piggyBack[parityIndex].get(m4)));
                ++k;
                ++m4;
            }
        }
        for (int i4 = 0; i4 < inputs[0].length; ++i4) {
            if (inputs[0][i4] == null) continue;
            inputs[0][i4].position(inputPositions[i4] + bufSize);
        }
    }
}

