/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell.find;

import java.io.IOException;
import java.util.Deque;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.fs.shell.find.Expression;
import org.apache.hadoop.fs.shell.find.FindOptions;
import org.apache.hadoop.fs.shell.find.Result;

public abstract class FilterExpression
implements Expression,
Configurable {
    protected Expression expression;

    protected FilterExpression(Expression expression) {
        this.expression = expression;
    }

    @Override
    public void setOptions(FindOptions options) throws IOException {
        if (this.expression != null) {
            this.expression.setOptions(options);
        }
    }

    @Override
    public void prepare() throws IOException {
        if (this.expression != null) {
            this.expression.prepare();
        }
    }

    @Override
    public Result apply(PathData item, int depth) throws IOException {
        if (this.expression != null) {
            return this.expression.apply(item, -1);
        }
        return Result.PASS;
    }

    @Override
    public void finish() throws IOException {
        if (this.expression != null) {
            this.expression.finish();
        }
    }

    @Override
    public String[] getUsage() {
        if (this.expression != null) {
            return this.expression.getUsage();
        }
        return null;
    }

    @Override
    public String[] getHelp() {
        if (this.expression != null) {
            return this.expression.getHelp();
        }
        return null;
    }

    @Override
    public boolean isAction() {
        if (this.expression != null) {
            return this.expression.isAction();
        }
        return false;
    }

    @Override
    public boolean isOperator() {
        if (this.expression != null) {
            return this.expression.isOperator();
        }
        return false;
    }

    @Override
    public int getPrecedence() {
        if (this.expression != null) {
            return this.expression.getPrecedence();
        }
        return -1;
    }

    @Override
    public void addChildren(Deque<Expression> expressions) {
        if (this.expression != null) {
            this.expression.addChildren(expressions);
        }
    }

    @Override
    public void addArguments(Deque<String> args2) {
        if (this.expression != null) {
            this.expression.addArguments(args2);
        }
    }

    @Override
    public void setConf(Configuration conf) {
        if (this.expression instanceof Configurable) {
            ((Configurable)((Object)this.expression)).setConf(conf);
        }
    }

    @Override
    public Configuration getConf() {
        if (this.expression instanceof Configurable) {
            return ((Configurable)((Object)this.expression)).getConf();
        }
        return null;
    }

    public String toString() {
        if (this.expression != null) {
            return this.getClass().getSimpleName() + "-" + this.expression.toString();
        }
        return this.getClass().getSimpleName();
    }
}

