/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownThreadsHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ShutdownThreadsHelper.class);
    @VisibleForTesting
    static final int SHUTDOWN_WAIT_MS = 3000;

    public static boolean shutdownThread(Thread thread2) {
        return ShutdownThreadsHelper.shutdownThread(thread2, 3000L);
    }

    public static boolean shutdownThread(Thread thread2, long timeoutInMilliSeconds) {
        if (thread2 == null) {
            return true;
        }
        try {
            thread2.interrupt();
            thread2.join(timeoutInMilliSeconds);
            return true;
        }
        catch (InterruptedException ie) {
            LOG.warn("Interrupted while shutting down thread - " + thread2.getName());
            return false;
        }
    }

    public static boolean shutdownExecutorService(ExecutorService service) throws InterruptedException {
        return ShutdownThreadsHelper.shutdownExecutorService(service, 3000L);
    }

    public static boolean shutdownExecutorService(ExecutorService service, long timeoutInMs) throws InterruptedException {
        if (service == null) {
            return true;
        }
        service.shutdown();
        if (!service.awaitTermination(timeoutInMs, TimeUnit.MILLISECONDS)) {
            service.shutdownNow();
            return service.awaitTermination(timeoutInMs, TimeUnit.MILLISECONDS);
        }
        return true;
    }
}

