/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.hadoop2.com.google.common.hash;

import org.apache.flink.shaded.hadoop2.com.google.common.annotations.Beta;
import org.apache.flink.shaded.hadoop2.com.google.common.hash.Funnel;
import org.apache.flink.shaded.hadoop2.com.google.common.hash.Sink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class Funnels {
    private Funnels() {
    }

    public static Funnel<byte[]> byteArrayFunnel() {
        return ByteArrayFunnel.INSTANCE;
    }

    public static Funnel<CharSequence> stringFunnel() {
        return StringFunnel.INSTANCE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum StringFunnel implements Funnel<CharSequence>
    {
        INSTANCE;


        @Override
        public void funnel(CharSequence from, Sink into) {
            into.putString(from);
        }

        public String toString() {
            return "Funnels.stringFunnel()";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ByteArrayFunnel implements Funnel<byte[]>
    {
        INSTANCE;


        @Override
        public void funnel(byte[] from, Sink into) {
            into.putBytes(from);
        }

        public String toString() {
            return "Funnels.byteArrayFunnel()";
        }
    }
}

