/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.hadoop2.com.google.common.math;

import java.math.BigInteger;
import org.apache.flink.shaded.hadoop2.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.shaded.hadoop2.com.google.common.base.Preconditions;

final class DoubleUtils {
    static final long SIGNIFICAND_MASK = 0xFFFFFFFFFFFFFL;
    static final long EXPONENT_MASK = 0x7FF0000000000000L;
    static final long SIGN_MASK = Long.MIN_VALUE;
    static final int SIGNIFICAND_BITS = 52;
    static final int EXPONENT_BIAS = 1023;
    static final int MIN_DOUBLE_EXPONENT = -1022;
    static final int MAX_DOUBLE_EXPONENT = 1023;
    static final long IMPLICIT_BIT = 0x10000000000000L;
    private static final long ONE_BITS = Double.doubleToRawLongBits(1.0);

    private DoubleUtils() {
    }

    static double next(double x, boolean up) {
        if (x == 0.0) {
            return up ? Double.MIN_VALUE : -4.9E-324;
        }
        long bits = Double.doubleToRawLongBits(x);
        bits = x < 0.0 == up ? --bits : ++bits;
        return Double.longBitsToDouble(bits);
    }

    @VisibleForTesting
    static int getExponent(double d) {
        long bits = Double.doubleToRawLongBits(d);
        int exponent = (int)((bits & 0x7FF0000000000000L) >> 52);
        return exponent -= 1023;
    }

    static strictfp double scalb(double d, int scale) {
        int exponent = DoubleUtils.getExponent(d);
        switch (exponent) {
            case 1024: {
                return d;
            }
            case -1023: {
                return d * StrictMath.pow(2.0, scale);
            }
        }
        int newExponent = exponent + scale;
        if (-1022 <= newExponent & newExponent <= 1023) {
            long bits = Double.doubleToRawLongBits(d);
            bits &= 0x800FFFFFFFFFFFFFL;
            return Double.longBitsToDouble(bits |= (long)(newExponent + 1023) << 52);
        }
        return d * StrictMath.pow(2.0, scale);
    }

    static long getSignificand(double d) {
        Preconditions.checkArgument(DoubleUtils.isFinite(d), "not a normal value");
        int exponent = DoubleUtils.getExponent(d);
        long bits = Double.doubleToRawLongBits(d);
        return exponent == -1023 ? bits << 1 : (bits &= 0xFFFFFFFFFFFFFL) | 0x10000000000000L;
    }

    static boolean isFinite(double d) {
        return DoubleUtils.getExponent(d) <= 1023;
    }

    static boolean isNormal(double d) {
        return DoubleUtils.getExponent(d) >= -1022;
    }

    static double scaleNormalize(double x) {
        long significand = Double.doubleToRawLongBits(x) & 0xFFFFFFFFFFFFFL;
        return Double.longBitsToDouble(significand | ONE_BITS);
    }

    static double bigToDouble(BigInteger x) {
        BigInteger absX = x.abs();
        int exponent = absX.bitLength() - 1;
        if (exponent < 63) {
            return x.longValue();
        }
        if (exponent > 1023) {
            return (double)x.signum() * Double.POSITIVE_INFINITY;
        }
        int shift = exponent - 52 - 1;
        long twiceSignifFloor = absX.shiftRight(shift).longValue();
        long signifFloor = twiceSignifFloor >> 1;
        boolean increment = (twiceSignifFloor & 1L) != 0L && (((signifFloor &= 0xFFFFFFFFFFFFFL) & 1L) != 0L || absX.getLowestSetBit() < shift);
        long signifRounded = increment ? signifFloor + 1L : signifFloor;
        long bits = (long)(exponent + 1023) << 52;
        bits += signifRounded;
        return Double.longBitsToDouble(bits |= (long)x.signum() & Long.MIN_VALUE);
    }
}

