/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.hadoop2.io.netty.handler.codec.protobuf;

import org.apache.flink.shaded.hadoop2.com.google.protobuf.CodedOutputStream;
import org.apache.flink.shaded.hadoop2.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.hadoop2.io.netty.buffer.ByteBufOutputStream;
import org.apache.flink.shaded.hadoop2.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.hadoop2.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.hadoop2.io.netty.handler.codec.MessageToByteEncoder;

@ChannelHandler.Sharable
public class ProtobufVarint32LengthFieldPrepender
extends MessageToByteEncoder<ByteBuf> {
    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out) throws Exception {
        int bodyLen = msg.readableBytes();
        int headerLen = CodedOutputStream.computeRawVarint32Size(bodyLen);
        out.ensureWritable(headerLen + bodyLen);
        CodedOutputStream headerOut = CodedOutputStream.newInstance(new ByteBufOutputStream(out), headerLen);
        headerOut.writeRawVarint32(bodyLen);
        headerOut.flush();
        out.writeBytes(msg, msg.readerIndex(), bodyLen);
    }
}

