/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.hadoop2.io.netty.handler.codec.rtsp;

import org.apache.flink.shaded.hadoop2.io.netty.handler.codec.http.DefaultHttpResponse;
import org.apache.flink.shaded.hadoop2.io.netty.handler.codec.http.HttpMessage;
import org.apache.flink.shaded.hadoop2.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.shaded.hadoop2.io.netty.handler.codec.rtsp.RtspObjectDecoder;
import org.apache.flink.shaded.hadoop2.io.netty.handler.codec.rtsp.RtspVersions;

public class RtspResponseDecoder
extends RtspObjectDecoder {
    private static final HttpResponseStatus UNKNOWN_STATUS = new HttpResponseStatus(999, "Unknown");

    public RtspResponseDecoder() {
    }

    public RtspResponseDecoder(int maxInitialLineLength, int maxHeaderSize, int maxContentLength) {
        super(maxInitialLineLength, maxHeaderSize, maxContentLength);
    }

    public RtspResponseDecoder(int maxInitialLineLength, int maxHeaderSize, int maxContentLength, boolean validateHeaders) {
        super(maxInitialLineLength, maxHeaderSize, maxContentLength, validateHeaders);
    }

    @Override
    protected HttpMessage createMessage(String[] initialLine) throws Exception {
        return new DefaultHttpResponse(RtspVersions.valueOf(initialLine[0]), new HttpResponseStatus(Integer.parseInt(initialLine[1]), initialLine[2]), this.validateHeaders);
    }

    @Override
    protected HttpMessage createInvalidMessage() {
        return new DefaultHttpResponse(RtspVersions.RTSP_1_0, UNKNOWN_STATUS, this.validateHeaders);
    }

    @Override
    protected boolean isDecodingRequest() {
        return false;
    }
}

