/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.TimeZone;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.PathData;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class Stat
extends FsCommand {
    private static final String NEWLINE = System.getProperty("line.separator");
    public static final String NAME = "stat";
    public static final String USAGE = "[format] <path> ...";
    public static final String DESCRIPTION = "Print statistics about the file/directory at <path>" + NEWLINE + "in the specified format. Format accepts filesize in" + NEWLINE + "blocks (%b), type (%F), group name of owner (%g)," + NEWLINE + "name (%n), block size (%o), replication (%r), user name" + NEWLINE + "of owner (%u), modification date (%y, %Y)." + NEWLINE + "%y shows UTC date as \"yyyy-MM-dd HH:mm:ss\" and" + NEWLINE + "%Y shows milliseconds since January 1, 1970 UTC." + NEWLINE + "If the format is not specified, %y is used by default." + NEWLINE;
    protected final SimpleDateFormat timeFmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected String format;

    Stat() {
        this.timeFmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.format = "%y";
    }

    public static void registerCommands(CommandFactory factory) {
        factory.addClass(Stat.class, "-stat");
    }

    @Override
    protected void processOptions(LinkedList<String> args) throws IOException {
        CommandFormat cf = new CommandFormat(1, Integer.MAX_VALUE, "R");
        cf.parse(args);
        this.setRecursive(cf.getOpt("R"));
        if (args.getFirst().contains("%")) {
            this.format = args.removeFirst();
        }
        cf.parse(args);
    }

    @Override
    protected void processPath(PathData item) throws IOException {
        FileStatus stat = item.stat;
        StringBuilder buf = new StringBuilder();
        char[] fmt = this.format.toCharArray();
        block11: for (int i = 0; i < fmt.length; ++i) {
            if (fmt[i] != '%') {
                buf.append(fmt[i]);
                continue;
            }
            if (i + 1 == fmt.length) break;
            switch (fmt[++i]) {
                case 'b': {
                    buf.append(stat.getLen());
                    continue block11;
                }
                case 'F': {
                    buf.append(stat.isDirectory() ? "directory" : (stat.isFile() ? "regular file" : "symlink"));
                    continue block11;
                }
                case 'g': {
                    buf.append(stat.getGroup());
                    continue block11;
                }
                case 'n': {
                    buf.append(item.path.getName());
                    continue block11;
                }
                case 'o': {
                    buf.append(stat.getBlockSize());
                    continue block11;
                }
                case 'r': {
                    buf.append(stat.getReplication());
                    continue block11;
                }
                case 'u': {
                    buf.append(stat.getOwner());
                    continue block11;
                }
                case 'y': {
                    buf.append(this.timeFmt.format(new Date(stat.getModificationTime())));
                    continue block11;
                }
                case 'Y': {
                    buf.append(stat.getModificationTime());
                    continue block11;
                }
                default: {
                    buf.append(fmt[i]);
                }
            }
        }
        this.out.println(buf.toString());
    }
}

