/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.shaded.hadoop2.com.google.protobuf.ByteString;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.proto.DatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsServerProtos;
import org.apache.hadoop.hdfs.protocol.proto.JournalProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.security.token.block.BlockKey;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.protocol.BalancerBandwidthCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockIdCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockReportContext;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.CheckpointCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.FinalizeCommand;
import org.apache.hadoop.hdfs.server.protocol.JournalInfo;
import org.apache.hadoop.hdfs.server.protocol.KeyUpdateCommand;
import org.apache.hadoop.hdfs.server.protocol.NNHAStatusHeartbeat;
import org.apache.hadoop.hdfs.server.protocol.NamenodeCommand;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;
import org.apache.hadoop.hdfs.server.protocol.RegisterCommand;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLog;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLogManifest;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;

public class PBHelper {
    private static final DatanodeProtocolProtos.RegisterCommandProto REG_CMD_PROTO = DatanodeProtocolProtos.RegisterCommandProto.newBuilder().build();
    private static final RegisterCommand REG_CMD = new RegisterCommand();

    private PBHelper() {
    }

    public static HdfsServerConstants.NamenodeRole convert(HdfsServerProtos.NamenodeRegistrationProto.NamenodeRoleProto role) {
        switch (role) {
            case NAMENODE: {
                return HdfsServerConstants.NamenodeRole.NAMENODE;
            }
            case BACKUP: {
                return HdfsServerConstants.NamenodeRole.BACKUP;
            }
            case CHECKPOINT: {
                return HdfsServerConstants.NamenodeRole.CHECKPOINT;
            }
        }
        return null;
    }

    public static HdfsServerProtos.NamenodeRegistrationProto.NamenodeRoleProto convert(HdfsServerConstants.NamenodeRole role) {
        switch (role) {
            case NAMENODE: {
                return HdfsServerProtos.NamenodeRegistrationProto.NamenodeRoleProto.NAMENODE;
            }
            case BACKUP: {
                return HdfsServerProtos.NamenodeRegistrationProto.NamenodeRoleProto.BACKUP;
            }
            case CHECKPOINT: {
                return HdfsServerProtos.NamenodeRegistrationProto.NamenodeRoleProto.CHECKPOINT;
            }
        }
        return null;
    }

    public static HdfsServerProtos.StorageInfoProto convert(StorageInfo info) {
        return HdfsServerProtos.StorageInfoProto.newBuilder().setClusterID(info.getClusterID()).setCTime(info.getCTime()).setLayoutVersion(info.getLayoutVersion()).setNamespceID(info.getNamespaceID()).build();
    }

    public static StorageInfo convert(HdfsServerProtos.StorageInfoProto info, HdfsServerConstants.NodeType type) {
        return new StorageInfo(info.getLayoutVersion(), info.getNamespceID(), info.getClusterID(), info.getCTime(), type);
    }

    public static HdfsServerProtos.NamenodeRegistrationProto convert(NamenodeRegistration reg) {
        return HdfsServerProtos.NamenodeRegistrationProto.newBuilder().setHttpAddress(reg.getHttpAddress()).setRole(PBHelper.convert(reg.getRole())).setRpcAddress(reg.getAddress()).setStorageInfo(PBHelper.convert((StorageInfo)reg)).build();
    }

    public static NamenodeRegistration convert(HdfsServerProtos.NamenodeRegistrationProto reg) {
        StorageInfo si = PBHelper.convert(reg.getStorageInfo(), HdfsServerConstants.NodeType.NAME_NODE);
        return new NamenodeRegistration(reg.getRpcAddress(), reg.getHttpAddress(), si, PBHelper.convert(reg.getRole()));
    }

    public static HdfsServerProtos.BlockWithLocationsProto convert(BlocksWithLocations.BlockWithLocations blk) {
        return HdfsServerProtos.BlockWithLocationsProto.newBuilder().setBlock(PBHelperClient.convert(blk.getBlock())).addAllDatanodeUuids(Arrays.asList(blk.getDatanodeUuids())).addAllStorageUuids(Arrays.asList(blk.getStorageIDs())).addAllStorageTypes(PBHelperClient.convertStorageTypes(blk.getStorageTypes())).build();
    }

    public static BlocksWithLocations.BlockWithLocations convert(HdfsServerProtos.BlockWithLocationsProto b) {
        List<String> datanodeUuids = b.getDatanodeUuidsList();
        List<String> storageUuids = b.getStorageUuidsList();
        List<HdfsProtos.StorageTypeProto> storageTypes = b.getStorageTypesList();
        return new BlocksWithLocations.BlockWithLocations(PBHelperClient.convert(b.getBlock()), datanodeUuids.toArray(new String[datanodeUuids.size()]), storageUuids.toArray(new String[storageUuids.size()]), PBHelperClient.convertStorageTypes(storageTypes, storageUuids.size()));
    }

    public static HdfsServerProtos.BlocksWithLocationsProto convert(BlocksWithLocations blks) {
        HdfsServerProtos.BlocksWithLocationsProto.Builder builder = HdfsServerProtos.BlocksWithLocationsProto.newBuilder();
        for (BlocksWithLocations.BlockWithLocations b : blks.getBlocks()) {
            builder.addBlocks(PBHelper.convert(b));
        }
        return builder.build();
    }

    public static BlocksWithLocations convert(HdfsServerProtos.BlocksWithLocationsProto blocks) {
        List<HdfsServerProtos.BlockWithLocationsProto> b = blocks.getBlocksList();
        BlocksWithLocations.BlockWithLocations[] ret = new BlocksWithLocations.BlockWithLocations[b.size()];
        int i = 0;
        for (HdfsServerProtos.BlockWithLocationsProto entry : b) {
            ret[i++] = PBHelper.convert(entry);
        }
        return new BlocksWithLocations(ret);
    }

    public static HdfsServerProtos.BlockKeyProto convert(BlockKey key) {
        byte[] encodedKey = key.getEncodedKey();
        ByteString keyBytes = PBHelperClient.getByteString(encodedKey == null ? DFSUtilClient.EMPTY_BYTES : encodedKey);
        return HdfsServerProtos.BlockKeyProto.newBuilder().setKeyId(key.getKeyId()).setKeyBytes(keyBytes).setExpiryDate(key.getExpiryDate()).build();
    }

    public static BlockKey convert(HdfsServerProtos.BlockKeyProto k) {
        return new BlockKey(k.getKeyId(), k.getExpiryDate(), k.getKeyBytes().toByteArray());
    }

    public static HdfsServerProtos.ExportedBlockKeysProto convert(ExportedBlockKeys keys) {
        HdfsServerProtos.ExportedBlockKeysProto.Builder builder = HdfsServerProtos.ExportedBlockKeysProto.newBuilder();
        builder.setIsBlockTokenEnabled(keys.isBlockTokenEnabled()).setKeyUpdateInterval(keys.getKeyUpdateInterval()).setTokenLifeTime(keys.getTokenLifetime()).setCurrentKey(PBHelper.convert(keys.getCurrentKey()));
        for (BlockKey k : keys.getAllKeys()) {
            builder.addAllKeys(PBHelper.convert(k));
        }
        return builder.build();
    }

    public static ExportedBlockKeys convert(HdfsServerProtos.ExportedBlockKeysProto keys) {
        return new ExportedBlockKeys(keys.getIsBlockTokenEnabled(), keys.getKeyUpdateInterval(), keys.getTokenLifeTime(), PBHelper.convert(keys.getCurrentKey()), PBHelper.convertBlockKeys(keys.getAllKeysList()));
    }

    public static HdfsServerProtos.CheckpointSignatureProto convert(CheckpointSignature s) {
        return HdfsServerProtos.CheckpointSignatureProto.newBuilder().setBlockPoolId(s.getBlockpoolID()).setCurSegmentTxId(s.getCurSegmentTxId()).setMostRecentCheckpointTxId(s.getMostRecentCheckpointTxId()).setStorageInfo(PBHelper.convert((StorageInfo)s)).build();
    }

    public static CheckpointSignature convert(HdfsServerProtos.CheckpointSignatureProto s) {
        StorageInfo si = PBHelper.convert(s.getStorageInfo(), HdfsServerConstants.NodeType.NAME_NODE);
        return new CheckpointSignature(si, s.getBlockPoolId(), s.getMostRecentCheckpointTxId(), s.getCurSegmentTxId());
    }

    public static HdfsServerProtos.RemoteEditLogProto convert(RemoteEditLog log) {
        return HdfsServerProtos.RemoteEditLogProto.newBuilder().setStartTxId(log.getStartTxId()).setEndTxId(log.getEndTxId()).setIsInProgress(log.isInProgress()).build();
    }

    public static RemoteEditLog convert(HdfsServerProtos.RemoteEditLogProto l) {
        return new RemoteEditLog(l.getStartTxId(), l.getEndTxId(), l.getIsInProgress());
    }

    public static HdfsServerProtos.RemoteEditLogManifestProto convert(RemoteEditLogManifest manifest) {
        HdfsServerProtos.RemoteEditLogManifestProto.Builder builder = HdfsServerProtos.RemoteEditLogManifestProto.newBuilder();
        for (RemoteEditLog log : manifest.getLogs()) {
            builder.addLogs(PBHelper.convert(log));
        }
        return builder.build();
    }

    public static RemoteEditLogManifest convert(HdfsServerProtos.RemoteEditLogManifestProto manifest) {
        ArrayList<RemoteEditLog> logs = new ArrayList<RemoteEditLog>(manifest.getLogsList().size());
        for (HdfsServerProtos.RemoteEditLogProto l : manifest.getLogsList()) {
            logs.add(PBHelper.convert(l));
        }
        return new RemoteEditLogManifest(logs);
    }

    public static HdfsServerProtos.CheckpointCommandProto convert(CheckpointCommand cmd) {
        return HdfsServerProtos.CheckpointCommandProto.newBuilder().setSignature(PBHelper.convert(cmd.getSignature())).setNeedToReturnImage(cmd.needToReturnImage()).build();
    }

    public static HdfsServerProtos.NamenodeCommandProto convert(NamenodeCommand cmd) {
        if (cmd instanceof CheckpointCommand) {
            return HdfsServerProtos.NamenodeCommandProto.newBuilder().setAction(cmd.getAction()).setType(HdfsServerProtos.NamenodeCommandProto.Type.CheckPointCommand).setCheckpointCmd(PBHelper.convert((CheckpointCommand)cmd)).build();
        }
        return HdfsServerProtos.NamenodeCommandProto.newBuilder().setType(HdfsServerProtos.NamenodeCommandProto.Type.NamenodeCommand).setAction(cmd.getAction()).build();
    }

    public static BlockKey[] convertBlockKeys(List<HdfsServerProtos.BlockKeyProto> list) {
        BlockKey[] ret = new BlockKey[list.size()];
        int i = 0;
        for (HdfsServerProtos.BlockKeyProto k : list) {
            ret[i++] = PBHelper.convert(k);
        }
        return ret;
    }

    public static NamespaceInfo convert(HdfsServerProtos.NamespaceInfoProto info) {
        HdfsServerProtos.StorageInfoProto storage = info.getStorageInfo();
        return new NamespaceInfo(storage.getNamespceID(), storage.getClusterID(), info.getBlockPoolID(), storage.getCTime(), info.getBuildVersion(), info.getSoftwareVersion(), info.getCapabilities(), PBHelper.convert(info.getState()));
    }

    public static NamenodeCommand convert(HdfsServerProtos.NamenodeCommandProto cmd) {
        if (cmd == null) {
            return null;
        }
        switch (cmd.getType()) {
            case CheckPointCommand: {
                HdfsServerProtos.CheckpointCommandProto chkPt = cmd.getCheckpointCmd();
                return new CheckpointCommand(PBHelper.convert(chkPt.getSignature()), chkPt.getNeedToReturnImage());
            }
        }
        return new NamenodeCommand(cmd.getAction());
    }

    public static HdfsServerProtos.RecoveringBlockProto convert(BlockRecoveryCommand.RecoveringBlock b) {
        if (b == null) {
            return null;
        }
        HdfsProtos.LocatedBlockProto lb = PBHelperClient.convert(b);
        HdfsServerProtos.RecoveringBlockProto.Builder builder = HdfsServerProtos.RecoveringBlockProto.newBuilder();
        builder.setBlock(lb).setNewGenStamp(b.getNewGenerationStamp());
        if (b.getNewBlock() != null) {
            builder.setTruncateBlock(PBHelperClient.convert(b.getNewBlock()));
        }
        return builder.build();
    }

    public static BlockRecoveryCommand.RecoveringBlock convert(HdfsServerProtos.RecoveringBlockProto b) {
        LocatedBlock lb = PBHelperClient.convert(b.getBlock());
        BlockRecoveryCommand.RecoveringBlock rBlock = b.hasTruncateBlock() ? new BlockRecoveryCommand.RecoveringBlock(lb.getBlock(), lb.getLocations(), PBHelperClient.convert(b.getTruncateBlock())) : new BlockRecoveryCommand.RecoveringBlock(lb.getBlock(), lb.getLocations(), b.getNewGenStamp());
        return rBlock;
    }

    public static HdfsServerConstants.ReplicaState convert(HdfsServerProtos.ReplicaStateProto state) {
        switch (state) {
            case RBW: {
                return HdfsServerConstants.ReplicaState.RBW;
            }
            case RUR: {
                return HdfsServerConstants.ReplicaState.RUR;
            }
            case RWR: {
                return HdfsServerConstants.ReplicaState.RWR;
            }
            case TEMPORARY: {
                return HdfsServerConstants.ReplicaState.TEMPORARY;
            }
        }
        return HdfsServerConstants.ReplicaState.FINALIZED;
    }

    public static HdfsServerProtos.ReplicaStateProto convert(HdfsServerConstants.ReplicaState state) {
        switch (state) {
            case RBW: {
                return HdfsServerProtos.ReplicaStateProto.RBW;
            }
            case RUR: {
                return HdfsServerProtos.ReplicaStateProto.RUR;
            }
            case RWR: {
                return HdfsServerProtos.ReplicaStateProto.RWR;
            }
            case TEMPORARY: {
                return HdfsServerProtos.ReplicaStateProto.TEMPORARY;
            }
        }
        return HdfsServerProtos.ReplicaStateProto.FINALIZED;
    }

    public static DatanodeProtocolProtos.DatanodeRegistrationProto convert(DatanodeRegistration registration) {
        DatanodeProtocolProtos.DatanodeRegistrationProto.Builder builder = DatanodeProtocolProtos.DatanodeRegistrationProto.newBuilder();
        return builder.setDatanodeID(PBHelperClient.convert(registration)).setStorageInfo(PBHelper.convert(registration.getStorageInfo())).setKeys(PBHelper.convert(registration.getExportedKeys())).setSoftwareVersion(registration.getSoftwareVersion()).build();
    }

    public static DatanodeRegistration convert(DatanodeProtocolProtos.DatanodeRegistrationProto proto) {
        StorageInfo si = PBHelper.convert(proto.getStorageInfo(), HdfsServerConstants.NodeType.DATA_NODE);
        return new DatanodeRegistration(PBHelperClient.convert(proto.getDatanodeID()), si, PBHelper.convert(proto.getKeys()), proto.getSoftwareVersion());
    }

    public static DatanodeCommand convert(DatanodeProtocolProtos.DatanodeCommandProto proto) {
        switch (proto.getCmdType()) {
            case BalancerBandwidthCommand: {
                return PBHelper.convert(proto.getBalancerCmd());
            }
            case BlockCommand: {
                return PBHelper.convert(proto.getBlkCmd());
            }
            case BlockRecoveryCommand: {
                return PBHelper.convert(proto.getRecoveryCmd());
            }
            case FinalizeCommand: {
                return PBHelper.convert(proto.getFinalizeCmd());
            }
            case KeyUpdateCommand: {
                return PBHelper.convert(proto.getKeyUpdateCmd());
            }
            case RegisterCommand: {
                return REG_CMD;
            }
            case BlockIdCommand: {
                return PBHelper.convert(proto.getBlkIdCmd());
            }
        }
        return null;
    }

    public static DatanodeProtocolProtos.BalancerBandwidthCommandProto convert(BalancerBandwidthCommand bbCmd) {
        return DatanodeProtocolProtos.BalancerBandwidthCommandProto.newBuilder().setBandwidth(bbCmd.getBalancerBandwidthValue()).build();
    }

    public static DatanodeProtocolProtos.KeyUpdateCommandProto convert(KeyUpdateCommand cmd) {
        return DatanodeProtocolProtos.KeyUpdateCommandProto.newBuilder().setKeys(PBHelper.convert(cmd.getExportedKeys())).build();
    }

    public static DatanodeProtocolProtos.BlockRecoveryCommandProto convert(BlockRecoveryCommand cmd) {
        DatanodeProtocolProtos.BlockRecoveryCommandProto.Builder builder = DatanodeProtocolProtos.BlockRecoveryCommandProto.newBuilder();
        for (BlockRecoveryCommand.RecoveringBlock b : cmd.getRecoveringBlocks()) {
            builder.addBlocks(PBHelper.convert(b));
        }
        return builder.build();
    }

    public static DatanodeProtocolProtos.FinalizeCommandProto convert(FinalizeCommand cmd) {
        return DatanodeProtocolProtos.FinalizeCommandProto.newBuilder().setBlockPoolId(cmd.getBlockPoolId()).build();
    }

    public static DatanodeProtocolProtos.BlockCommandProto convert(BlockCommand cmd) {
        DatanodeProtocolProtos.BlockCommandProto.Builder builder = DatanodeProtocolProtos.BlockCommandProto.newBuilder().setBlockPoolId(cmd.getBlockPoolId());
        switch (cmd.getAction()) {
            case 1: {
                builder.setAction(DatanodeProtocolProtos.BlockCommandProto.Action.TRANSFER);
                break;
            }
            case 2: {
                builder.setAction(DatanodeProtocolProtos.BlockCommandProto.Action.INVALIDATE);
                break;
            }
            case 3: {
                builder.setAction(DatanodeProtocolProtos.BlockCommandProto.Action.SHUTDOWN);
                break;
            }
            default: {
                throw new AssertionError((Object)"Invalid action");
            }
        }
        Block[] blocks = cmd.getBlocks();
        for (int i = 0; i < blocks.length; ++i) {
            builder.addBlocks(PBHelperClient.convert(blocks[i]));
        }
        builder.addAllTargets(PBHelperClient.convert(cmd.getTargets())).addAllTargetStorageUuids(PBHelper.convert(cmd.getTargetStorageIDs()));
        StorageType[][] types = cmd.getTargetStorageTypes();
        if (types != null) {
            builder.addAllTargetStorageTypes(PBHelperClient.convert(types));
        }
        return builder.build();
    }

    public static DatanodeProtocolProtos.BlockIdCommandProto convert(BlockIdCommand cmd) {
        DatanodeProtocolProtos.BlockIdCommandProto.Builder builder = DatanodeProtocolProtos.BlockIdCommandProto.newBuilder().setBlockPoolId(cmd.getBlockPoolId());
        switch (cmd.getAction()) {
            case 9: {
                builder.setAction(DatanodeProtocolProtos.BlockIdCommandProto.Action.CACHE);
                break;
            }
            case 10: {
                builder.setAction(DatanodeProtocolProtos.BlockIdCommandProto.Action.UNCACHE);
                break;
            }
            default: {
                throw new AssertionError((Object)"Invalid action");
            }
        }
        long[] blockIds = cmd.getBlockIds();
        for (int i = 0; i < blockIds.length; ++i) {
            builder.addBlockIds(blockIds[i]);
        }
        return builder.build();
    }

    private static List<HdfsServerProtos.StorageUuidsProto> convert(String[][] targetStorageUuids) {
        HdfsServerProtos.StorageUuidsProto[] ret = new HdfsServerProtos.StorageUuidsProto[targetStorageUuids.length];
        for (int i = 0; i < targetStorageUuids.length; ++i) {
            ret[i] = HdfsServerProtos.StorageUuidsProto.newBuilder().addAllStorageUuids(Arrays.asList(targetStorageUuids[i])).build();
        }
        return Arrays.asList(ret);
    }

    public static DatanodeProtocolProtos.DatanodeCommandProto convert(DatanodeCommand datanodeCommand) {
        DatanodeProtocolProtos.DatanodeCommandProto.Builder builder = DatanodeProtocolProtos.DatanodeCommandProto.newBuilder();
        if (datanodeCommand == null) {
            return builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.NullDatanodeCommand).build();
        }
        switch (datanodeCommand.getAction()) {
            case 8: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.BalancerBandwidthCommand).setBalancerCmd(PBHelper.convert((BalancerBandwidthCommand)datanodeCommand));
                break;
            }
            case 7: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.KeyUpdateCommand).setKeyUpdateCmd(PBHelper.convert((KeyUpdateCommand)datanodeCommand));
                break;
            }
            case 6: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.BlockRecoveryCommand).setRecoveryCmd(PBHelper.convert((BlockRecoveryCommand)datanodeCommand));
                break;
            }
            case 5: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.FinalizeCommand).setFinalizeCmd(PBHelper.convert((FinalizeCommand)datanodeCommand));
                break;
            }
            case 4: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.RegisterCommand).setRegisterCmd(REG_CMD_PROTO);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.BlockCommand).setBlkCmd(PBHelper.convert((BlockCommand)datanodeCommand));
                break;
            }
            case 9: 
            case 10: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.BlockIdCommand).setBlkIdCmd(PBHelper.convert((BlockIdCommand)datanodeCommand));
                break;
            }
            default: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.NullDatanodeCommand);
            }
        }
        return builder.build();
    }

    public static KeyUpdateCommand convert(DatanodeProtocolProtos.KeyUpdateCommandProto keyUpdateCmd) {
        return new KeyUpdateCommand(PBHelper.convert(keyUpdateCmd.getKeys()));
    }

    public static FinalizeCommand convert(DatanodeProtocolProtos.FinalizeCommandProto finalizeCmd) {
        return new FinalizeCommand(finalizeCmd.getBlockPoolId());
    }

    public static BlockRecoveryCommand convert(DatanodeProtocolProtos.BlockRecoveryCommandProto recoveryCmd) {
        List<HdfsServerProtos.RecoveringBlockProto> list = recoveryCmd.getBlocksList();
        ArrayList<BlockRecoveryCommand.RecoveringBlock> recoveringBlocks = new ArrayList<BlockRecoveryCommand.RecoveringBlock>(list.size());
        for (HdfsServerProtos.RecoveringBlockProto rbp : list) {
            recoveringBlocks.add(PBHelper.convert(rbp));
        }
        return new BlockRecoveryCommand(recoveringBlocks);
    }

    public static BlockCommand convert(DatanodeProtocolProtos.BlockCommandProto blkCmd) {
        int i;
        List<HdfsProtos.BlockProto> blockProtoList = blkCmd.getBlocksList();
        Block[] blocks = new Block[blockProtoList.size()];
        for (int i2 = 0; i2 < blockProtoList.size(); ++i2) {
            blocks[i2] = PBHelperClient.convert(blockProtoList.get(i2));
        }
        List<HdfsProtos.DatanodeInfosProto> targetList = blkCmd.getTargetsList();
        DatanodeInfo[][] targets = new DatanodeInfo[targetList.size()][];
        for (int i3 = 0; i3 < targetList.size(); ++i3) {
            targets[i3] = PBHelperClient.convert(targetList.get(i3));
        }
        StorageType[][] targetStorageTypes = new StorageType[targetList.size()][];
        List<HdfsProtos.StorageTypesProto> targetStorageTypesList = blkCmd.getTargetStorageTypesList();
        if (targetStorageTypesList.isEmpty()) {
            for (i = 0; i < targetStorageTypes.length; ++i) {
                targetStorageTypes[i] = new StorageType[targets[i].length];
                Arrays.fill((Object[])targetStorageTypes[i], (Object)StorageType.DEFAULT);
            }
        } else {
            for (i = 0; i < targetStorageTypes.length; ++i) {
                List<HdfsProtos.StorageTypeProto> p = targetStorageTypesList.get(i).getStorageTypesList();
                targetStorageTypes[i] = PBHelperClient.convertStorageTypes(p, targets[i].length);
            }
        }
        List<HdfsServerProtos.StorageUuidsProto> targetStorageUuidsList = blkCmd.getTargetStorageUuidsList();
        String[][] targetStorageIDs = new String[targetStorageUuidsList.size()][];
        for (int i4 = 0; i4 < targetStorageIDs.length; ++i4) {
            List<String> storageIDs = targetStorageUuidsList.get(i4).getStorageUuidsList();
            targetStorageIDs[i4] = storageIDs.toArray(new String[storageIDs.size()]);
        }
        int action = 0;
        switch (blkCmd.getAction()) {
            case TRANSFER: {
                action = 1;
                break;
            }
            case INVALIDATE: {
                action = 2;
                break;
            }
            case SHUTDOWN: {
                action = 3;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown action type: " + blkCmd.getAction()));
            }
        }
        return new BlockCommand(action, blkCmd.getBlockPoolId(), blocks, targets, targetStorageTypes, targetStorageIDs);
    }

    public static BlockIdCommand convert(DatanodeProtocolProtos.BlockIdCommandProto blkIdCmd) {
        int numBlockIds = blkIdCmd.getBlockIdsCount();
        long[] blockIds = new long[numBlockIds];
        for (int i = 0; i < numBlockIds; ++i) {
            blockIds[i] = blkIdCmd.getBlockIds(i);
        }
        int action = 0;
        switch (blkIdCmd.getAction()) {
            case CACHE: {
                action = 9;
                break;
            }
            case UNCACHE: {
                action = 10;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown action type: " + blkIdCmd.getAction()));
            }
        }
        return new BlockIdCommand(action, blkIdCmd.getBlockPoolId(), blockIds);
    }

    public static BalancerBandwidthCommand convert(DatanodeProtocolProtos.BalancerBandwidthCommandProto balancerCmd) {
        return new BalancerBandwidthCommand(balancerCmd.getBandwidth());
    }

    public static DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto convert(ReceivedDeletedBlockInfo receivedDeletedBlockInfo) {
        DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.BlockStatus status;
        DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.Builder builder = DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.newBuilder();
        switch (receivedDeletedBlockInfo.getStatus()) {
            case RECEIVING_BLOCK: {
                status = DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.BlockStatus.RECEIVING;
                break;
            }
            case RECEIVED_BLOCK: {
                status = DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.BlockStatus.RECEIVED;
                break;
            }
            case DELETED_BLOCK: {
                status = DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.BlockStatus.DELETED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad status: " + (Object)((Object)receivedDeletedBlockInfo.getStatus()));
            }
        }
        builder.setStatus(status);
        if (receivedDeletedBlockInfo.getDelHints() != null) {
            builder.setDeleteHint(receivedDeletedBlockInfo.getDelHints());
        }
        return builder.setBlock(PBHelperClient.convert(receivedDeletedBlockInfo.getBlock())).build();
    }

    public static ReceivedDeletedBlockInfo convert(DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto proto) {
        ReceivedDeletedBlockInfo.BlockStatus status = null;
        switch (proto.getStatus()) {
            case RECEIVING: {
                status = ReceivedDeletedBlockInfo.BlockStatus.RECEIVING_BLOCK;
                break;
            }
            case RECEIVED: {
                status = ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK;
                break;
            }
            case DELETED: {
                status = ReceivedDeletedBlockInfo.BlockStatus.DELETED_BLOCK;
            }
        }
        return new ReceivedDeletedBlockInfo(PBHelperClient.convert(proto.getBlock()), status, proto.hasDeleteHint() ? proto.getDeleteHint() : null);
    }

    public static HdfsServerProtos.NamespaceInfoProto convert(NamespaceInfo info) {
        HdfsServerProtos.NamespaceInfoProto.Builder builder = HdfsServerProtos.NamespaceInfoProto.newBuilder();
        builder.setBlockPoolID(info.getBlockPoolID()).setBuildVersion(info.getBuildVersion()).setUnused(0).setStorageInfo(PBHelper.convert((StorageInfo)info)).setSoftwareVersion(info.getSoftwareVersion()).setCapabilities(info.getCapabilities());
        HAServiceProtocol.HAServiceState state = info.getState();
        if (state != null) {
            builder.setState(PBHelper.convert(info.getState()));
        }
        return builder.build();
    }

    public static HAServiceProtocol.HAServiceState convert(HdfsServerProtos.NNHAStatusHeartbeatProto.State s) {
        if (s == null) {
            return null;
        }
        switch (s) {
            case ACTIVE: {
                return HAServiceProtocol.HAServiceState.ACTIVE;
            }
            case STANDBY: {
                return HAServiceProtocol.HAServiceState.STANDBY;
            }
        }
        throw new IllegalArgumentException("Unexpected HAServiceStateProto:" + s);
    }

    public static HdfsServerProtos.NNHAStatusHeartbeatProto.State convert(HAServiceProtocol.HAServiceState s) {
        if (s == null) {
            return null;
        }
        switch (s) {
            case ACTIVE: {
                return HdfsServerProtos.NNHAStatusHeartbeatProto.State.ACTIVE;
            }
            case STANDBY: {
                return HdfsServerProtos.NNHAStatusHeartbeatProto.State.STANDBY;
            }
        }
        throw new IllegalArgumentException("Unexpected HAServiceState:" + (Object)((Object)s));
    }

    public static NNHAStatusHeartbeat convert(HdfsServerProtos.NNHAStatusHeartbeatProto s) {
        if (s == null) {
            return null;
        }
        return new NNHAStatusHeartbeat(PBHelper.convert(s.getState()), s.getTxid());
    }

    public static HdfsServerProtos.NNHAStatusHeartbeatProto convert(NNHAStatusHeartbeat hb) {
        if (hb == null) {
            return null;
        }
        HdfsServerProtos.NNHAStatusHeartbeatProto.Builder builder = HdfsServerProtos.NNHAStatusHeartbeatProto.newBuilder();
        builder.setState(PBHelper.convert(hb.getState()));
        builder.setTxid(hb.getTxId());
        return builder.build();
    }

    public static VolumeFailureSummary convertVolumeFailureSummary(DatanodeProtocolProtos.VolumeFailureSummaryProto proto) {
        List<String> failedStorageLocations = proto.getFailedStorageLocationsList();
        return new VolumeFailureSummary(failedStorageLocations.toArray(new String[failedStorageLocations.size()]), proto.getLastVolumeFailureDate(), proto.getEstimatedCapacityLostTotal());
    }

    public static DatanodeProtocolProtos.VolumeFailureSummaryProto convertVolumeFailureSummary(VolumeFailureSummary volumeFailureSummary) {
        DatanodeProtocolProtos.VolumeFailureSummaryProto.Builder builder = DatanodeProtocolProtos.VolumeFailureSummaryProto.newBuilder();
        for (String failedStorageLocation : volumeFailureSummary.getFailedStorageLocations()) {
            builder.addFailedStorageLocations(failedStorageLocation);
        }
        builder.setLastVolumeFailureDate(volumeFailureSummary.getLastVolumeFailureDate());
        builder.setEstimatedCapacityLostTotal(volumeFailureSummary.getEstimatedCapacityLostTotal());
        return builder.build();
    }

    public static JournalInfo convert(JournalProtocolProtos.JournalInfoProto info) {
        int lv = info.hasLayoutVersion() ? info.getLayoutVersion() : 0;
        int nsID = info.hasNamespaceID() ? info.getNamespaceID() : 0;
        return new JournalInfo(lv, info.getClusterID(), nsID);
    }

    public static JournalProtocolProtos.JournalInfoProto convert(JournalInfo j) {
        return JournalProtocolProtos.JournalInfoProto.newBuilder().setClusterID(j.getClusterId()).setLayoutVersion(j.getLayoutVersion()).setNamespaceID(j.getNamespaceId()).build();
    }

    public static BlockReportContext convert(DatanodeProtocolProtos.BlockReportContextProto proto) {
        return new BlockReportContext(proto.getTotalRpcs(), proto.getCurRpc(), proto.getId(), proto.getLeaseId());
    }

    public static DatanodeProtocolProtos.BlockReportContextProto convert(BlockReportContext context) {
        return DatanodeProtocolProtos.BlockReportContextProto.newBuilder().setTotalRpcs(context.getTotalRpcs()).setCurRpc(context.getCurRpc()).setId(context.getReportId()).setLeaseId(context.getLeaseId()).build();
    }
}

