/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import java.util.Locale;
import org.apache.flink.shaded.hadoop2.com.google.common.base.Preconditions;
import org.apache.hadoop.security.authentication.server.KerberosAuthenticationHandler;
import org.apache.hadoop.security.authentication.server.LdapAuthenticationHandler;
import org.apache.hadoop.security.authentication.server.MultiSchemeAuthenticationHandler;
import org.apache.hadoop.security.authentication.server.PseudoAuthenticationHandler;

public final class AuthenticationHandlerUtil {
    private AuthenticationHandlerUtil() {
    }

    public static String getAuthenticationHandlerClassName(String authHandler) {
        String handlerName = Preconditions.checkNotNull(authHandler).toLowerCase(Locale.ENGLISH);
        String authHandlerClassName = null;
        authHandlerClassName = handlerName.equals("simple") ? PseudoAuthenticationHandler.class.getName() : (handlerName.equals("kerberos") ? KerberosAuthenticationHandler.class.getName() : (handlerName.equals("ldap") ? LdapAuthenticationHandler.class.getName() : (handlerName.equals("multi-scheme") ? MultiSchemeAuthenticationHandler.class.getName() : authHandler)));
        return authHandlerClassName;
    }

    public static String checkAuthScheme(String scheme) {
        if ("Basic".equalsIgnoreCase(scheme)) {
            return "Basic";
        }
        if ("Negotiate".equalsIgnoreCase(scheme)) {
            return "Negotiate";
        }
        if ("Digest".equalsIgnoreCase(scheme)) {
            return "Digest";
        }
        throw new IllegalArgumentException(String.format("Unsupported HTTP authentication scheme %s . Supported schemes are [%s, %s, %s]", scheme, "Basic", "Negotiate", "Digest"));
    }

    public static boolean matchAuthScheme(String scheme, String auth) {
        scheme = Preconditions.checkNotNull(scheme).trim();
        auth = Preconditions.checkNotNull(auth).trim();
        return auth.regionMatches(true, 0, scheme, 0, scheme.length());
    }
}

