/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.impl.rest.httpclient;

import com.jamesmurty.utils.XMLBuilder;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.shaded.hadoop2.org.apache.http.HttpEntity;
import org.apache.flink.shaded.hadoop2.org.apache.http.HttpResponse;
import org.apache.flink.shaded.hadoop2.org.apache.http.client.CredentialsProvider;
import org.apache.flink.shaded.hadoop2.org.apache.http.client.methods.HttpUriRequest;
import org.apache.flink.shaded.hadoop2.org.apache.http.entity.InputStreamEntity;
import org.apache.flink.shaded.hadoop2.org.apache.http.entity.StringEntity;
import org.apache.flink.shaded.hadoop2.org.apache.http.util.EntityUtils;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.MultipartUploadChunk;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.ServiceException;
import org.jets3t.service.VersionOrDeleteMarkersChunk;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.impl.rest.XmlResponsesSaxParser;
import org.jets3t.service.impl.rest.httpclient.HttpMethodReleaseInputStream;
import org.jets3t.service.impl.rest.httpclient.HttpResponseAndByteCount;
import org.jets3t.service.impl.rest.httpclient.RepeatableRequestEntity;
import org.jets3t.service.impl.rest.httpclient.RestStorageService;
import org.jets3t.service.model.BaseVersionOrDeleteMarker;
import org.jets3t.service.model.MultipartCompleted;
import org.jets3t.service.model.MultipartPart;
import org.jets3t.service.model.MultipartUpload;
import org.jets3t.service.model.MultipleDeleteResult;
import org.jets3t.service.model.NotificationConfig;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3BucketVersioningStatus;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.StorageBucket;
import org.jets3t.service.model.StorageObject;
import org.jets3t.service.model.WebsiteConfig;
import org.jets3t.service.model.container.ObjectKeyAndVersion;
import org.jets3t.service.security.AWSDevPayCredentials;
import org.jets3t.service.security.AWSSessionCredentials;
import org.jets3t.service.security.ProviderCredentials;
import org.jets3t.service.utils.RestUtils;
import org.jets3t.service.utils.ServiceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestS3Service
extends S3Service {
    private static final Log log = LogFactory.getLog(RestS3Service.class);
    private static final String AWS_SIGNATURE_IDENTIFIER = "AWS";
    private static final String AWS_REST_HEADER_PREFIX = "x-amz-";
    private static final String AWS_REST_METADATA_PREFIX = "x-amz-meta-";
    private String awsDevPayUserToken = null;
    private String awsDevPayProductToken = null;
    private boolean isRequesterPaysEnabled = false;

    public RestS3Service(ProviderCredentials credentials) throws S3ServiceException {
        this(credentials, (String)null, (CredentialsProvider)null);
    }

    public RestS3Service(ProviderCredentials credentials, String invokingApplicationDescription, CredentialsProvider credentialsProvider) throws S3ServiceException {
        this(credentials, invokingApplicationDescription, credentialsProvider, Jets3tProperties.getInstance(Constants.JETS3T_PROPERTIES_FILENAME));
    }

    public RestS3Service(ProviderCredentials credentials, String invokingApplicationDescription, CredentialsProvider credentialsProvider, Jets3tProperties jets3tProperties) throws S3ServiceException {
        super(credentials, invokingApplicationDescription, credentialsProvider, jets3tProperties);
        if (credentials instanceof AWSDevPayCredentials) {
            AWSDevPayCredentials awsDevPayCredentials = (AWSDevPayCredentials)credentials;
            this.awsDevPayUserToken = awsDevPayCredentials.getUserToken();
            this.awsDevPayProductToken = awsDevPayCredentials.getProductToken();
        } else {
            this.awsDevPayUserToken = jets3tProperties.getStringProperty("devpay.user-token", null);
            this.awsDevPayProductToken = jets3tProperties.getStringProperty("devpay.product-token", null);
        }
        this.setRequesterPaysEnabled(this.jets3tProperties.getBoolProperty("httpclient.requester-pays-buckets-enabled", false));
    }

    @Override
    protected boolean isTargettingGoogleStorageService() {
        return Constants.GS_DEFAULT_HOSTNAME.equals(this.getJetS3tProperties().getStringProperty("s3service.s3-endpoint", null));
    }

    @Override
    protected XmlResponsesSaxParser getXmlResponseSaxParser() throws ServiceException {
        return new XmlResponsesSaxParser(this.jets3tProperties, false);
    }

    @Override
    protected StorageBucket newBucket() {
        return new S3Bucket();
    }

    @Override
    protected StorageObject newObject() {
        return new S3Object();
    }

    public void setDevPayUserToken(String userToken) {
        this.awsDevPayUserToken = userToken;
    }

    public String getDevPayUserToken() {
        return this.awsDevPayUserToken;
    }

    public void setDevPayProductToken(String productToken) {
        this.awsDevPayProductToken = productToken;
    }

    public String getDevPayProductToken() {
        return this.awsDevPayProductToken;
    }

    public void setRequesterPaysEnabled(boolean isRequesterPays) {
        this.isRequesterPaysEnabled = isRequesterPays;
    }

    public boolean isRequesterPaysEnabled() {
        return this.isRequesterPaysEnabled;
    }

    @Override
    protected HttpUriRequest setupConnection(RestStorageService.HTTP_METHOD method, String bucketName, String objectKey, Map<String, String> requestParameters) throws S3ServiceException {
        HttpUriRequest httpMethod;
        try {
            httpMethod = super.setupConnection(method, bucketName, objectKey, requestParameters);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
        if (this.getDevPayUserToken() != null || this.getDevPayProductToken() != null) {
            if (this.getDevPayProductToken() != null) {
                String securityToken = this.getDevPayUserToken() + "," + this.getDevPayProductToken();
                httpMethod.setHeader("x-amz-security-token", securityToken);
                if (log.isDebugEnabled()) {
                    log.debug("Including DevPay user and product tokens in request: x-amz-security-token=" + securityToken);
                }
            } else {
                httpMethod.setHeader("x-amz-security-token", this.getDevPayUserToken());
                if (log.isDebugEnabled()) {
                    log.debug("Including DevPay user token in request: x-amz-security-token=" + this.getDevPayUserToken());
                }
            }
        }
        if (this.credentials instanceof AWSSessionCredentials) {
            String sessionToken = ((AWSSessionCredentials)this.credentials).getSessionToken();
            httpMethod.setHeader("x-amz-security-token", sessionToken);
            if (log.isDebugEnabled()) {
                log.debug("Including AWS session token in request: x-amz-security-token=" + sessionToken);
            }
        }
        if (this.isRequesterPaysEnabled()) {
            String[] requesterPaysHeaderAndValue = "x-amz-request-payer=requester".split("=");
            httpMethod.setHeader(requesterPaysHeaderAndValue[0], requesterPaysHeaderAndValue[1]);
            if (log.isDebugEnabled()) {
                log.debug("Including Requester Pays header in request: x-amz-request-payer=requester");
            }
        }
        return httpMethod;
    }

    @Override
    public String getEndpoint() {
        return this.jets3tProperties.getStringProperty("s3service.s3-endpoint", Constants.S3_DEFAULT_HOSTNAME);
    }

    @Override
    protected String getVirtualPath() {
        return this.jets3tProperties.getStringProperty("s3service.s3-endpoint-virtual-path", "");
    }

    @Override
    protected String getSignatureIdentifier() {
        return AWS_SIGNATURE_IDENTIFIER;
    }

    @Override
    public String getRestHeaderPrefix() {
        return AWS_REST_HEADER_PREFIX;
    }

    @Override
    public List<String> getResourceParameterNames() {
        return Arrays.asList("acl", "policy", "torrent", "logging", "location", "requestPayment", "versions", "versioning", "versionId", "uploads", "uploadId", "partNumber", "website", "notification", "delete", "response-content-type", "response-content-language", "response-expires", "reponse-cache-control", "response-content-disposition", "response-content-encoding");
    }

    @Override
    public String getRestMetadataPrefix() {
        return AWS_REST_METADATA_PREFIX;
    }

    @Override
    protected int getHttpPort() {
        return this.jets3tProperties.getIntProperty("s3service.s3-endpoint-http-port", 80);
    }

    @Override
    protected int getHttpsPort() {
        return this.jets3tProperties.getIntProperty("s3service.s3-endpoint-https-port", 443);
    }

    @Override
    protected boolean getHttpsOnly() {
        return this.jets3tProperties.getBoolProperty("s3service.https-only", true);
    }

    @Override
    protected boolean getDisableDnsBuckets() {
        return this.jets3tProperties.getBoolProperty("s3service.disable-dns-buckets", false);
    }

    @Override
    protected boolean getEnableStorageClasses() {
        return this.jets3tProperties.getBoolProperty("s3service.enable-storage-classes", !this.isTargettingGoogleStorageService());
    }

    @Override
    protected boolean getEnableServerSideEncryption() {
        return !this.isTargettingGoogleStorageService();
    }

    @Override
    protected BaseVersionOrDeleteMarker[] listVersionedObjectsImpl(String bucketName, String prefix, String delimiter, String keyMarker, String versionMarker, long maxListingLength) throws S3ServiceException {
        return this.listVersionedObjectsInternal(bucketName, prefix, delimiter, maxListingLength, true, keyMarker, versionMarker).getItems();
    }

    @Override
    protected void updateBucketVersioningStatusImpl(String bucketName, boolean enabled, boolean multiFactorAuthDeleteEnabled, String multiFactorSerialNumber, String multiFactorAuthCode) throws S3ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((enabled ? "Enabling" : "Suspending") + " versioning for bucket " + bucketName + (multiFactorAuthDeleteEnabled ? " with Multi-Factor Auth enabled" : ""));
        }
        try {
            XMLBuilder builder = XMLBuilder.create("VersioningConfiguration").a("xmlns", "http://s3.amazonaws.com/doc/2006-03-01/").e("Status").t(enabled ? "Enabled" : "Suspended").up().e("MfaDelete").t(multiFactorAuthDeleteEnabled ? "Enabled" : "Disabled");
            HashMap<String, String> requestParams = new HashMap<String, String>();
            requestParams.put("versioning", null);
            HashMap<String, Object> metadata = new HashMap<String, Object>();
            if (multiFactorSerialNumber != null || multiFactorAuthCode != null) {
                metadata.put("x-amz-mfa", multiFactorSerialNumber + " " + multiFactorAuthCode);
            }
            try {
                this.performRestPutWithXmlBuilder(bucketName, null, metadata, requestParams, builder);
            }
            catch (ServiceException se) {
                throw new S3ServiceException(se);
            }
        }
        catch (ParserConfigurationException e) {
            throw new S3ServiceException("Failed to build XML document for request", e);
        }
    }

    @Override
    protected S3BucketVersioningStatus getBucketVersioningStatusImpl(String bucketName) throws S3ServiceException {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Checking status of versioning for bucket " + bucketName);
            }
            HashMap<String, String> requestParams = new HashMap<String, String>();
            requestParams.put("versioning", null);
            HttpResponse response = this.performRestGet(bucketName, null, requestParams, null);
            return this.getXmlResponseSaxParser().parseVersioningConfigurationResponse(new HttpMethodReleaseInputStream(response));
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    protected VersionOrDeleteMarkersChunk listVersionedObjectsInternal(String bucketName, String prefix, String delimiter, long maxListingLength, boolean automaticallyMergeChunks, String nextKeyMarker, String nextVersionIdMarker) throws S3ServiceException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("versions", null);
        if (prefix != null) {
            parameters.put("prefix", prefix);
        }
        if (delimiter != null) {
            parameters.put("delimiter", delimiter);
        }
        if (maxListingLength > 0L) {
            parameters.put("max-keys", String.valueOf(maxListingLength));
        }
        ArrayList<BaseVersionOrDeleteMarker> items = new ArrayList<BaseVersionOrDeleteMarker>();
        ArrayList<String> commonPrefixes = new ArrayList<String>();
        boolean incompleteListing = true;
        int ioErrorRetryCount = 0;
        while (incompleteListing) {
            if (nextKeyMarker != null) {
                parameters.put("key-marker", nextKeyMarker);
            } else {
                parameters.remove("key-marker");
            }
            if (nextVersionIdMarker != null) {
                parameters.put("version-id-marker", nextVersionIdMarker);
            } else {
                parameters.remove("version-id-marker");
            }
            HttpResponse httpResponse = null;
            try {
                httpResponse = this.performRestGet(bucketName, null, parameters, null);
            }
            catch (ServiceException se) {
                throw new S3ServiceException(se);
            }
            XmlResponsesSaxParser.ListVersionsResultsHandler handler = null;
            try {
                handler = this.getXmlResponseSaxParser().parseListVersionsResponse(new HttpMethodReleaseInputStream(httpResponse));
                ioErrorRetryCount = 0;
            }
            catch (ServiceException se) {
                if (se.getCause() instanceof IOException && ioErrorRetryCount < 5) {
                    ++ioErrorRetryCount;
                    if (!log.isWarnEnabled()) continue;
                    log.warn("Retrying bucket listing failure due to IO error", se);
                    continue;
                }
                throw new S3ServiceException(se);
            }
            BaseVersionOrDeleteMarker[] partialItems = handler.getItems();
            if (log.isDebugEnabled()) {
                log.debug("Found " + partialItems.length + " items in one batch");
            }
            items.addAll(Arrays.asList(partialItems));
            String[] partialCommonPrefixes = handler.getCommonPrefixes();
            if (log.isDebugEnabled()) {
                log.debug("Found " + partialCommonPrefixes.length + " common prefixes in one batch");
            }
            commonPrefixes.addAll(Arrays.asList(partialCommonPrefixes));
            incompleteListing = handler.isListingTruncated();
            nextKeyMarker = handler.getNextKeyMarker();
            nextVersionIdMarker = handler.getNextVersionIdMarker();
            if (incompleteListing && log.isDebugEnabled()) {
                log.debug("Yet to receive complete listing of bucket versions, continuing with key-marker=" + nextKeyMarker + " and version-id-marker=" + nextVersionIdMarker);
            }
            if (automaticallyMergeChunks) continue;
            break;
        }
        if (automaticallyMergeChunks) {
            if (log.isDebugEnabled()) {
                log.debug("Found " + items.size() + " items in total");
            }
            return new VersionOrDeleteMarkersChunk(prefix, delimiter, items.toArray(new BaseVersionOrDeleteMarker[items.size()]), commonPrefixes.toArray(new String[commonPrefixes.size()]), null, null);
        }
        return new VersionOrDeleteMarkersChunk(prefix, delimiter, items.toArray(new BaseVersionOrDeleteMarker[items.size()]), commonPrefixes.toArray(new String[commonPrefixes.size()]), nextKeyMarker, nextVersionIdMarker);
    }

    @Override
    protected VersionOrDeleteMarkersChunk listVersionedObjectsChunkedImpl(String bucketName, String prefix, String delimiter, long maxListingLength, String priorLastKey, String priorLastVersion, boolean completeListing) throws S3ServiceException {
        return this.listVersionedObjectsInternal(bucketName, prefix, delimiter, maxListingLength, completeListing, priorLastKey, priorLastVersion);
    }

    @Override
    protected String getBucketLocationImpl(String bucketName) throws S3ServiceException {
        try {
            return super.getBucketLocationImpl(bucketName);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    @Override
    protected String getBucketPolicyImpl(String bucketName) throws S3ServiceException {
        try {
            HashMap<String, String> requestParameters = new HashMap<String, String>();
            requestParameters.put("policy", "");
            HttpResponse httpResponse = this.performRestGet(bucketName, null, requestParameters, null);
            return EntityUtils.toString(httpResponse.getEntity());
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
        catch (IOException e) {
            throw new S3ServiceException(e);
        }
    }

    @Override
    protected void setBucketPolicyImpl(String bucketName, String policyDocument) throws S3ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("policy", "");
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("Content-Type", "text/plain");
        try {
            this.performRestPut(bucketName, null, metadata, requestParameters, new StringEntity(policyDocument, "text/plain", Constants.DEFAULT_ENCODING), true);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
        catch (UnsupportedEncodingException e) {
            throw new S3ServiceException("Unable to encode LoggingStatus XML document", e);
        }
    }

    @Override
    protected void deleteBucketPolicyImpl(String bucketName) throws S3ServiceException {
        try {
            HashMap<String, String> requestParameters = new HashMap<String, String>();
            requestParameters.put("policy", "");
            this.performRestDelete(bucketName, null, requestParameters, null, null);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    @Override
    protected boolean isRequesterPaysBucketImpl(String bucketName) throws S3ServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Retrieving Request Payment Configuration settings for Bucket: " + bucketName);
        }
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("requestPayment", "");
        try {
            HttpResponse httpResponse = this.performRestGet(bucketName, null, requestParameters, null);
            return this.getXmlResponseSaxParser().parseRequestPaymentConfigurationResponse(new HttpMethodReleaseInputStream(httpResponse));
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    @Override
    protected void setRequesterPaysBucketImpl(String bucketName, boolean requesterPays) throws S3ServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Setting Request Payment Configuration settings for bucket: " + bucketName);
        }
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("requestPayment", "");
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("Content-Type", "text/plain");
        try {
            String xml = "<RequestPaymentConfiguration xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\"><Payer>" + (requesterPays ? "Requester" : "BucketOwner") + "</Payer>" + "</RequestPaymentConfiguration>";
            this.performRestPut(bucketName, null, metadata, requestParameters, new StringEntity(xml, "text/plain", Constants.DEFAULT_ENCODING), true);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
        catch (UnsupportedEncodingException e) {
            throw new S3ServiceException("Unable to encode RequestPaymentConfiguration XML document", e);
        }
    }

    protected MultipartUpload multipartStartUploadImpl(String bucketName, String objectKey, Map<String, Object> metadataProvided, AccessControlList acl, String storageClass) throws S3ServiceException {
        return this.multipartStartUploadImpl(bucketName, objectKey, metadataProvided, acl, storageClass, null);
    }

    @Override
    protected MultipartUpload multipartStartUploadImpl(String bucketName, String objectKey, Map<String, Object> metadataProvided, AccessControlList acl, String storageClass, String serverSideEncryptionAlgorithm) throws S3ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("uploads", "");
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        if (metadataProvided != null) {
            for (Map.Entry<String, Object> entry : metadataProvided.entrySet()) {
                if (entry.getKey().toLowerCase().equals("content-length")) continue;
                metadata.put(entry.getKey(), entry.getValue());
            }
        }
        this.prepareStorageClass(metadata, storageClass, true, objectKey);
        this.prepareServerSideEncryption(metadata, serverSideEncryptionAlgorithm, objectKey);
        boolean putNonStandardAcl = !this.prepareRESTHeaderAcl(metadata, acl);
        try {
            HttpResponse httpResponse = this.performRestPost(bucketName, objectKey, metadata, requestParameters, null, false);
            MultipartUpload multipartUpload = this.getXmlResponseSaxParser().parseInitiateMultipartUploadResult(new HttpMethodReleaseInputStream(httpResponse));
            multipartUpload.setMetadata(metadata);
            return multipartUpload;
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MultipartPart multipartUploadPartImpl(String uploadId, String bucketName, Integer partNumber, S3Object object) throws S3ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("uploadId", uploadId);
        requestParameters.put("partNumber", "" + partNumber);
        S3Object s3Object = object;
        synchronized (s3Object) {
            ArrayList<String> metadataNamesToRemove = new ArrayList<String>();
            for (String name : object.getMetadataMap().keySet()) {
                if (RestUtils.HTTP_HEADER_METADATA_NAMES.contains(name.toLowerCase())) continue;
                metadataNamesToRemove.add(name);
            }
            for (String name : metadataNamesToRemove) {
                object.removeMetadata(name);
            }
        }
        try {
            boolean isLiveMD5HashingRequired = false;
            HttpEntity requestEntity = null;
            if (object.getDataInputStream() != null) {
                if (object.containsMetadata("Content-Length")) {
                    if (log.isDebugEnabled()) {
                        log.debug("Uploading multipart part data with Content-Length: " + object.getContentLength());
                    }
                    requestEntity = new RepeatableRequestEntity(object.getKey(), object.getDataInputStream(), object.getContentType(), object.getContentLength(), this.jets3tProperties, isLiveMD5HashingRequired);
                } else {
                    if (log.isWarnEnabled()) {
                        log.warn("Content-Length of multipart part stream not set, will automatically determine data length in memory");
                    }
                    requestEntity = new InputStreamEntity(object.getDataInputStream(), -1L);
                }
            }
            object.setStorageClass("");
            this.putObjectWithRequestEntityImpl(bucketName, object, requestEntity, requestParameters);
            MultipartPart part = new MultipartPart(partNumber, object.getLastModifiedDate(), object.getETag(), object.getContentLength());
            return part;
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    @Override
    protected MultipartPart multipartUploadPartCopyImpl(String uploadId, String targetBucketName, String targetObjectKey, Integer partNumber, String sourceBucketName, String sourceObjectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags, Long byteRangeStart, Long byteRangeEnd, String versionId) throws S3ServiceException {
        try {
            String tags;
            if (log.isDebugEnabled()) {
                log.debug("Multipart Copy Object from " + sourceBucketName + ":" + sourceObjectKey + " to upload id=" + uploadId + "as part" + partNumber);
            }
            HashMap<String, Object> metadata = new HashMap<String, Object>();
            String sourceKey = RestUtils.encodeUrlString(sourceBucketName + "/" + sourceObjectKey);
            if (versionId != null) {
                sourceKey = sourceKey + "?versionId=" + versionId;
            }
            metadata.put(this.getRestHeaderPrefix() + "copy-source", sourceKey);
            if (ifModifiedSince != null) {
                metadata.put(this.getRestHeaderPrefix() + "copy-source-if-modified-since", ServiceUtils.formatRfc822Date(ifModifiedSince.getTime()));
                if (log.isDebugEnabled()) {
                    log.debug("Only copy object if-modified-since:" + ifModifiedSince);
                }
            }
            if (ifUnmodifiedSince != null) {
                metadata.put(this.getRestHeaderPrefix() + "copy-source-if-unmodified-since", ServiceUtils.formatRfc822Date(ifUnmodifiedSince.getTime()));
                if (log.isDebugEnabled()) {
                    log.debug("Only copy object if-unmodified-since:" + ifUnmodifiedSince);
                }
            }
            if (ifMatchTags != null) {
                tags = ServiceUtils.join(ifMatchTags, ",");
                metadata.put(this.getRestHeaderPrefix() + "copy-source-if-match", tags);
                if (log.isDebugEnabled()) {
                    log.debug("Only copy object based on hash comparison if-match:" + tags);
                }
            }
            if (ifNoneMatchTags != null) {
                tags = ServiceUtils.join(ifNoneMatchTags, ",");
                metadata.put(this.getRestHeaderPrefix() + "copy-source-if-none-match", tags);
                if (log.isDebugEnabled()) {
                    log.debug("Only copy object based on hash comparison if-none-match:" + tags);
                }
            }
            if (byteRangeStart != null || byteRangeEnd != null) {
                if (byteRangeStart == null || byteRangeEnd == null) {
                    throw new IllegalArgumentException("both range start and end must be set");
                }
                String range = String.format("bytes=%s-%s", byteRangeStart, byteRangeEnd);
                metadata.put(this.getRestHeaderPrefix() + "copy-source-range", range);
                if (log.isDebugEnabled()) {
                    log.debug("Copy object range:" + range);
                }
            }
            HashMap<String, String> requestParameters = new HashMap<String, String>();
            requestParameters.put("partNumber", String.valueOf(partNumber));
            requestParameters.put("uploadId", String.valueOf(uploadId));
            HttpResponseAndByteCount responseAndByteCount = this.performRestPut(targetBucketName, targetObjectKey, metadata, requestParameters, null, false);
            MultipartPart part = this.getXmlResponseSaxParser().parseMultipartUploadPartCopyResult(new HttpMethodReleaseInputStream(responseAndByteCount.getHttpResponse()));
            return new MultipartPart(partNumber, part.getLastModified(), part.getEtag(), -1L);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    @Override
    protected void multipartAbortUploadImpl(String uploadId, String bucketName, String objectKey) throws S3ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("uploadId", uploadId);
        try {
            this.performRestDelete(bucketName, objectKey, requestParameters, null, null);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    @Override
    protected MultipartCompleted multipartCompleteUploadImpl(String uploadId, String bucketName, String objectKey, List<MultipartPart> parts) throws S3ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("uploadId", uploadId);
        MultipartPart[] sortedParts = parts.toArray(new MultipartPart[parts.size()]);
        Arrays.sort(sortedParts, new MultipartPart.PartNumberComparator());
        try {
            XMLBuilder builder = XMLBuilder.create("CompleteMultipartUpload").a("xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
            for (MultipartPart part : sortedParts) {
                builder.e("Part").e("PartNumber").t("" + part.getPartNumber()).up().e("ETag").t(part.getEtag());
            }
            HttpResponse httpResponse = this.performRestPostWithXmlBuilder(bucketName, objectKey, null, requestParameters, builder);
            XmlResponsesSaxParser.CompleteMultipartUploadResultHandler handler = this.getXmlResponseSaxParser().parseCompleteMultipartUploadResult(new HttpMethodReleaseInputStream(httpResponse));
            if (handler.getServiceException() != null) {
                ServiceException e = handler.getServiceException();
                e.setResponseHeaders(RestUtils.convertHeadersToMap(httpResponse.getAllHeaders()));
                throw e;
            }
            return handler.getMultipartCompleted();
        }
        catch (S3ServiceException se) {
            throw se;
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
        catch (ParserConfigurationException e) {
            throw new S3ServiceException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new S3ServiceException(e);
        }
    }

    @Override
    protected MultipartUploadChunk multipartListUploadsChunkedImpl(String bucketName, String prefix, String delimiter, String keyMarker, String uploadIdMarker, Integer maxUploads, boolean autoMergeChunks) throws S3ServiceException {
        if (bucketName == null || bucketName.length() == 0) {
            throw new IllegalArgumentException("The bucket name parameter must be specified when listing multipart uploads");
        }
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("uploads", "");
        if (prefix != null) {
            requestParameters.put("prefix", prefix);
        }
        if (delimiter != null) {
            requestParameters.put("delimiter", delimiter);
        }
        if (maxUploads != null) {
            requestParameters.put("max-uploads", maxUploads.toString());
        }
        if (keyMarker != null) {
            requestParameters.put("key-marker", keyMarker);
        }
        if (uploadIdMarker != null) {
            requestParameters.put("upload-id-marker", uploadIdMarker);
        }
        String nextKeyMarker = keyMarker;
        String nextUploadIdMarker = uploadIdMarker;
        ArrayList<MultipartUpload> uploads = new ArrayList<MultipartUpload>();
        ArrayList<String> commonPrefixes = new ArrayList<String>();
        boolean incompleteListing = true;
        int ioErrorRetryCount = 0;
        int ioErrorRetryMaxCount = this.jets3tProperties.getIntProperty("httpclient.retry-max", 5);
        try {
            while (incompleteListing) {
                if (nextKeyMarker != null) {
                    requestParameters.put("key-marker", nextKeyMarker);
                } else {
                    requestParameters.remove("key-marker");
                }
                if (nextUploadIdMarker != null) {
                    requestParameters.put("upload-id-marker", nextUploadIdMarker);
                } else {
                    requestParameters.remove("upload-id-marker");
                }
                HttpResponse httpResponse = this.performRestGet(bucketName, null, requestParameters, null);
                XmlResponsesSaxParser.ListMultipartUploadsResultHandler handler = null;
                try {
                    handler = this.getXmlResponseSaxParser().parseListMultipartUploadsResult(new HttpMethodReleaseInputStream(httpResponse));
                    ioErrorRetryCount = 0;
                }
                catch (ServiceException e) {
                    if (e.getCause() instanceof IOException && ioErrorRetryCount < ioErrorRetryMaxCount) {
                        ++ioErrorRetryCount;
                        if (!log.isWarnEnabled()) continue;
                        log.warn("Retrying bucket listing failure due to IO error", e);
                        continue;
                    }
                    throw e;
                }
                List<MultipartUpload> partial = handler.getMultipartUploadList();
                if (log.isDebugEnabled()) {
                    log.debug("Found " + partial.size() + " objects in one batch");
                }
                uploads.addAll(partial);
                String[] partialCommonPrefixes = handler.getCommonPrefixes();
                if (log.isDebugEnabled()) {
                    log.debug("Found " + partialCommonPrefixes.length + " common prefixes in one batch");
                }
                commonPrefixes.addAll(Arrays.asList(partialCommonPrefixes));
                incompleteListing = handler.isTruncated();
                if (incompleteListing) {
                    nextKeyMarker = handler.getNextKeyMarker();
                    nextUploadIdMarker = handler.getNextUploadIdMarker();
                    if (nextKeyMarker == null && nextUploadIdMarker == null) {
                        throw new ServiceException("Unable to retrieve paginated ListMultipartUploadsResult without valid NextKeyMarker  or NextUploadIdMarker value.");
                    }
                } else {
                    nextKeyMarker = null;
                    nextUploadIdMarker = null;
                }
                if (autoMergeChunks) continue;
                break;
            }
            if (autoMergeChunks && log.isDebugEnabled()) {
                log.debug("Found " + uploads.size() + " uploads in total");
            }
            return new MultipartUploadChunk(prefix, delimiter, uploads.toArray(new MultipartUpload[uploads.size()]), commonPrefixes.toArray(new String[commonPrefixes.size()]), nextKeyMarker, nextUploadIdMarker);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    @Override
    protected List<MultipartPart> multipartListPartsImpl(String uploadId, String bucketName, String objectKey) throws S3ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("uploadId", uploadId);
        requestParameters.put("max-parts", "1000");
        try {
            ArrayList<MultipartPart> parts = new ArrayList<MultipartPart>();
            String nextPartNumberMarker = null;
            boolean incompleteListing = true;
            do {
                if (nextPartNumberMarker != null) {
                    requestParameters.put("part-number-marker", nextPartNumberMarker);
                } else {
                    requestParameters.remove("part-number-marker");
                }
                HttpResponse httpResponse = this.performRestGet(bucketName, objectKey, requestParameters, null);
                XmlResponsesSaxParser.ListMultipartPartsResultHandler handler = this.getXmlResponseSaxParser().parseListMultipartPartsResult(new HttpMethodReleaseInputStream(httpResponse));
                parts.addAll(handler.getMultipartPartList());
                incompleteListing = handler.isTruncated();
                nextPartNumberMarker = handler.getNextPartNumberMarker();
                if (!incompleteListing || nextPartNumberMarker != null) continue;
                throw new ServiceException("Unable to retrieve paginated ListMultipartPartsResult without valid NextKeyMarker value.");
            } while (incompleteListing);
            return parts;
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    @Override
    protected WebsiteConfig getWebsiteConfigImpl(String bucketName) throws S3ServiceException {
        try {
            HashMap<String, String> requestParameters = new HashMap<String, String>();
            requestParameters.put("website", "");
            HttpResponse getMethod = this.performRestGet(bucketName, null, requestParameters, null);
            return this.getXmlResponseSaxParser().parseWebsiteConfigurationResponse(new HttpMethodReleaseInputStream(getMethod));
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    @Override
    protected void setWebsiteConfigImpl(String bucketName, WebsiteConfig config) throws S3ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("website", "");
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        String xml = null;
        try {
            xml = config.toXml();
        }
        catch (Exception e) {
            throw new S3ServiceException("Unable to build WebsiteConfig XML document", e);
        }
        try {
            this.performRestPut(bucketName, null, metadata, requestParameters, new StringEntity(xml, "text/plain", Constants.DEFAULT_ENCODING), true);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
        catch (UnsupportedEncodingException e) {
            throw new S3ServiceException("Unable to encode XML document", e);
        }
    }

    @Override
    protected void deleteWebsiteConfigImpl(String bucketName) throws S3ServiceException {
        try {
            HashMap<String, String> requestParameters = new HashMap<String, String>();
            requestParameters.put("website", "");
            this.performRestDelete(bucketName, null, requestParameters, null, null);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    @Override
    protected NotificationConfig getNotificationConfigImpl(String bucketName) throws S3ServiceException {
        try {
            HashMap<String, String> requestParameters = new HashMap<String, String>();
            requestParameters.put("notification", "");
            HttpResponse getMethod = this.performRestGet(bucketName, null, requestParameters, null);
            return this.getXmlResponseSaxParser().parseNotificationConfigurationResponse(new HttpMethodReleaseInputStream(getMethod));
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    @Override
    protected void setNotificationConfigImpl(String bucketName, NotificationConfig config) throws S3ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("notification", "");
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        String xml = null;
        try {
            xml = config.toXml();
        }
        catch (Exception e) {
            throw new S3ServiceException("Unable to build NotificationConfig XML document", e);
        }
        try {
            this.performRestPut(bucketName, null, metadata, requestParameters, new StringEntity(xml, "text/plain", Constants.DEFAULT_ENCODING), true);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
        catch (UnsupportedEncodingException e) {
            throw new S3ServiceException("Unable to encode XML document", e);
        }
    }

    @Override
    public MultipleDeleteResult deleteMultipleObjectsWithMFAImpl(String bucketName, ObjectKeyAndVersion[] objectNameAndVersions, String multiFactorSerialNumber, String multiFactorAuthCode, boolean isQuiet) throws S3ServiceException {
        String xmlMd5Hash;
        String xml;
        try {
            XMLBuilder builder = XMLBuilder.create("Delete").attr("xmlns", "http://s3.amazonaws.com/doc/2006-03-01/").elem("Quiet").text(isQuiet ? "true" : "false").up();
            for (ObjectKeyAndVersion nav : objectNameAndVersions) {
                XMLBuilder objectBuilder = builder.elem("Object").elem("Key").text(nav.getKey()).up();
                if (nav.getVersion() == null) continue;
                objectBuilder.elem("Version").text(nav.getVersion());
            }
            xml = builder.asString();
            xmlMd5Hash = ServiceUtils.toBase64(ServiceUtils.computeMD5Hash(xml.getBytes(Constants.DEFAULT_ENCODING)));
        }
        catch (Exception e) {
            throw new S3ServiceException("Failed to build XML request document", e);
        }
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("delete", "");
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("Content-Type", "text/plain");
        metadata.put("Content-MD5", xmlMd5Hash);
        if (multiFactorSerialNumber != null || multiFactorAuthCode != null) {
            metadata.put("x-amz-mfa", multiFactorSerialNumber + " " + multiFactorAuthCode);
        }
        try {
            HttpResponse httpResponse = this.performRestPost(bucketName, null, metadata, requestParameters, new StringEntity(xml, "text/plain", Constants.DEFAULT_ENCODING), false);
            return this.getXmlResponseSaxParser().parseMultipleDeleteResponse(new HttpMethodReleaseInputStream(httpResponse));
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
        catch (UnsupportedEncodingException e) {
            throw new S3ServiceException("Unable to encode XML document", e);
        }
    }
}

