/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data.columnar.heap;

import java.util.Arrays;
import org.apache.paimon.data.columnar.ColumnVector;
import org.apache.paimon.data.columnar.heap.AbstractStructVector;

public class AbstractArrayBasedVector
extends AbstractStructVector {
    protected long[] offsets;
    protected long[] lengths;

    public AbstractArrayBasedVector(int len, ColumnVector[] children) {
        super(len, children);
        this.offsets = new long[this.capacity];
        this.lengths = new long[this.capacity];
    }

    public void putOffsetLength(int index, long offset, long length) {
        this.offsets[index] = offset;
        this.lengths[index] = length;
    }

    public long[] getOffsets() {
        return this.offsets;
    }

    public void setOffsets(long[] offsets) {
        this.offsets = offsets;
    }

    public long[] getLengths() {
        return this.lengths;
    }

    public void setLengths(long[] lengths) {
        this.lengths = lengths;
    }

    @Override
    void reserveForHeapVector(int newCapacity) {
        if (this.offsets.length < newCapacity) {
            this.offsets = Arrays.copyOf(this.offsets, newCapacity);
            this.lengths = Arrays.copyOf(this.lengths, newCapacity);
        }
    }

    @Override
    public void reset() {
        super.reset();
        if (this.offsets.length != this.capacity) {
            this.offsets = new long[this.capacity];
        } else {
            Arrays.fill(this.offsets, 0L);
        }
        if (this.lengths.length != this.capacity) {
            this.lengths = new long[this.capacity];
        } else {
            Arrays.fill(this.lengths, 0L);
        }
    }
}

