/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.aliyun.oss;

import com.aliyun.oss.model.PartETag;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystemStore;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSUtils;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.Futures;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.MoreExecutors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunOSSBlockOutputStream
extends OutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(AliyunOSSBlockOutputStream.class);
    private AliyunOSSFileSystemStore store;
    private Configuration conf;
    private boolean closed;
    private String key;
    private File blockFile;
    private Map<Integer, File> blockFiles = new HashMap<Integer, File>();
    private long blockSize;
    private int blockId = 0;
    private long blockWritten = 0L;
    private String uploadId = null;
    private final List<ListenableFuture<PartETag>> partETagsFutures;
    private final ListeningExecutorService executorService;
    private OutputStream blockStream;
    private final byte[] singleByte = new byte[1];

    public AliyunOSSBlockOutputStream(Configuration conf, AliyunOSSFileSystemStore store, String key, Long blockSize, ExecutorService executorService) throws IOException {
        this.store = store;
        this.conf = conf;
        this.key = key;
        this.blockSize = blockSize;
        this.blockFile = this.newBlockFile();
        this.blockStream = new BufferedOutputStream(new FileOutputStream(this.blockFile));
        this.partETagsFutures = new ArrayList<ListenableFuture<PartETag>>(2);
        this.executorService = MoreExecutors.listeningDecorator(executorService);
    }

    private File newBlockFile() throws IOException {
        return AliyunOSSUtils.createTmpFileForWrite(String.format("oss-block-%04d-", this.blockId), this.blockSize, this.conf);
    }

    @Override
    public synchronized void flush() throws IOException {
        this.blockStream.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.blockStream.flush();
        this.blockStream.close();
        if (!this.blockFiles.values().contains(this.blockFile)) {
            ++this.blockId;
            this.blockFiles.put(this.blockId, this.blockFile);
        }
        try {
            if (this.blockFiles.size() == 1) {
                this.store.uploadObject(this.key, this.blockFile);
            } else {
                List<PartETag> partETags;
                if (this.blockWritten > 0L) {
                    Future partETagFuture = this.executorService.submit(() -> {
                        PartETag partETag = this.store.uploadPart(this.blockFile, this.key, this.uploadId, this.blockId);
                        return partETag;
                    });
                    this.partETagsFutures.add((ListenableFuture<PartETag>)partETagFuture);
                }
                if (null == (partETags = this.waitForAllPartUploads())) {
                    throw new IOException("Failed to multipart upload to oss, abort it.");
                }
                this.store.completeMultipartUpload(this.key, this.uploadId, new ArrayList<PartETag>(partETags));
            }
        }
        finally {
            this.removeTemporaryFiles();
            this.closed = true;
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.singleByte[0] = (byte)b;
        this.write(this.singleByte, 0, 1);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed.");
        }
        this.blockStream.write(b, off, len);
        this.blockWritten += (long)len;
        if (this.blockWritten >= this.blockSize) {
            this.uploadCurrentPart();
            this.blockWritten = 0L;
        }
    }

    private void removeTemporaryFiles() {
        for (File file : this.blockFiles.values()) {
            if (file == null || !file.exists() || file.delete()) continue;
            LOG.warn("Failed to delete temporary file {}", (Object)file);
        }
    }

    private void removePartFiles() throws IOException {
        for (ListenableFuture<PartETag> partETagFuture : this.partETagsFutures) {
            if (!partETagFuture.isDone()) continue;
            try {
                File blockFile = this.blockFiles.get(((PartETag)partETagFuture.get()).getPartNumber());
                if (blockFile == null || !blockFile.exists() || blockFile.delete()) continue;
                LOG.warn("Failed to delete temporary file {}", (Object)blockFile);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IOException(e);
            }
        }
    }

    private void uploadCurrentPart() throws IOException {
        this.blockStream.flush();
        this.blockStream.close();
        if (this.blockId == 0) {
            this.uploadId = this.store.getUploadId(this.key);
        }
        ++this.blockId;
        this.blockFiles.put(this.blockId, this.blockFile);
        File currentFile = this.blockFile;
        int currentBlockId = this.blockId;
        Future partETagFuture = this.executorService.submit(() -> {
            PartETag partETag = this.store.uploadPart(currentFile, this.key, this.uploadId, currentBlockId);
            return partETag;
        });
        this.partETagsFutures.add((ListenableFuture<PartETag>)partETagFuture);
        this.removePartFiles();
        this.blockFile = this.newBlockFile();
        this.blockStream = new BufferedOutputStream(new FileOutputStream(this.blockFile));
    }

    private List<PartETag> waitForAllPartUploads() throws IOException {
        LOG.debug("Waiting for {} uploads to complete", (Object)this.partETagsFutures.size());
        try {
            return (List)Futures.allAsList(this.partETagsFutures).get();
        }
        catch (InterruptedException ie) {
            LOG.warn("Interrupted partUpload", (Throwable)ie);
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException ee) {
            LOG.debug("While waiting for upload completion", (Throwable)ee);
            LOG.debug("Cancelling futures");
            for (ListenableFuture<PartETag> future : this.partETagsFutures) {
                future.cancel(true);
            }
            this.store.abortMultipartUpload(this.key, this.uploadId);
            throw new IOException("Multi-part upload with id '" + this.uploadId + "' to " + this.key, ee);
        }
    }
}

