# 使用SQL进行图查询

## 使用SQL进行图的点与边Join

1. 运行脚本，提交已经编辑好的demo GQL:

```shell
bin/gql_submit.sh --gql geaflow/geaflow-examples/gql/sql_join_to_graph_demo.sql
```

其中 sql_join_to_graph_demo.sql 是一段在模拟流图中的SQL Join查询，其关键内容如下：

```sql
USE GRAPH dy_modern;

select u.name, friend.name
from person u, knows e, person friend
where u.id = e.srcId and e.targetId = friend.id
;
```

该 DSL 会从项目中的 resource 文件 **demo_job_data.txt** 中读取点边数据，进行构图。

然后在图`dy_modern`上执行点与边的Join查询，引擎解析Join语义后自动转为图的查询。

2. 输出结果如下

运行以下命令，可以打印结果文件的内容。

```shell
cat /tmp/geaflow/sql_join_to_graph_demo_result/partition_0  
```

查询结果默认写入`/tmp/geaflow/sql_join_to_graph_demo_result`, 用户也可通过修改 `geaflow.dsl.file.path` 参数自定义输出路径。

```
jim,jim
kate,kate
lily,lily
lucy,lucy
jim,jim
lucy,lucy
lucy,lucy
jack,jack
```


## 使用SQL进行图的点与边Join聚合查询

1. 运行脚本，提交已经编辑好的demo GQL:

```shell
bin/gql_submit.sh --gql geaflow/geaflow-examples/gql/sql_join_to_graph_demo_02.sql
```

其中 sql_join_to_graph_demo_02.sql 关键内容如下：

```sql
USE GRAPH dy_modern;

SELECT    u.name,
          friend_num
FROM      person u,
          (
          SELECT    srcId AS pid,
                    COUNT(DISTINCT targetId) AS friend_num
          FROM      knows
          GROUP BY  srcId
          ) t_friend_num
WHERE     u.id = pid;
```

该 DSL 会从项目中的 resource 文件 **demo_job_data.txt** 中读取点边数据，进行构图。

然后在图`dy_modern`上执行点与边的Join查询，引擎解析Join语义后自动转为图的查询。

2. 输出结果如下

运行以下命令，可以打印结果文件的内容。

```shell
cat /tmp/geaflow/sql_join_to_graph_demo_02_result/partition_0  
```

查询结果默认写入`/tmp/geaflow/sql_join_to_graph_demo_02_result`, 用户也可通过修改 `geaflow.dsl.file.path` 参数自定义输出路径。

结果显示了图中记录的每个人的朋友数。

```
lucy,2
jim,1
kate,1
lily,1
jack,1
```