/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.rpc.netty.http.filter;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http2.Http2Headers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.seata.core.rpc.netty.http.RequestParseUtils;
import org.apache.seata.core.rpc.netty.http.SimpleHttp2Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestParamWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRequestParamWrapper.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final Map<String, List<String>> queryParams = new HashMap<String, List<String>>();
    private final Map<String, List<String>> formParams = new HashMap<String, List<String>>();
    private final Map<String, List<String>> headerParams = new HashMap<String, List<String>>();
    private final Map<String, List<String>> jsonParams = new HashMap<String, List<String>>();

    public HttpRequestParamWrapper(Map<String, List<String>> queryParams, Map<String, List<String>> formParams, Map<String, List<String>> headerParams, Map<String, List<String>> jsonParams) {
        this.mergeParams(this.queryParams, queryParams);
        this.mergeParams(this.formParams, formParams);
        this.mergeParams(this.headerParams, headerParams);
        this.mergeParams(this.jsonParams, jsonParams);
    }

    public HttpRequestParamWrapper(HttpRequest httpRequest) {
        if (!(httpRequest instanceof FullHttpRequest)) {
            throw new IllegalArgumentException("HttpRequest must be FullHttpRequest to read body.");
        }
        FullHttpRequest fullRequest = (FullHttpRequest)httpRequest;
        this.parseQueryParams(fullRequest.uri());
        this.parseHeaders(fullRequest.headers());
        RequestParseUtils.BodyParseResult bodyParseResult = RequestParseUtils.parseBody(OBJECT_MAPPER, fullRequest);
        this.mergeParams(this.formParams, bodyParseResult.getFormParams());
        this.mergeParams(this.jsonParams, bodyParseResult.getJsonParams());
    }

    public HttpRequestParamWrapper(SimpleHttp2Request request) {
        boolean hasBodyMaps;
        if (request.getQueryParams() != null) {
            this.mergeParams(this.queryParams, request.getQueryParams());
        } else {
            this.parseQueryParams(request.getPath());
        }
        if (request.getHeaderParams() != null) {
            this.mergeParams(this.headerParams, request.getHeaderParams());
        } else if (request.getHeaders() != null) {
            this.parseHeaders(request.getHeaders());
        }
        boolean bl = hasBodyMaps = request.getFormParams() != null || request.getJsonParams() != null;
        if (request.getFormParams() != null) {
            this.mergeParams(this.formParams, request.getFormParams());
        }
        if (request.getJsonParams() != null) {
            this.mergeParams(this.jsonParams, request.getJsonParams());
        }
        if (!hasBodyMaps && request.getBody() != null) {
            RequestParseUtils.BodyParseResult bodyParseResult = RequestParseUtils.parseBody(OBJECT_MAPPER, request.getBody(), request.getHeaders());
            this.mergeParams(this.formParams, bodyParseResult.getFormParams());
            this.mergeParams(this.jsonParams, bodyParseResult.getJsonParams());
        }
    }

    private void parseQueryParams(String uri) {
        QueryStringDecoder decoder = new QueryStringDecoder(uri);
        this.queryParams.putAll(decoder.parameters());
    }

    private void parseHeaders(HttpHeaders headers) {
        headers.forEach(entry -> this.headerParams.computeIfAbsent((String)entry.getKey(), k -> new ArrayList()).add((String)entry.getValue()));
    }

    private void parseHeaders(Http2Headers headers) {
        headers.forEach(entry -> this.headerParams.computeIfAbsent(((CharSequence)entry.getKey()).toString(), k -> new ArrayList()).add(((CharSequence)entry.getValue()).toString()));
    }

    public Map<String, List<String>> getAllParamsAsMultiMap() {
        HashMap<String, List<String>> all = new HashMap<String, List<String>>();
        this.queryParams.forEach((k, v) -> all.computeIfAbsent((String)k, key -> new ArrayList()).addAll(v));
        this.formParams.forEach((k, v) -> all.computeIfAbsent((String)k, key -> new ArrayList()).addAll(v));
        this.headerParams.forEach((k, v) -> all.computeIfAbsent((String)k, key -> new ArrayList()).addAll(v));
        this.jsonParams.forEach((k, v) -> all.computeIfAbsent((String)k, key -> new ArrayList()).addAll(v));
        return all;
    }

    private void mergeParams(Map<String, List<String>> target, Map<String, List<String>> source) {
        if (source == null || source.isEmpty()) {
            return;
        }
        source.forEach((key, values) -> {
            if (values == null || values.isEmpty()) {
                return;
            }
            List targetList = target.computeIfAbsent((String)key, k -> new ArrayList());
            targetList.addAll(values);
        });
    }
}

