/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.fory.Fory;
import org.apache.fory.memory.ByteBufferUtil;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.serializer.BufferObject;
import org.apache.fory.serializer.Serializers;

public class BufferSerializers {

    public static final class ByteBufferSerializer
    extends Serializers.CrossLanguageCompatibleSerializer<ByteBuffer> {
        public ByteBufferSerializer(Fory fory, Class<ByteBuffer> cls) {
            super(fory, cls);
        }

        @Override
        public void write(MemoryBuffer buffer, ByteBuffer value) {
            this.fory.writeBufferObject(buffer, new BufferObject.ByteBufferBufferObject(value));
        }

        @Override
        public ByteBuffer copy(ByteBuffer value) {
            ByteBuffer dst = ByteBuffer.allocate(value.remaining());
            dst.put(value.duplicate());
            ByteBufferUtil.rewind(dst);
            return dst;
        }

        @Override
        public ByteBuffer read(MemoryBuffer buffer) {
            MemoryBuffer newBuffer = this.fory.readBufferObject(buffer);
            int readerIndex = newBuffer.readerIndex();
            int size = newBuffer.remaining();
            ByteBuffer originalBuffer = newBuffer.sliceAsByteBuffer(readerIndex, size - 1);
            byte isBigEndian = newBuffer.getByte(readerIndex + size - 1);
            originalBuffer.order(isBigEndian == 1 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
            return originalBuffer;
        }
    }
}

