/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.config.holder;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.inlong.dataproxy.config.CommonConfigHolder;
import org.apache.inlong.dataproxy.config.ConfigHolder;
import org.apache.inlong.dataproxy.config.ConfigManager;
import org.apache.inlong.dataproxy.config.pojo.CacheClusterConfig;
import org.apache.inlong.dataproxy.config.pojo.CacheType;
import org.apache.inlong.dataproxy.config.pojo.IdTopicConfig;
import org.apache.inlong.dataproxy.config.pojo.InLongMetaConfig;
import org.apache.inlong.sdk.commons.protocol.InlongId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaConfigHolder
extends ConfigHolder {
    private static final String metaConfigFileName = "metadata.json";
    private static final int MAX_ALLOWED_JSON_FILE_SIZE = 314572800;
    private static final Logger LOG = LoggerFactory.getLogger(MetaConfigHolder.class);
    private static final Gson GSON = new Gson();
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private String dataMd5 = "";
    private String dataStr = "";
    private final AtomicLong lastUpdVersion = new AtomicLong(0L);
    private String tmpDataMd5 = "";
    private final AtomicLong lastSyncVersion = new AtomicLong(0L);
    private final AtomicInteger clusterType = new AtomicInteger(CacheType.N.getId());
    private final ConcurrentHashMap<String, CacheClusterConfig> mqClusterMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, IdTopicConfig> id2TopicSrcMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, IdTopicConfig> id2TopicSinkMap = new ConcurrentHashMap();

    public MetaConfigHolder() {
        super(metaConfigFileName);
    }

    public String getSrcBaseTopicName(String groupId, String streamId) {
        IdTopicConfig idTopicConfig = this.getSrcIdTopicConfig(groupId, streamId);
        if (idTopicConfig == null) {
            return null;
        }
        return idTopicConfig.getTopicName();
    }

    public IdTopicConfig getSrcIdTopicConfig(String groupId, String streamId) {
        IdTopicConfig idTopicConfig = null;
        if (StringUtils.isNotEmpty((CharSequence)groupId) && !this.id2TopicSrcMap.isEmpty() && (idTopicConfig = this.id2TopicSrcMap.get(InlongId.generateUid((String)groupId, (String)streamId))) == null) {
            idTopicConfig = this.id2TopicSrcMap.get(groupId);
        }
        return idTopicConfig;
    }

    public String getSourceTopicName(String groupId, String streamId) {
        String topic = null;
        if (StringUtils.isNotEmpty((CharSequence)groupId) && !this.id2TopicSrcMap.isEmpty()) {
            IdTopicConfig idTopicConfig = this.id2TopicSrcMap.get(InlongId.generateUid((String)groupId, (String)streamId));
            if (idTopicConfig == null) {
                idTopicConfig = this.id2TopicSrcMap.get(groupId);
            }
            if (idTopicConfig != null) {
                topic = idTopicConfig.getTopicName();
            }
        }
        return topic;
    }

    public IdTopicConfig getSinkIdTopicConfig(String groupId, String streamId) {
        IdTopicConfig idTopicConfig = null;
        if (StringUtils.isNotEmpty((CharSequence)groupId) && !this.id2TopicSinkMap.isEmpty() && (idTopicConfig = this.id2TopicSinkMap.get(InlongId.generateUid((String)groupId, (String)streamId))) == null) {
            idTopicConfig = this.id2TopicSinkMap.get(groupId);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Get Sink Topic Config by groupId = {}, streamId = {}, IdTopicConfig = {}", new Object[]{groupId, streamId, idTopicConfig});
        }
        return idTopicConfig;
    }

    public String getConfigMd5() {
        if (this.lastSyncVersion.get() > this.lastUpdVersion.get()) {
            return this.tmpDataMd5;
        }
        return this.dataMd5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateConfigMap(InLongMetaConfig metaConfig) {
        AtomicLong atomicLong = this.lastSyncVersion;
        synchronized (atomicLong) {
            String inDataJsonStr;
            if (this.lastSyncVersion.get() > this.lastUpdVersion.get()) {
                if (this.tmpDataMd5.equals(metaConfig.getMd5())) {
                    return false;
                }
                LOG.info("Update metadata: NOT UPDATE, {} is loading, but wast over {} ms", (Object)this.getFileName(), (Object)(System.currentTimeMillis() - this.lastSyncVersion.get()));
                return false;
            }
            if (this.dataMd5.equals(metaConfig.getMd5())) {
                return false;
            }
            InLongMetaConfig newMetaConfig = this.buildMixedMetaConfig(metaConfig);
            try {
                inDataJsonStr = GSON.toJson((Object)newMetaConfig);
            }
            catch (Throwable e) {
                LOG.error("Update metadata: failure to serial meta config to json", e);
                return false;
            }
            return this.storeConfigToFile(inDataJsonStr, newMetaConfig);
        }
    }

    private InLongMetaConfig buildMixedMetaConfig(InLongMetaConfig metaConfig) {
        HashMap<String, CacheClusterConfig> newClusterConfigMap = new HashMap<String, CacheClusterConfig>(metaConfig.getClusterConfigMap().size());
        newClusterConfigMap.putAll(metaConfig.getClusterConfigMap());
        HashMap<String, IdTopicConfig> newIdTopicConfigMap = new HashMap<String, IdTopicConfig>(metaConfig.getIdTopicConfigMap().size());
        newIdTopicConfigMap.putAll(metaConfig.getIdTopicConfigMap());
        return new InLongMetaConfig(metaConfig.getMd5(), metaConfig.getMqType(), newClusterConfigMap, newIdTopicConfigMap);
    }

    public List<CacheClusterConfig> forkCachedCLusterConfig() {
        ArrayList<CacheClusterConfig> result = new ArrayList<CacheClusterConfig>();
        if (this.mqClusterMap.isEmpty()) {
            return result;
        }
        for (Map.Entry<String, CacheClusterConfig> entry : this.mqClusterMap.entrySet()) {
            if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
            CacheClusterConfig config = new CacheClusterConfig();
            config.setClusterName(entry.getValue().getClusterName());
            config.setToken(entry.getValue().getToken());
            config.getParams().putAll(entry.getValue().getParams());
            result.add(config);
        }
        return result;
    }

    public Set<String> getAllTopicName() {
        HashSet<String> result = new HashSet<String>();
        if (CommonConfigHolder.getInstance().isEnableUnConfigTopicAccept()) {
            result.addAll(CommonConfigHolder.getInstance().getDefTopics());
        }
        for (IdTopicConfig topicConfig : this.id2TopicSrcMap.values()) {
            if (topicConfig == null) continue;
            result.add(topicConfig.getTopicName());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean loadFromFileToHolder() {
        if (!CommonConfigHolder.getInstance().isEnableStartupUsingLocalMetaFile() && !ConfigManager.handshakeManagerOk.get()) {
            LOG.warn("Load metadata: StartupUsingLocalMetaFile is false, don't obtain metadata from {} before handshake with Manager", (Object)this.getFileName());
            return false;
        }
        String jsonString = "";
        this.readWriteLock.writeLock().lock();
        try {
            InLongMetaConfig metaConfig;
            jsonString = this.loadConfigFromFile();
            if (StringUtils.isBlank((CharSequence)jsonString)) {
                LOG.error("Load metadata: NOT LOADED, changed but empty records, file:{}", (Object)this.getFileName());
                boolean bl = true;
                return bl;
            }
            try {
                metaConfig = (InLongMetaConfig)GSON.fromJson(jsonString, InLongMetaConfig.class);
            }
            catch (Throwable e) {
                LOG.error("Load metadata: NOT LOADED, parse json config failure, file:{}", (Object)this.getFileName(), (Object)e);
                boolean bl = true;
                if (this.lastSyncVersion.get() == 0L) {
                    this.lastUpdVersion.set(System.currentTimeMillis());
                    this.lastSyncVersion.compareAndSet(0L, this.lastUpdVersion.get());
                } else {
                    this.lastUpdVersion.set(this.lastSyncVersion.get());
                }
                this.readWriteLock.writeLock().unlock();
                return bl;
            }
            ImmutablePair<Boolean, String> paramChkResult = this.validRequiredFields(metaConfig);
            if (!((Boolean)paramChkResult.getLeft()).booleanValue()) {
                LOG.error("Load metadata: NOT LOADED, {}, file:{}", paramChkResult.getRight(), (Object)this.getFileName());
                boolean bl = true;
                return bl;
            }
            this.replaceCacheConfig(metaConfig.getMqType(), metaConfig.getClusterConfigMap(), metaConfig.getIdTopicConfigMap());
            this.dataMd5 = metaConfig.getMd5();
            this.dataStr = jsonString;
            LOG.info("Load metadata: LOADED success, from {}!", (Object)this.getFileName());
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            LOG.error("Load metadata: NOT LOADED, load from {} throw exception", (Object)this.getFileName(), (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.lastSyncVersion.get() == 0L) {
                this.lastUpdVersion.set(System.currentTimeMillis());
                this.lastSyncVersion.compareAndSet(0L, this.lastUpdVersion.get());
            } else {
                this.lastUpdVersion.set(this.lastSyncVersion.get());
            }
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storeConfigToFile(String metaJsonStr, InLongMetaConfig metaConfig) {
        boolean isSuccess = false;
        String filePath = this.getFilePath();
        if (StringUtils.isBlank((CharSequence)filePath)) {
            LOG.error("Store metadata: error in writing file {} as the file path is null.", (Object)this.getFileName());
            return isSuccess;
        }
        this.readWriteLock.writeLock().lock();
        try {
            File sourceFile = new File(filePath);
            File targetFile = new File(this.getNextBackupFileName());
            File tmpNewFile = new File(this.getFileName() + ".tmp");
            if (sourceFile.exists()) {
                FileUtils.copyFile((File)sourceFile, (File)targetFile);
            }
            FileUtils.writeStringToFile((File)tmpNewFile, (String)metaJsonStr, (Charset)StandardCharsets.UTF_8);
            FileUtils.copyFile((File)tmpNewFile, (File)sourceFile);
            tmpNewFile.delete();
            this.tmpDataMd5 = metaConfig.getMd5();
            this.lastSyncVersion.set(System.currentTimeMillis());
            isSuccess = true;
            this.setFileChanged();
        }
        catch (Throwable ex) {
            LOG.error("Store metadata: exception thrown while writing to file {}", (Object)this.getFileName(), (Object)ex);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        return isSuccess;
    }

    private void replaceCacheConfig(CacheType cacheType, Map<String, CacheClusterConfig> clusterConfigMap, Map<String, IdTopicConfig> idTopicConfigMap) {
        this.clusterType.getAndSet(cacheType.getId());
        HashSet<String> tmpRmvKeys = new HashSet<String>();
        for (Map.Entry<String, IdTopicConfig> entry : this.id2TopicSrcMap.entrySet()) {
            if (entry == null || entry.getKey() == null || entry.getValue() == null || idTopicConfigMap.containsKey(entry.getKey())) continue;
            tmpRmvKeys.add(entry.getKey());
        }
        for (String string : tmpRmvKeys) {
            this.id2TopicSrcMap.remove(string);
        }
        this.id2TopicSrcMap.putAll(idTopicConfigMap);
        this.id2TopicSinkMap.putAll(idTopicConfigMap);
        tmpRmvKeys.clear();
        for (Map.Entry<String, Object> entry : this.mqClusterMap.entrySet()) {
            if (entry == null || entry.getKey() == null || entry.getValue() == null || clusterConfigMap.containsKey(entry.getKey())) continue;
            tmpRmvKeys.add(entry.getKey());
        }
        for (String string : tmpRmvKeys) {
            this.mqClusterMap.remove(string);
        }
        this.mqClusterMap.putAll(clusterConfigMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadConfigFromFile() {
        String result = "";
        if (StringUtils.isBlank((CharSequence)this.getFileName())) {
            LOG.error("Load metadata: fail to load json {} as the file name is null.", (Object)this.getFileName());
            return result;
        }
        InputStream inStream = null;
        try {
            URL url = this.getClass().getClassLoader().getResource(this.getFileName());
            InputStream inputStream = inStream = url != null ? url.openStream() : null;
            if (inStream == null) {
                LOG.error("Load metadata: fail to load json {} as the input stream is null", (Object)this.getFileName());
                String string = result;
                return string;
            }
            int size = inStream.available();
            if (size > 314572800) {
                LOG.error("Load metadata: fail to load json {} as the content size({}) over max allowed size({})", new Object[]{this.getFileName(), size, 314572800});
                String e = result;
                return e;
            }
            byte[] buffer = new byte[size];
            inStream.read(buffer);
            result = new String(buffer, StandardCharsets.UTF_8);
        }
        catch (Throwable e) {
            LOG.error("Load metadata: exception thrown while load from file {}", (Object)this.getFileName(), (Object)e);
        }
        finally {
            if (null != inStream) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    LOG.error("Load metadata: fail in inStream.close for file {}", (Object)this.getFileName(), (Object)e);
                }
            }
        }
        return result;
    }

    public ImmutablePair<Boolean, String> validRequiredFields(InLongMetaConfig metaConfig) {
        if (metaConfig == null) {
            return ImmutablePair.of((Object)false, (Object)"metaConfig object is null");
        }
        if (metaConfig.getMd5() == null) {
            return ImmutablePair.of((Object)false, (Object)"metaConfig.md5 field is null");
        }
        if (metaConfig.getMqType() == null) {
            return ImmutablePair.of((Object)false, (Object)"metaConfig.mqType field is null");
        }
        if (metaConfig.getMqType() == CacheType.N) {
            return ImmutablePair.of((Object)false, (Object)"metaConfig.mqType value is CacheType.N");
        }
        if (metaConfig.getClusterConfigMap() == null) {
            return ImmutablePair.of((Object)false, (Object)"metaConfig.clusterConfigMap field is null");
        }
        if (metaConfig.getClusterConfigMap().isEmpty()) {
            return ImmutablePair.of((Object)false, (Object)"metaConfig.clusterConfigMap field is empty");
        }
        if (metaConfig.getIdTopicConfigMap() == null) {
            return ImmutablePair.of((Object)false, (Object)"metaConfig.idTopicConfigMap field is null");
        }
        if (metaConfig.getIdTopicConfigMap().isEmpty()) {
            return ImmutablePair.of((Object)false, (Object)"metaConfig.idTopicConfigMap is empty");
        }
        return ImmutablePair.of((Object)true, (Object)"ok");
    }
}

