/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.config.pojo;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.inlong.common.enums.DataTypeEnum;
import org.apache.inlong.common.enums.InlongCompressType;
import org.apache.inlong.common.enums.MessageWrapType;
import org.apache.inlong.sdk.commons.protocol.InlongId;

public class IdTopicConfig {
    private static final String DEFAULT_PULSAR_TENANT = "public";
    private String uid;
    private String inlongGroupId;
    private String inlongStreamid;
    private String topicName;
    private String tenant;
    private String nameSpace;
    private DataTypeEnum dataType = DataTypeEnum.TEXT;
    private String fieldDelimiter = "|";
    private String fileDelimiter = "\n";
    private Boolean useExtendedFields = false;
    private MessageWrapType msgWrapType = MessageWrapType.UNKNOWN;
    private InlongCompressType v1CompressType = InlongCompressType.INLONG_SNAPPY;
    private Map<String, String> params = new HashMap<String, String>();

    public boolean isUseExtendedFields() {
        return this.useExtendedFields;
    }

    public void setUseExtendedFields(Boolean useExtendedFields) {
        this.useExtendedFields = useExtendedFields;
    }

    public MessageWrapType getMsgWrapType() {
        return this.msgWrapType;
    }

    public void setMsgWrapType(MessageWrapType msgWrapType) {
        this.msgWrapType = msgWrapType;
    }

    public InlongCompressType getV1CompressType() {
        return this.v1CompressType;
    }

    public void setV1CompressType(InlongCompressType v1CompressType) {
        this.v1CompressType = v1CompressType;
    }

    public String getUid() {
        return this.uid;
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public void setInlongGroupId(String inlongGroupId) {
        this.inlongGroupId = inlongGroupId;
        this.uid = InlongId.generateUid((String)this.inlongGroupId, (String)this.inlongStreamid);
    }

    public void setInlongGroupIdAndStreamId(String inlongGroupId, String inlongStreamid) {
        this.inlongGroupId = inlongGroupId;
        this.inlongStreamid = inlongStreamid;
        this.uid = InlongId.generateUid((String)this.inlongGroupId, (String)this.inlongStreamid);
    }

    public String getPulsarTopicName(String clusterTenant, String clusterNameSpace) {
        StringBuilder builder = new StringBuilder(256);
        if (StringUtils.isBlank((String)this.tenant)) {
            if (StringUtils.isBlank((String)clusterTenant)) {
                builder.append(DEFAULT_PULSAR_TENANT).append("/");
            } else {
                builder.append(clusterTenant).append("/");
            }
        } else {
            builder.append(this.tenant).append("/");
        }
        if (StringUtils.isBlank((String)this.nameSpace)) {
            builder.append(clusterNameSpace).append("/");
        } else {
            builder.append(this.nameSpace).append("/");
        }
        return builder.append(this.topicName).toString();
    }

    public String getInlongStreamid() {
        return this.inlongStreamid;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public DataTypeEnum getDataType() {
        return this.dataType;
    }

    public void setDataType(DataTypeEnum dataType) {
        this.dataType = dataType;
    }

    public String getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public void setFieldDelimiter(String fieldDelimiter) {
        this.fieldDelimiter = fieldDelimiter;
    }

    public String getFileDelimiter() {
        return this.fileDelimiter;
    }

    public void setFileDelimiter(String fileDelimiter) {
        this.fileDelimiter = fileDelimiter;
    }

    public void setTenantAndNameSpace(String tenant, String nameSpace) {
        this.tenant = tenant;
        this.nameSpace = nameSpace;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("uid", (Object)this.uid).append("inlongGroupId", (Object)this.inlongGroupId).append("inlongStreamid", (Object)this.inlongStreamid).append("topicName", (Object)this.topicName).append("tenant", (Object)this.tenant).append("nameSpace", (Object)this.nameSpace).append("dataType", (Object)this.dataType).append("fieldDelimiter", (Object)this.fieldDelimiter).append("fileDelimiter", (Object)this.fileDelimiter).append("useExtendedFields", (Object)this.useExtendedFields).append("msgWrapType", (Object)this.msgWrapType).append("pbCompressType", (Object)this.v1CompressType).append("params", this.params).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdTopicConfig)) {
            return false;
        }
        IdTopicConfig that = (IdTopicConfig)o;
        return this.uid.equals(that.uid) && Objects.equals(this.inlongGroupId, that.inlongGroupId) && Objects.equals(this.inlongStreamid, that.inlongStreamid) && this.topicName.equals(that.topicName) && Objects.equals(this.tenant, that.tenant) && Objects.equals(this.nameSpace, that.nameSpace) && this.dataType == that.dataType && Objects.equals(this.fieldDelimiter, that.fieldDelimiter) && Objects.equals(this.fileDelimiter, that.fileDelimiter) && Objects.equals(this.useExtendedFields, that.useExtendedFields) && Objects.equals(this.msgWrapType, that.msgWrapType) && this.v1CompressType == that.v1CompressType && Objects.equals(this.params, that.params);
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.inlongGroupId, this.inlongStreamid, this.topicName, this.tenant, this.nameSpace, this.dataType, this.fieldDelimiter, this.fileDelimiter, this.useExtendedFields, this.msgWrapType, this.v1CompressType, this.params);
    }
}

