/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.config.pojo;

import java.util.HashMap;
import java.util.Map;
import org.apache.flume.Context;
import org.apache.pulsar.shade.io.netty.util.NettyRuntime;
import org.apache.pulsar.shade.io.netty.util.internal.SystemPropertyUtil;

public class MQClusterConfig
extends Context {
    private static final String SEND_REMOTE = "send_remote";
    private static final boolean DEFAULT_SEND_REMOTE = false;
    private static final String SEND_TIMEOUT = "send_timeout_mill";
    private static final int DEFAULT_SEND_TIMEOUT_MILL = 30000;
    private static final String CLIENT_ID_CACHE = "client_id_cache";
    private static final boolean DEFAULT_CLIENT_ID_CACHE = true;
    private static final String CLIENT_TIMEOUT = "client_timeout_second";
    private static final int DEFAULT_CLIENT_TIMEOUT_SECOND = 30;
    private static final String ENABLE_BATCH = "enable_batch";
    private static final boolean DEFAULT_ENABLE_BATCH = true;
    private static final String BLOCK_IF_QUEUE_FULL = "block_if_queue_full";
    private static final boolean DEFAULT_BLOCK_IF_QUEUE_FULL = true;
    private static final String MAX_PENDING_MESSAGES = "max_pending_messages";
    private static final int DEFAULT_MAX_PENDING_MESSAGES = 10000;
    private static final String MAX_PENDING_MESSAGES_ACROSS_PARTITIONS = "max_pending_messages_across_partitions";
    private static final int DEFAULT_MAX_PENDING_MESSAGES_ACROSS_PARTITIONS = 500000;
    private static final String COMPRESSION_TYPE = "compression_type";
    private static final String DEFAULT_COMPRESSION_TYPE = "NONE";
    private static final String MAX_BATCHING_MESSAGES = "max_batching_messages";
    private static final int DEFAULT_MAX_BATCHING_MESSAGES = 1000;
    private static final String MAX_BATCHING_BYTES = "max_batching_bytes";
    private static final int DEFAULT_MAX_BATCHING_BYTES = 131072;
    private static final String MAX_BATCHING_PUBLISH_DELAY_MILLIS = "max_batching_publish_delay_millis";
    private static final long DEFAULT_MAX_BATCHING_PUBLISH_DELAY_MILLIS = 1L;
    private static final String RETRY_INTERVAL_WHEN_SEND_ERROR_MILL = "retry_interval_when_send_error_ms";
    private static final long DEFAULT_RETRY_INTERVAL_WHEN_SEND_ERROR_MILL = 30000L;
    private static final String SLA_METRIC_SINK = "sla_metric_sink";
    private static final boolean DEFAULT_SLA_METRIC_SINK = false;
    private static final String MAX_SURVIVED_TIME = "max_survived_time";
    private static final int DEFAULT_MAX_SURVIVED_TIME = 30000;
    private static final String MAX_SURVIVED_SIZE = "max_survived_size";
    private static final int DEFAULT_MAX_SURVIVED_SIZE = 5000000;
    private static final String NEW_CHECK_PATTERN = "new_check_pattern";
    private static final boolean DEFAULT_NEW_CHECK_PATTERN = true;
    private static final String OLD_METRIC_ON = "old_metric_on";
    private static final boolean DEFAULT_OLD_METRIC_ON = true;
    private static final String SET_VALUE = "set";
    private static final int DEFAULT_SET_VALUE = 10;
    private static final String MAX_TOPICS_EACH_PRODUCER_HOLD = "max_topic_each_producer_hold";
    private static final int DEFAULT_MAX_TOPICS_EACH_PRODUCER_HOLD = 200;
    private static final String TUBE_REQUEST_TIMEOUT = "tube_request_timeout";
    private static final long DEFAULT_TUBE_REQUEST_TIMEOUT = 20000L;
    private static final String LINK_MAX_ALLOWED_DELAYED_MSG_COUNT = "link_max_allowed_delayed_msg_count";
    private static final long DEFAULT_LINK_MAX_ALLOWED_DELAYED_MSG_COUNT = 80000L;
    private static final String SESSION_WARN_DELAYED_MSG_COUNT = "session_warn_delayed_msg_count";
    private static final long DEFAULT_SESSION_WARN_DELAYED_MSG_COUNT = 2000000L;
    private static final String SESSION_MAX_ALLOWED_DELAYED_MSG_COUNT = "session_max_allowed_delayed_msg_count";
    private static final long DEFAULT_SESSION_MAX_ALLOWED_DELAYED_MSG_COUNT = 4000000L;
    private static final String NETTY_WRITE_BUFFER_HIGH_WATER_MARK = "netty_write_buffer_high_water_mark";
    private static final long DEFAULT_NETTY_WRITE_BUFFER_HIGH_WATER_MARK = 0xF00000L;
    private static final String HEARTBEAT_C2M_PERIOD_MS_MARK = "tube_heartbeat_period_ms";
    private static final long DEFAULT_HEARTBEAT_C2M_PERIOD_MS = 15000L;
    private static final String RECOVER_THREAD_COUNT = "recover_thread_count";
    private static final int DEFAULT_RECOVER_THREAD_COUNT = Runtime.getRuntime().availableProcessors() + 1;
    private static final String LOG_TOPIC = "proxy_log_topic";
    private static final String DEFAULT_LOG_TOPIC = "manager";
    private static final String LOG_GROUP_ID = "proxy_log_groupid";
    private static final String DEFAULT_LOG_GROUP_ID = "proxy_measure_log";
    private static final String LOG_STREAM_ID = "proxy_log_streamid";
    private static final String DEFAULT_LOG_STREAM_ID = "manager";
    private static final String LOG_EVERY_N_EVENTS = "log_every_n_events";
    private static final int DEFAULT_LOG_EVERY_N_EVENTS = 100000;
    private static final String STAT_INTERVAL_SEC = "stat_interval_sec";
    private static final int DEFAULT_STAT_INTERVAL_SEC = 60;
    private static final String SINK_THREAD_NUM = "thread_num";
    private static final int DEFAULT_THREAD_NUM = 4;
    private static final String DISK_IO_RATE_PER_SEC = "disk_io_rate_per_sec";
    private static final long DEFAULT_DISK_IO_RATE_PER_SEC = 0L;
    private static final String PULSAR_IO_THREADS = "pulsar_io_threads";
    private static final int DEFAULT_PULSAR_IO_THREADS = Math.max(1, SystemPropertyUtil.getInt((String)"io.netty.eventLoopThreads", (int)(NettyRuntime.availableProcessors() * 2)));
    private static final String PULSAR_CONNECTIONS_PRE_BROKER = "connections_pre_broker";
    private static final int DEFAULT_CONNECTIONS_PRE_BROKER = 1;
    private static final String EVENT_QUEUE_SIZE = "event_queue_size";
    private static final int DEFAULT_EVENT_QUEUE_SIZE = 10000;
    private static final String BAD_EVENT_QUEUE_SIZE = "bad_event_queue_size";
    private static final int DEFAULT_BAD_EVENT_QUEUE_SIZE = 10000;
    private static final String MAX_RETRY_SEND_TIMES = "max_retry_send_times";
    private static final int DEFAULT_MAX_RETRY_SEND_TIMES = 16;
    public static String PULSAR_AUTH_TYPE = "pulsar_auth_type";
    public static String PULSAR_DEFAULT_AUTH_TYPE = "token";
    private Map<String, String> url2token = new HashMap<String, String>();

    public long getLinkMaxAllowedDelayedMsgCount() {
        return this.getLong(LINK_MAX_ALLOWED_DELAYED_MSG_COUNT, 80000L);
    }

    public long getSessionWarnDelayedMsgCount() {
        return this.getLong(SESSION_WARN_DELAYED_MSG_COUNT, 2000000L);
    }

    public long getSessionMaxAllowedDelayedMsgCount() {
        return this.getLong(SESSION_MAX_ALLOWED_DELAYED_MSG_COUNT, 4000000L);
    }

    public long getNettyWriteBufferHighWaterMark() {
        return this.getLong(NETTY_WRITE_BUFFER_HIGH_WATER_MARK, 0xF00000L);
    }

    public long getTubeHeartbeatPeriodMs() {
        return this.getLong(HEARTBEAT_C2M_PERIOD_MS_MARK, 15000L);
    }

    public int getRecoverThreadCount() {
        return this.getInteger(RECOVER_THREAD_COUNT, DEFAULT_RECOVER_THREAD_COUNT);
    }

    public int getEventQueueSize() {
        return this.getInteger(EVENT_QUEUE_SIZE, 10000);
    }

    public int getBadEventQueueSize() {
        return this.getInteger(BAD_EVENT_QUEUE_SIZE, 10000);
    }

    public Map<String, String> getUrl2token() {
        return this.url2token;
    }

    public void setUrl2token(Map<String, String> url2token) {
        this.url2token = url2token;
    }

    public String getAuthType() {
        return this.getString(PULSAR_AUTH_TYPE, PULSAR_DEFAULT_AUTH_TYPE);
    }

    public int getPulsarClientIoThreads() {
        return this.getInteger(PULSAR_IO_THREADS, DEFAULT_PULSAR_IO_THREADS);
    }

    public int getPulsarConnectionsPreBroker() {
        return this.getInteger(PULSAR_CONNECTIONS_PRE_BROKER, 1);
    }

    public int getSendTimeoutMs() {
        return this.getInteger(SEND_TIMEOUT, 30000);
    }

    public int getClientTimeoutSecond() {
        return this.getInteger(CLIENT_TIMEOUT, 30);
    }

    public int getMaxBatchingBytes() {
        return this.getInteger(MAX_BATCHING_BYTES, 131072);
    }

    public long getMaxBatchingPublishDelayMillis() {
        return this.getLong(MAX_BATCHING_PUBLISH_DELAY_MILLIS, 1L);
    }

    public boolean getEnableBatch() {
        return this.getBoolean(ENABLE_BATCH, true);
    }

    public boolean getBlockIfQueueFull() {
        return this.getBoolean(BLOCK_IF_QUEUE_FULL, true);
    }

    public int getMaxPendingMessages() {
        return this.getInteger(MAX_PENDING_MESSAGES, 10000);
    }

    public int getMaxPendingMessagesAcrossPartitions() {
        return this.getInteger(MAX_PENDING_MESSAGES_ACROSS_PARTITIONS, 500000);
    }

    public String getCompressionType() {
        return this.getString(COMPRESSION_TYPE, DEFAULT_COMPRESSION_TYPE);
    }

    public int getMaxBatchingMessages() {
        return this.getInteger(MAX_BATCHING_MESSAGES, 1000);
    }

    public long getRetryIntervalWhenSendErrorMs() {
        return this.getLong(RETRY_INTERVAL_WHEN_SEND_ERROR_MILL, 30000L);
    }

    public int getMaxRetryCnt() {
        return this.getInteger(MAX_RETRY_SEND_TIMES, 16);
    }

    public int getStatIntervalSec() {
        return this.getInteger(STAT_INTERVAL_SEC, 60);
    }

    public int getLogEveryNEvents() {
        return this.getInteger(LOG_EVERY_N_EVENTS, 100000);
    }

    public boolean getClientIdCache() {
        return this.getBoolean(CLIENT_ID_CACHE, true);
    }

    public int getThreadNum() {
        return this.getInteger(SINK_THREAD_NUM, 4);
    }

    public long getDiskIoRatePerSec() {
        return this.getLong(DISK_IO_RATE_PER_SEC, 0L);
    }

    public int getMaxSurvivedTime() {
        return this.getInteger(MAX_SURVIVED_TIME, 30000);
    }

    public int getMaxSurvivedSize() {
        return this.getInteger(MAX_SURVIVED_SIZE, 5000000);
    }

    public boolean getNewCheckPattern() {
        return this.getBoolean(NEW_CHECK_PATTERN, true);
    }

    public boolean getOldMetricOn() {
        return this.getBoolean(OLD_METRIC_ON, true);
    }

    public int getSetValue() {
        return this.getInteger(SET_VALUE, 10);
    }

    public int getMaxTopicsEachProducerHold() {
        return this.getInteger(MAX_TOPICS_EACH_PRODUCER_HOLD, 200);
    }

    public long getTubeRpcTimeoutMs() {
        return this.getLong(TUBE_REQUEST_TIMEOUT, 20000L);
    }

    public String getLogTopic() {
        return this.getString(LOG_TOPIC, "manager");
    }

    public String getLogStreamId() {
        return this.getString(LOG_STREAM_ID, "manager");
    }

    public String getLogGroupId() {
        return this.getString(LOG_GROUP_ID, DEFAULT_LOG_GROUP_ID);
    }

    public boolean getEnableSendRemote() {
        return this.getBoolean(SEND_REMOTE, false);
    }

    public boolean getEnableSlaMetricSink() {
        return this.getBoolean(SLA_METRIC_SINK, false);
    }
}

