/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.sink.common;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.flume.FlumeException;
import org.apache.inlong.dataproxy.config.pojo.MQClusterConfig;
import org.apache.inlong.dataproxy.sink.common.TubeUtils;
import org.apache.inlong.tubemq.client.config.TubeClientConfig;
import org.apache.inlong.tubemq.client.exception.TubeClientException;
import org.apache.inlong.tubemq.client.factory.TubeMultiSessionFactory;
import org.apache.inlong.tubemq.client.producer.MessageProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TubeProducerHolder {
    private static final Logger logger = LoggerFactory.getLogger(TubeProducerHolder.class);
    private static final long SEND_FAILURE_WAIT = 30000L;
    private static final long PUBLISH_FAILURE_WAIT = 60000L;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final String sinkName;
    private final String clusterAddr;
    private final MQClusterConfig clusterConfig;
    private TubeMultiSessionFactory sessionFactory = null;
    private final Map<String, MessageProducer> producerMap = new ConcurrentHashMap<String, MessageProducer>();
    private MessageProducer lastProducer = null;
    private final AtomicInteger lastPubTopicCnt = new AtomicInteger(0);
    private static final ConcurrentHashMap<String, AtomicLong> FROZEN_TOPIC_MAP = new ConcurrentHashMap();

    public TubeProducerHolder(String sinkName, String clusterAddr, MQClusterConfig tubeConfig) {
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)clusterAddr), (Object)"No TubeMQ's cluster address list specified");
        this.sinkName = sinkName;
        this.clusterAddr = clusterAddr;
        this.clusterConfig = tubeConfig;
    }

    public void start(Set<String> configTopicSet) {
        if (!this.started.compareAndSet(false, true)) {
            logger.info("ProducerHolder for " + this.sinkName + " has started!");
            return;
        }
        logger.info("ProducerHolder for " + this.sinkName + " begin to start!");
        try {
            TubeClientConfig clientConfig = TubeUtils.buildClientConfig(this.clusterAddr, this.clusterConfig);
            this.sessionFactory = new TubeMultiSessionFactory(clientConfig);
            this.createProducersByTopicSet(configTopicSet);
        }
        catch (Throwable e) {
            this.stop();
            String errInfo = "Build session factory  to " + this.clusterAddr + " for " + this.sinkName + " failure, please re-check";
            logger.error(errInfo, e);
            throw new FlumeException(errInfo);
        }
        logger.info("ProducerHolder for " + this.sinkName + " started!");
    }

    public void stop() {
        if (this.started.get()) {
            return;
        }
        if (!this.started.compareAndSet(true, false)) {
            logger.info("ProducerHolder for " + this.sinkName + " has stopped!");
            return;
        }
        logger.info("ProducerHolder for " + this.sinkName + " begin to stop!");
        for (Map.Entry<String, MessageProducer> entry : this.producerMap.entrySet()) {
            if (entry == null || entry.getValue() == null) continue;
            try {
                entry.getValue().shutdown();
            }
            catch (Throwable throwable) {}
        }
        this.producerMap.clear();
        this.lastProducer = null;
        this.lastPubTopicCnt.set(0);
        FROZEN_TOPIC_MAP.clear();
        if (this.sessionFactory != null) {
            try {
                this.sessionFactory.shutdown();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.sessionFactory = null;
        }
        logger.info("ProducerHolder for " + this.sinkName + " finished stop!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageProducer getProducer(String topicName) throws TubeClientException {
        AtomicLong fbdTime = FROZEN_TOPIC_MAP.get(topicName);
        if (fbdTime != null && fbdTime.get() > System.currentTimeMillis()) {
            return null;
        }
        MessageProducer tmpProducer = this.producerMap.get(topicName);
        if (tmpProducer != null) {
            if (fbdTime != null) {
                FROZEN_TOPIC_MAP.remove(topicName);
            }
            return tmpProducer;
        }
        AtomicInteger atomicInteger = this.lastPubTopicCnt;
        synchronized (atomicInteger) {
            fbdTime = FROZEN_TOPIC_MAP.get(topicName);
            if (fbdTime != null && fbdTime.get() > System.currentTimeMillis()) {
                return null;
            }
            if (this.lastProducer == null || this.lastPubTopicCnt.get() >= this.clusterConfig.getMaxTopicsEachProducerHold()) {
                this.lastProducer = this.sessionFactory.createProducer();
                this.lastPubTopicCnt.set(0);
            }
            try {
                this.lastProducer.publish(topicName);
            }
            catch (Throwable e) {
                AtomicLong tmpFbdTime;
                fbdTime = FROZEN_TOPIC_MAP.get(topicName);
                if (fbdTime == null && (fbdTime = FROZEN_TOPIC_MAP.putIfAbsent(topicName, tmpFbdTime = new AtomicLong())) == null) {
                    fbdTime = tmpFbdTime;
                }
                fbdTime.set(System.currentTimeMillis() + 60000L);
                logger.warn("Throw exception while publish topic=" + topicName + ", exception is " + e.getMessage());
                return null;
            }
            this.producerMap.put(topicName, this.lastProducer);
            this.lastPubTopicCnt.incrementAndGet();
            return this.lastProducer;
        }
    }

    public boolean needFrozenSent(String topicName, Throwable throwable) {
        String message;
        if (throwable instanceof TubeClientException && (message = throwable.getMessage()) != null && (message.contains("No available partition for topic") || message.contains("The brokers of topic are all forbidden"))) {
            AtomicLong tmpFbdTime;
            AtomicLong fbdTime = FROZEN_TOPIC_MAP.get(topicName);
            if (fbdTime == null && (fbdTime = FROZEN_TOPIC_MAP.putIfAbsent(topicName, tmpFbdTime = new AtomicLong(0L))) == null) {
                fbdTime = tmpFbdTime;
            }
            fbdTime.set(System.currentTimeMillis() + 30000L);
            return true;
        }
        return false;
    }

    public synchronized void createProducersByTopicSet(Set<String> cfgTopicSet) throws Exception {
        int paddingCnt;
        if (cfgTopicSet == null || cfgTopicSet.isEmpty()) {
            return;
        }
        ArrayList<String> filteredTopics = new ArrayList<String>(cfgTopicSet.size());
        for (String topicName : cfgTopicSet) {
            if (StringUtils.isBlank((CharSequence)topicName) || this.producerMap.get(topicName) != null) continue;
            filteredTopics.add(topicName);
        }
        if (filteredTopics.isEmpty()) {
            return;
        }
        Collections.sort(filteredTopics);
        long startTime = System.currentTimeMillis();
        int maxPublishTopicCnt = this.clusterConfig.getMaxTopicsEachProducerHold();
        int allocTotalCnt = filteredTopics.size();
        ArrayList<Integer> topicGroupCnt = new ArrayList<Integer>();
        int n = paddingCnt = this.lastPubTopicCnt.get() <= 0 ? 0 : maxPublishTopicCnt - this.lastPubTopicCnt.get();
        while (allocTotalCnt > 0) {
            if (paddingCnt > 0) {
                topicGroupCnt.add(Math.min(allocTotalCnt, paddingCnt));
                allocTotalCnt -= paddingCnt;
                paddingCnt = 0;
                continue;
            }
            topicGroupCnt.add(Math.min(allocTotalCnt, maxPublishTopicCnt));
            allocTotalCnt -= maxPublishTopicCnt;
        }
        int startPos = 0;
        int endPos = 0;
        HashSet subTopicSet = new HashSet();
        for (Integer dltCnt : topicGroupCnt) {
            subTopicSet.clear();
            endPos = startPos + dltCnt;
            for (int index = startPos; index < endPos; ++index) {
                subTopicSet.add(filteredTopics.get(index));
            }
            startPos = endPos;
            if (this.lastProducer == null || this.lastPubTopicCnt.get() == maxPublishTopicCnt) {
                this.lastProducer = this.sessionFactory.createProducer();
                this.lastPubTopicCnt.set(0);
            }
            try {
                this.lastProducer.publish(subTopicSet);
            }
            catch (Throwable e) {
                logger.info(this.sinkName + " meta sink publish fail.", e);
            }
            this.lastPubTopicCnt.addAndGet(subTopicSet.size());
            for (String topicItem : subTopicSet) {
                this.producerMap.put(topicItem, this.lastProducer);
            }
        }
        logger.info(this.sinkName + " initializes producers for topics:" + this.producerMap.keySet() + ", cost: " + (System.currentTimeMillis() - startTime) + "ms");
    }
}

