/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.sink.common;

import java.util.Map;
import org.apache.flume.Event;
import org.apache.inlong.dataproxy.config.pojo.MQClusterConfig;
import org.apache.inlong.dataproxy.utils.DateTimeUtils;
import org.apache.inlong.dataproxy.utils.MessageUtils;
import org.apache.inlong.tubemq.client.config.TubeClientConfig;
import org.apache.inlong.tubemq.corebase.Message;

public class TubeUtils {
    public static TubeClientConfig buildClientConfig(String clusterAddr, MQClusterConfig tubeConfig) {
        TubeClientConfig tubeClientConfig = new TubeClientConfig(clusterAddr);
        tubeClientConfig.setLinkMaxAllowedDelayedMsgCount(tubeConfig.getLinkMaxAllowedDelayedMsgCount());
        tubeClientConfig.setSessionWarnDelayedMsgCount(tubeConfig.getSessionWarnDelayedMsgCount());
        tubeClientConfig.setSessionMaxAllowedDelayedMsgCount(tubeConfig.getSessionMaxAllowedDelayedMsgCount());
        tubeClientConfig.setNettyWriteBufferHighWaterMark(tubeConfig.getNettyWriteBufferHighWaterMark());
        tubeClientConfig.setHeartbeatPeriodMs(tubeConfig.getTubeHeartbeatPeriodMs());
        tubeClientConfig.setRpcTimeoutMs(tubeConfig.getTubeRpcTimeoutMs());
        return tubeClientConfig;
    }

    public static Message buildMessage(String topicName, Event event) {
        Map headers = event.getHeaders();
        Message message = new Message(topicName, event.getBody());
        String pkgVersion = (String)headers.get("msgEnType");
        long dataTimeL = Long.parseLong((String)headers.get("msg.pkg.time"));
        message.putSystemHeader((String)headers.get("inlongStreamId"), DateTimeUtils.ms2yyyyMMddHHmm(dataTimeL));
        Map<String, String> extraAttrMap = MessageUtils.getXfsAttrs(headers, pkgVersion);
        for (Map.Entry<String, String> entry : extraAttrMap.entrySet()) {
            message.setAttrKeyVal(entry.getKey(), entry.getValue());
        }
        return message;
    }
}

