/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.source.v0msg;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.flume.Event;
import org.apache.inlong.common.enums.DataProxyErrCode;
import org.apache.inlong.common.enums.MessageWrapType;
import org.apache.inlong.dataproxy.source.BaseSource;

public abstract class AbsV0MsgCodec {
    protected static final Splitter.MapSplitter mapSplitter = Splitter.on((String)"&").trimResults().withKeyValueSeparator("=");
    protected static final Joiner.MapJoiner mapJoiner = Joiner.on((String)"&").withKeyValueSeparator("=");
    protected final Map<String, String> attrMap = new HashMap<String, String>();
    protected DataProxyErrCode errCode = DataProxyErrCode.UNKNOWN_ERROR;
    protected String errMsg = "";
    protected String strRemoteIP;
    protected long msgRcvTime;
    protected int totalDataLen;
    protected byte msgType;
    protected int msgCount;
    protected String origAttr = "";
    protected byte[] bodyData;
    protected byte[] origBody = null;
    protected long dataTimeMs;
    protected String groupId;
    protected String streamId = "";
    protected String topicName;
    protected String msgSeqId = "";
    protected long uniq = -1L;
    protected boolean indexMsg = false;
    protected boolean fileCheckMsg = false;
    protected boolean isOrderOrProxy = false;
    protected String msgProcType = "b2b";
    protected boolean needResp = true;
    protected long msgPkgTime;
    protected long auditVersion = -1L;

    public AbsV0MsgCodec(int totalDataLen, int msgTypeValue, long msgRcvTime, String strRemoteIP) {
        this.totalDataLen = totalDataLen;
        this.msgType = (byte)(msgTypeValue & 0xFF);
        this.msgRcvTime = msgRcvTime;
        this.strRemoteIP = strRemoteIP;
    }

    public abstract boolean descMsg(BaseSource var1, ByteBuf var2) throws Exception;

    public abstract boolean validAndFillFields(BaseSource var1, StringBuilder var2);

    public abstract Event encEventPackage(BaseSource var1, Channel var2);

    public DataProxyErrCode getErrCode() {
        return this.errCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public boolean isIndexMsg() {
        return this.indexMsg;
    }

    public boolean isNeedResp() {
        return this.needResp;
    }

    public boolean isOrderOrProxy() {
        return this.isOrderOrProxy;
    }

    public byte getMsgType() {
        return this.msgType;
    }

    public String getAttr() {
        return this.origAttr;
    }

    public Map<String, String> getAttrMap() {
        return this.attrMap;
    }

    public long getUniq() {
        return this.uniq;
    }

    public long getDataTimeMs() {
        return this.dataTimeMs;
    }

    public long getMsgPkgTime() {
        return this.msgPkgTime;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public String getMsgProcType() {
        return this.msgProcType;
    }

    public int getBodyLength() {
        return this.bodyData == null ? 0 : this.bodyData.length;
    }

    public int getMsgCount() {
        return this.msgCount;
    }

    public String getStrRemoteIP() {
        return this.strRemoteIP;
    }

    public byte[] getOrigBody() {
        return this.origBody;
    }

    public long getMsgRcvTime() {
        return this.msgRcvTime;
    }

    public void setSuccessInfo() {
        this.errCode = DataProxyErrCode.SUCCESS;
        this.errMsg = "";
    }

    public void setFailureInfo(DataProxyErrCode errCode) {
        this.setFailureInfo(errCode, "");
    }

    public void setFailureInfo(DataProxyErrCode errCode, String errMsg) {
        this.errCode = errCode;
        this.errMsg = errMsg;
    }

    protected boolean decAttrInfo(BaseSource source, ByteBuf cb, int attrLen, int attrPos) throws Exception {
        if (attrLen > 0) {
            byte[] attrData = new byte[attrLen];
            cb.getBytes(attrPos, attrData, 0, attrLen);
            try {
                this.origAttr = new String(attrData, StandardCharsets.UTF_8);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.origAttr)) {
            try {
                this.attrMap.putAll(mapSplitter.split((CharSequence)this.origAttr));
            }
            catch (Exception e) {
                source.fileMetricIncSumStats("msg.attr.invalid");
                this.errCode = DataProxyErrCode.SPLIT_ATTR_ERROR;
                this.errMsg = String.format("Parse attr (%s) failure", this.origAttr);
                return false;
            }
        }
        if ("false".equalsIgnoreCase(this.attrMap.get("isAck"))) {
            this.needResp = false;
        }
        if ("true".equalsIgnoreCase(this.attrMap.get("syncSend"))) {
            if (!this.needResp) {
                this.needResp = true;
                source.fileMetricIncSumStats("msg.attr.order.noack");
                this.errCode = DataProxyErrCode.ATTR_ORDER_CONTROL_CONFLICT_ERROR;
                return false;
            }
            this.isOrderOrProxy = true;
            this.msgProcType = "order";
        }
        if ("true".equalsIgnoreCase(this.attrMap.get("proxySend"))) {
            if (!this.needResp) {
                this.needResp = true;
                source.fileMetricIncSumStats("msg.attr.proxy.noack");
                this.errCode = DataProxyErrCode.ATTR_PROXY_CONTROL_CONFLICT_ERROR;
                return false;
            }
            this.isOrderOrProxy = true;
            this.msgProcType = "proxy";
        }
        return true;
    }

    protected Map<String, String> buildEventHeaders(BaseSource source) {
        String partitionKey;
        String proxySend;
        String syncSend;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("groupId", this.groupId);
        headers.put("streamId", this.streamId);
        headers.put("topic", this.topicName);
        headers.put("dt", String.valueOf(this.dataTimeMs));
        headers.put("srcIp", this.strRemoteIP);
        headers.put("dpIp", source.getSrcHost());
        headers.put("msgcnt", String.valueOf(this.msgCount));
        headers.put("msgEnType", MessageWrapType.INLONG_MSG_V0.getStrId());
        headers.put("version", MessageWrapType.INLONG_MSG_V0.getStrId());
        headers.put("rt", String.valueOf(this.msgRcvTime));
        headers.put("uniq", String.valueOf(this.uniq));
        headers.put("msg.pkg.time", String.valueOf(this.msgPkgTime));
        headers.put("auditVersion", String.valueOf(this.auditVersion));
        if (!this.needResp) {
            headers.put("isAck", "false");
        }
        if (StringUtils.isNotEmpty((CharSequence)(syncSend = this.attrMap.get("syncSend")))) {
            headers.put("syncSend", syncSend);
        }
        if (StringUtils.isNotEmpty((CharSequence)(proxySend = this.attrMap.get("proxySend")))) {
            headers.put("proxySend", proxySend);
        }
        if (this.isOrderOrProxy) {
            headers.put("attrs", this.origAttr);
        }
        if (StringUtils.isNotEmpty((CharSequence)(partitionKey = this.attrMap.get("partitionKey")))) {
            headers.put("partitionKey", partitionKey);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.msgSeqId)) {
            headers.put("sequencial_id", this.msgSeqId);
        }
        return headers;
    }
}

