/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.source.v1msg;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.inlong.common.monitor.LogCounter;
import org.apache.inlong.sdk.commons.protocol.ProxySdk;
import org.apache.inlong.sdk.commons.protocol.SourceCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InlongTcpSourceCallback
implements SourceCallback {
    private static final Logger logger = LoggerFactory.getLogger(InlongTcpSourceCallback.class);
    private static final LogCounter logCounter = new LogCounter(10, 100000, 30000);
    private final ChannelHandlerContext ctx;
    private final ProxySdk.MessagePackHeader header;
    private final CountDownLatch latch;
    private final AtomicBoolean hasResponsed = new AtomicBoolean(false);

    public InlongTcpSourceCallback(ChannelHandlerContext ctx, ProxySdk.MessagePackHeader header) {
        this.ctx = ctx;
        this.header = header;
        this.latch = new CountDownLatch(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callback(ProxySdk.ResultCode resultCode) {
        if (this.hasResponsed.getAndSet(true)) {
            return;
        }
        try {
            ProxySdk.ResponseInfo.Builder builder = ProxySdk.ResponseInfo.newBuilder();
            builder.setResult(resultCode);
            builder.setPackId(this.header.getPackId());
            byte[] responseBytes = builder.build().toByteArray();
            ByteBuf buffer = Unpooled.wrappedBuffer((byte[])responseBytes);
            Channel remoteChannel = this.ctx.channel();
            if (remoteChannel.isWritable()) {
                remoteChannel.write((Object)buffer);
            } else {
                if (logCounter.shouldPrint()) {
                    logger.warn("the send buffer2 is full, so disconnect it! please check remote client; Connection info:{}", (Object)remoteChannel);
                }
                buffer.release();
            }
        }
        catch (Throwable e) {
            if (logCounter.shouldPrint()) {
                logger.error("Send response failure", e);
            }
        }
        finally {
            this.latch.countDown();
        }
    }

    public AtomicBoolean getHasResponsed() {
        return this.hasResponsed;
    }

    public CountDownLatch getLatch() {
        return this.latch;
    }
}

