/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.utils;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.dataproxy.utils.SizeSemaphore;

public class BufferQueue<A> {
    private final LinkedBlockingQueue<A> queue;
    private final SizeSemaphore currentTokens;
    private SizeSemaphore globalTokens = null;
    private final AtomicLong offerCount = new AtomicLong(0L);
    private final AtomicLong pollCount = new AtomicLong(0L);
    private final AtomicLong takeCount = new AtomicLong(0L);

    public BufferQueue(int maxSizeKb) {
        this.queue = new LinkedBlockingQueue();
        this.currentTokens = new SizeSemaphore(maxSizeKb, 1024);
    }

    public BufferQueue(int maxSizeKb, SizeSemaphore globalTokens) {
        this(maxSizeKb);
        this.globalTokens = globalTokens;
    }

    public A pollRecord() {
        A record = this.queue.poll();
        this.pollCount.getAndIncrement();
        return record;
    }

    public A takeRecord() {
        try {
            A record = this.queue.take();
            this.takeCount.incrementAndGet();
            return record;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public void offer(A record) {
        if (record == null) {
            return;
        }
        this.queue.offer(record);
        this.offerCount.incrementAndGet();
    }

    public int size() {
        return this.queue.size();
    }

    public int leftKb() {
        return this.currentTokens.leftSemaphore();
    }

    public int availablePermits() {
        return this.currentTokens.availablePermits();
    }

    public int maxSizeKb() {
        return this.currentTokens.maxSize();
    }

    public double getIdleRate() {
        double remaining = this.currentTokens.availablePermits();
        return remaining * 100.0 / (double)this.currentTokens.maxSize();
    }

    public boolean tryAcquire(long sizeInByte) {
        if (this.globalTokens == null) {
            return this.currentTokens.tryAcquire(sizeInByte);
        }
        if (!this.globalTokens.tryAcquire(sizeInByte)) {
            return false;
        }
        if (this.currentTokens.tryAcquire(sizeInByte)) {
            return true;
        }
        this.globalTokens.release(sizeInByte);
        return false;
    }

    public void acquire(long sizeInByte) {
        if (this.globalTokens != null) {
            this.globalTokens.acquire(sizeInByte);
        }
        this.currentTokens.acquire(sizeInByte);
    }

    public void release(long sizeInByte) {
        this.currentTokens.release(sizeInByte);
        if (this.globalTokens != null) {
            this.globalTokens.release(sizeInByte);
        }
    }

    public long getOfferCount() {
        return this.offerCount.getAndSet(0L);
    }

    public long getPollCount() {
        return this.pollCount.getAndSet(0L);
    }

    public long getTakeCount() {
        return this.takeCount.getAndSet(0L);
    }
}

