/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.store;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.apache.inlong.agent.conf.JobProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalProfile {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalProfile.class);
    private static final String JSON_SUFFIX = ".json";
    private static final String PROPERTIES_SUFFIX = ".properties";
    private static final String PARENT_PATH = "/jobs";
    private final Path filePath;

    public LocalProfile(String parentConfPath) {
        String fileName = parentConfPath + PARENT_PATH;
        this.filePath = Paths.get(fileName, new String[0]);
    }

    public List<JobProfile> readFromLocal() {
        ArrayList<JobProfile> profileList;
        block20: {
            profileList = new ArrayList<JobProfile>();
            try {
                if (!Files.isDirectory(this.filePath, new LinkOption[0])) break block20;
                try (Stream<Path> pathStream = Files.list(this.filePath);){
                    Iterator it = pathStream.iterator();
                    while (it.hasNext()) {
                        String childPath = ((Path)it.next()).toString();
                        JobProfile jobProfile = null;
                        if (childPath.endsWith(JSON_SUFFIX)) {
                            jobProfile = JobProfile.parseJsonFile(childPath);
                        } else if (childPath.endsWith(PROPERTIES_SUFFIX)) {
                            jobProfile = JobProfile.parsePropertiesFile(childPath);
                        }
                        if (jobProfile == null || !jobProfile.allRequiredKeyExist()) continue;
                        profileList.add(jobProfile);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("error caught", (Throwable)e);
                }
            }
            catch (Exception ex) {
                LOGGER.error("error in reading files {}", (Object)this.filePath);
            }
        }
        return profileList;
    }
}

