/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.util.ClassUtils;
import springfox.documentation.RequestHandler;

public class RequestHandlerSelectors {
    private RequestHandlerSelectors() {
        throw new UnsupportedOperationException();
    }

    public static Predicate<RequestHandler> any() {
        return each -> true;
    }

    public static Predicate<RequestHandler> none() {
        return each -> false;
    }

    public static Predicate<RequestHandler> withMethodAnnotation(Class<? extends Annotation> annotation) {
        return input -> input.isAnnotatedWith(annotation);
    }

    public static Predicate<RequestHandler> withClassAnnotation(Class<? extends Annotation> annotation) {
        return input -> RequestHandlerSelectors.declaringClass(input).map(RequestHandlerSelectors.annotationPresent(annotation)).orElse(false);
    }

    private static Function<Class<?>, Boolean> annotationPresent(Class<? extends Annotation> annotation) {
        return input -> input.isAnnotationPresent(annotation);
    }

    private static Function<Class<?>, Boolean> handlerPackage(String basePackage) {
        return input -> ClassUtils.getPackageName((Class)input).startsWith(basePackage);
    }

    public static Predicate<RequestHandler> basePackage(String basePackage) {
        return input -> RequestHandlerSelectors.declaringClass(input).map(RequestHandlerSelectors.handlerPackage(basePackage)).orElse(true);
    }

    private static Optional<Class<?>> declaringClass(RequestHandler input) {
        return Optional.ofNullable(input.declaringClass());
    }
}

