/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.date4j;

import hirondelle.date4j.DateTime;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class DateTimeParser {
    private static final Pattern DATE = Pattern.compile("(\\d{1,4})-(\\d\\d)-(\\d\\d)|(\\d{1,4})-(\\d\\d)|(\\d{1,4})");
    private static final String CL = "\\:";
    private static final String TT = "(\\d\\d)";
    private static final String NUM_DIGITS_FOR_FRACTIONAL_SECONDS = "9";
    private static final Integer NUM_DIGITS = Integer.valueOf("9");
    private static final Pattern TIME = Pattern.compile("(\\d\\d)\\:(\\d\\d)\\:(\\d\\d)\\.(\\d{1,9})|(\\d\\d)\\:(\\d\\d)\\:(\\d\\d)|(\\d\\d)\\:(\\d\\d)|(\\d\\d)");
    private static final String COLON = ":";
    private static final int THIRD_POSITION = 2;
    private Integer fYear;
    private Integer fMonth;
    private Integer fDay;
    private Integer fHour;
    private Integer fMinute;
    private Integer fSecond;
    private Integer fNanosecond;

    DateTimeParser() {
    }

    DateTime parse(String aDateTime) {
        if (aDateTime == null) {
            throw new NullPointerException("DateTime string is null");
        }
        String dateTime = aDateTime.trim();
        Parts parts = this.splitIntoDateAndTime(dateTime);
        if (parts.hasTwoParts()) {
            this.parseDate(parts.datePart);
            this.parseTime(parts.timePart);
        } else if (parts.hasDateOnly()) {
            this.parseDate(parts.datePart);
        } else if (parts.hasTimeOnly()) {
            this.parseTime(parts.timePart);
        }
        DateTime result = new DateTime(this.fYear, this.fMonth, this.fDay, this.fHour, this.fMinute, this.fSecond, this.fNanosecond);
        return result;
    }

    private Parts splitIntoDateAndTime(String aDateTime) {
        boolean hasDateTimeSeparator;
        Parts result = new Parts();
        int dateTimeSeparator = this.getDateTimeSeparator(aDateTime);
        boolean bl = hasDateTimeSeparator = 0 < dateTimeSeparator && dateTimeSeparator < aDateTime.length();
        if (hasDateTimeSeparator) {
            result.datePart = aDateTime.substring(0, dateTimeSeparator);
            result.timePart = aDateTime.substring(dateTimeSeparator + 1);
        } else if (this.hasColonInThirdPlace(aDateTime)) {
            result.timePart = aDateTime;
        } else {
            result.datePart = aDateTime;
        }
        return result;
    }

    int getDateTimeSeparator(String aDateTime) {
        int NOT_FOUND;
        String SPACE = " ";
        int result = NOT_FOUND = -1;
        result = aDateTime.indexOf(SPACE);
        if (result == NOT_FOUND) {
            result = aDateTime.indexOf("T");
        }
        return result;
    }

    private boolean hasColonInThirdPlace(String aDateTime) {
        boolean result = false;
        if (aDateTime.length() >= 2) {
            result = COLON.equals(aDateTime.substring(2, 3));
        }
        return result;
    }

    private void parseDate(String aDate) {
        Matcher matcher = DATE.matcher(aDate);
        if (matcher.matches()) {
            String day;
            String month;
            String year = this.getGroup(matcher, 1, 4, 6);
            if (year != null) {
                this.fYear = Integer.valueOf(year);
            }
            if ((month = this.getGroup(matcher, 2, 5)) != null) {
                this.fMonth = Integer.valueOf(month);
            }
            if ((day = this.getGroup(matcher, 3)) != null) {
                this.fDay = Integer.valueOf(day);
            }
        } else {
            throw new UnknownDateTimeFormat("Unexpected format for date:" + aDate);
        }
    }

    private String getGroup(Matcher aMatcher, int ... aGroupIds) {
        int id;
        String result = null;
        int[] arr$ = aGroupIds;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (result = aMatcher.group(id = arr$[i$])) == null; ++i$) {
        }
        return result;
    }

    private void parseTime(String aTime) {
        Matcher matcher = TIME.matcher(aTime);
        if (matcher.matches()) {
            String decimalSeconds;
            String second;
            String minute;
            String hour = this.getGroup(matcher, 1, 5, 8, 10);
            if (hour != null) {
                this.fHour = Integer.valueOf(hour);
            }
            if ((minute = this.getGroup(matcher, 2, 6, 9)) != null) {
                this.fMinute = Integer.valueOf(minute);
            }
            if ((second = this.getGroup(matcher, 3, 7)) != null) {
                this.fSecond = Integer.valueOf(second);
            }
            if ((decimalSeconds = this.getGroup(matcher, 4)) != null) {
                this.fNanosecond = Integer.valueOf(this.convertToNanoseconds(decimalSeconds));
            }
        } else {
            throw new UnknownDateTimeFormat("Unexpected format for time:" + aTime);
        }
    }

    private String convertToNanoseconds(String aDecimalSeconds) {
        StringBuilder result = new StringBuilder(aDecimalSeconds);
        while (result.length() < NUM_DIGITS) {
            result.append("0");
        }
        return result.toString();
    }

    private class Parts {
        String datePart;
        String timePart;

        private Parts() {
        }

        boolean hasTwoParts() {
            return this.datePart != null && this.timePart != null;
        }

        boolean hasDateOnly() {
            return this.timePart == null;
        }

        boolean hasTimeOnly() {
            return this.datePart == null;
        }
    }

    static final class UnknownDateTimeFormat
    extends RuntimeException {
        private static final long serialVersionUID = -7179421566055773208L;

        UnknownDateTimeFormat(String aMessage) {
            super(aMessage);
        }

        UnknownDateTimeFormat(String aMessage, Throwable aEx) {
            super(aMessage, aEx);
        }
    }
}

