/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.encode;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.inlong.sdk.transform.encode.ParquetOutputByteArray;
import org.apache.inlong.sdk.transform.encode.ParquetValueWriter;
import org.apache.inlong.sdk.transform.encode.ParquetWriteRunner;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;

public final class ParquetByteArrayWriter<T>
implements Closeable {
    private final ParquetWriter<T> writer;
    private final ParquetOutputByteArray outputByteArray;

    public static <T> ParquetByteArrayWriter<T> buildWriter(MessageType schema, ParquetWriteRunner<T> writeRunner) throws IOException {
        return new ParquetByteArrayWriter<T>(new ParquetOutputByteArray(), schema, writeRunner);
    }

    private ParquetByteArrayWriter(ParquetOutputByteArray outputFile, MessageType schema, ParquetWriteRunner<T> writeRunner) throws IOException {
        this.writer = ((Builder)((Builder)new Builder(outputFile).withType(schema).withWriteRunner(writeRunner).withCompressionCodec(CompressionCodecName.SNAPPY)).withWriterVersion(ParquetProperties.WriterVersion.PARQUET_2_0)).build();
        this.outputByteArray = outputFile;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public void write(T record) throws IOException {
        this.writer.write(record);
    }

    public ByteArrayOutputStream getByteArrayOutputStream() {
        return this.outputByteArray.getByteArrayOutputStream();
    }

    private static class SimpleWriteSupport<T>
    extends WriteSupport<T> {
        private final MessageType schema;
        private final ParquetWriteRunner<T> writeRunner;
        private final ParquetValueWriter valueWriter;
        private RecordConsumer recordConsumer;

        SimpleWriteSupport(MessageType schema, ParquetWriteRunner<T> writeRunner) {
            this.schema = schema;
            this.writeRunner = writeRunner;
            this.valueWriter = this::write;
        }

        public void write(String name, Object value) {
            int fieldIndex = this.schema.getFieldIndex(name);
            PrimitiveType type = this.schema.getType(fieldIndex).asPrimitiveType();
            this.recordConsumer.startField(name, fieldIndex);
            switch (type.getPrimitiveTypeName()) {
                case INT32: {
                    this.recordConsumer.addInteger(((Integer)value).intValue());
                    break;
                }
                case INT64: {
                    this.recordConsumer.addLong(((Long)value).longValue());
                    break;
                }
                case DOUBLE: {
                    this.recordConsumer.addDouble(((Double)value).doubleValue());
                    break;
                }
                case BOOLEAN: {
                    this.recordConsumer.addBoolean(((Boolean)value).booleanValue());
                    break;
                }
                case FLOAT: {
                    this.recordConsumer.addFloat(((Float)value).floatValue());
                    break;
                }
                case BINARY: {
                    if (type.getLogicalTypeAnnotation() == LogicalTypeAnnotation.stringType()) {
                        this.recordConsumer.addBinary(Binary.fromString((String)((String)value)));
                        break;
                    }
                    throw new UnsupportedOperationException("Don't support writing " + type.getLogicalTypeAnnotation());
                }
                default: {
                    throw new UnsupportedOperationException("Don't support writing " + type.getPrimitiveTypeName());
                }
            }
            this.recordConsumer.endField(name, fieldIndex);
        }

        public WriteSupport.WriteContext init(Configuration configuration) {
            return new WriteSupport.WriteContext(this.schema, Collections.emptyMap());
        }

        public void prepareForWrite(RecordConsumer recordConsumer) {
            this.recordConsumer = recordConsumer;
        }

        public void write(T record) {
            this.recordConsumer.startMessage();
            this.writeRunner.doWrite(record, this.valueWriter);
            this.recordConsumer.endMessage();
        }

        public String getName() {
            return null;
        }
    }

    private static final class Builder<T>
    extends ParquetWriter.Builder<T, Builder<T>> {
        private MessageType schema;
        private ParquetWriteRunner<T> writeRunner;

        private Builder(OutputFile file) {
            super(file);
        }

        public Builder<T> withType(MessageType schema) {
            this.schema = schema;
            return this;
        }

        public Builder<T> withWriteRunner(ParquetWriteRunner<T> writeRunner) {
            this.writeRunner = writeRunner;
            return this;
        }

        protected Builder<T> self() {
            return this;
        }

        protected WriteSupport<T> getWriteSupport(Configuration conf) {
            return new SimpleWriteSupport<T>(this.schema, this.writeRunner);
        }
    }
}

