/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.encode;

import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.FormatInfo;
import org.apache.inlong.sdk.transform.encode.SinkData;
import org.apache.inlong.sdk.transform.encode.SinkEncoder;
import org.apache.inlong.sdk.transform.pojo.FieldInfo;
import org.apache.inlong.sdk.transform.pojo.RowDataSinkInfo;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.utils.FieldToRowDataUtils;
import org.apache.inlong.sort.formats.base.TableFormatUtils;

public class RowDataSinkEncoder
extends SinkEncoder<RowData> {
    private final FieldToRowDataUtils.FieldToRowDataConverter[] fieldToRowDataConverters;

    public RowDataSinkEncoder(RowDataSinkInfo sinkInfo) {
        super(sinkInfo.getFields());
        this.fieldToRowDataConverters = new FieldToRowDataUtils.FieldToRowDataConverter[this.fields.size()];
        for (int i = 0; i < this.fields.size(); ++i) {
            this.fieldToRowDataConverters[i] = FieldToRowDataUtils.createConverter(TableFormatUtils.deriveLogicalType((FormatInfo)((FieldInfo)this.fields.get(i)).getFormatInfo()));
        }
    }

    @Override
    public RowData encode(SinkData sinkData, Context context) {
        GenericRowData rowData = new GenericRowData(this.fieldToRowDataConverters.length);
        for (int i = 0; i < this.fields.size(); ++i) {
            String fieldName = ((FieldInfo)this.fields.get(i)).getName();
            String fieldValue = sinkData.getField(fieldName);
            rowData.setField(i, this.fieldToRowDataConverters[i].convert(fieldValue));
        }
        return rowData;
    }
}

