/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.arithmetic;

import java.math.BigDecimal;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="arithmetic", names={"log2"}, parameter="(Numeric numeric)", descriptions={"- Return \"\" if 'numeric' is NULL;", "- Return the base 2 logarithm of 'numeric'."}, examples={"log2(32) = 5"})
public class Log2Function
implements ValueParser {
    private final ValueParser numberParser;

    public Log2Function(Function expr) {
        this.numberParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object numberObj = this.numberParser.parse(sourceData, rowIndex, context);
        if (numberObj == null) {
            return null;
        }
        BigDecimal numberValue = OperatorTools.parseBigDecimal(numberObj);
        return Math.log(numberValue.doubleValue()) / Math.log(2.0);
    }
}

