/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.collection;

import java.util.ArrayList;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="collection", names={"array_position"}, parameter="(Array array,Object element)", descriptions={"- Return \"\" if any parameter is null;", "- Return the position of the first occurrence of 'element' in the given 'array' as int (starts from 1);", "- Return 0 if the given value could not be found in the 'array'."}, examples={"array_position(array('he',7,'xxd'),'he') = 1", "array_position(array('he',7,''),'_') = 0"})
public class ArrayPositionFunction
implements ValueParser {
    private final ValueParser arrayParser;
    private final ValueParser needleParser;

    public ArrayPositionFunction(Function expr) {
        this.arrayParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
        this.needleParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(1));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object arrayObj = this.arrayParser.parse(sourceData, rowIndex, context);
        Object needleObj = this.needleParser.parse(sourceData, rowIndex, context);
        if (arrayObj == null || needleObj == null) {
            return null;
        }
        if (arrayObj instanceof ArrayList) {
            ArrayList array = (ArrayList)arrayObj;
            if (array.isEmpty()) {
                return null;
            }
            for (int i = 0; i < array.size(); ++i) {
                if (array.get(i) == null || !array.get(i).equals(needleObj)) continue;
                return i + 1;
            }
            return 0;
        }
        return null;
    }
}

