/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.collection;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="collection", names={"array_union"}, parameter="(Array array1[, Array array2, ...])", descriptions={"- Return \"\" if any input array is NULL;", "- Return an array that is the result of concatenating at least one array."}, examples={"array_concat(array('he',7),array('xxd', 'cloud')) = [he, 7, xxd, cloud]"})
public class ArrayUnionFunction
implements ValueParser {
    private final ValueParser leftArrayParser;
    private final ValueParser rightArrayParser;

    public ArrayUnionFunction(Function expr) {
        this.leftArrayParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
        this.rightArrayParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(1));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object leftArrayObj = this.leftArrayParser.parse(sourceData, rowIndex, context);
        Object rightArrayObj = this.rightArrayParser.parse(sourceData, rowIndex, context);
        if (leftArrayObj == null || rightArrayObj == null) {
            return null;
        }
        if (leftArrayObj instanceof ArrayList && rightArrayObj instanceof ArrayList) {
            ArrayList leftArray = (ArrayList)leftArrayObj;
            ArrayList rightArray = (ArrayList)rightArrayObj;
            if (leftArray.isEmpty() || rightArray.isEmpty()) {
                return null;
            }
            LinkedHashSet res = new LinkedHashSet();
            res.addAll(leftArray);
            res.addAll(rightArray);
            return new ArrayList(res);
        }
        return null;
    }
}

