/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.encryption;

import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="encryption", names={"sha2"}, parameter="(String str, Integer hash_length)", descriptions={"- Return \"\" if either argument is NULL or the 'hash_length' is not one of (224,256,384,512);", "- Return scale of the argument (the number of decimal digits in the fractional part)."}, examples={"sha2(\"5\",224) = \"b51d18b551043c1f145f22dbde6f8531faeaf68c54ed9dd79ce24d17\""})
public class Sha2Function
implements ValueParser {
    private final ValueParser msgParser;
    private final ValueParser lenParser;

    public Sha2Function(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.msgParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.lenParser = OperatorTools.buildParser((Expression)expressions.get(1));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object msgObj = this.msgParser.parse(sourceData, rowIndex, context);
        Object lenObj = this.lenParser.parse(sourceData, rowIndex, context);
        if (msgObj == null || lenObj == null) {
            return null;
        }
        byte[] msgBytes = OperatorTools.parseBytes(msgObj);
        int len = Integer.parseInt(lenObj.toString());
        switch (len) {
            case 0: 
            case 256: {
                return DigestUtils.sha256Hex((byte[])msgBytes);
            }
            case 224: {
                return new DigestUtils("SHA-224").digestAsHex(msgBytes);
            }
            case 384: {
                return DigestUtils.sha384Hex((byte[])msgBytes);
            }
            case 512: {
                return DigestUtils.sha512Hex((byte[])msgBytes);
            }
        }
        return null;
    }
}

