/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"is_digit"}, parameter="(String str)", descriptions={"- Return \"\" If 'str' is NULL;", "- Return true if all characters in 'str' are digit;", "- Return false otherwise (Including cases where 'str' is null and '')."}, examples={"is_digit('3.5') = false"})
public class IsDigitFunction
implements ValueParser {
    private final ValueParser stringParser;

    public IsDigitFunction(Function expr) {
        this.stringParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object stringObject = this.stringParser.parse(sourceData, rowIndex, context);
        if (stringObject == null) {
            return false;
        }
        String string = OperatorTools.parseString(stringObject).toLowerCase();
        if (string.isEmpty()) {
            return false;
        }
        for (char chr : string.toCharArray()) {
            if (chr >= '0' && chr <= '9') continue;
            return false;
        }
        return true;
    }
}

