/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"substring", "substr", "mid"}, parameter="(String s1, Integer pos, Integer len)", descriptions={"- Return \"\" if 'str' is NULL;", "- Return a substring of 'str' starting from position 'pos' with length 'len' (to the end by default).", "Note: This function also supports \"substring(str FROM pos [ FOR len ])\"."}, examples={"substring('apple', 1, 3) = \"app\""})
public class SubstringFunction
implements ValueParser {
    private ValueParser stringParser;
    private ValueParser startPositionParser;
    private ValueParser lengthParser;

    public SubstringFunction(Function expr) {
        ExpressionList parameters = expr.getParameters();
        List expressions = parameters != null ? parameters.getExpressions() : expr.getNamedParameters().getExpressions();
        this.stringParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.startPositionParser = OperatorTools.buildParser((Expression)expressions.get(1));
        if (expressions.size() == 3) {
            this.lengthParser = OperatorTools.buildParser((Expression)expressions.get(2));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object stringObj = this.stringParser.parse(sourceData, rowIndex, context);
        Object startPositionObj = this.startPositionParser.parse(sourceData, rowIndex, context);
        if (stringObj == null || startPositionObj == null) {
            return null;
        }
        String str = OperatorTools.parseString(stringObj);
        int start = OperatorTools.parseBigDecimal(startPositionObj).intValue();
        if (start > str.length()) {
            return "";
        }
        if (this.lengthParser != null) {
            Object lengthObj = this.lengthParser.parse(sourceData, rowIndex, context);
            int len = OperatorTools.parseBigDecimal(lengthObj).intValue();
            if (len <= 0) {
                return "";
            }
            return str.substring(Math.max(start - 1, 0), Math.min(start - 1 + len, str.length()));
        }
        return str.substring(Math.max(start - 1, 0));
    }
}

