/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.temporal;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TransformFunction(type="temporal", names={"convert_tz"}, parameter="(String leftStr , String rightStr)", descriptions={"- Return NULL if any parameter is NULL;", "- Return the result of converts a datetime 'string1' (with default ISO timestamp format yyyy-MM-dd HH:mm:ss\u2019) from time zone 'string2' to time zone 'string3'.", "Note: The format of time zone should be  either an abbreviation such as \u201cPST\u201d, a full name such as \u201cAmerica/Los_Angeles\u201d, or a custom ID such as \u201cGMT-08:00\u201d."}, examples={"CONVERT_TZ('1970-01-01 00:00:00', 'UTC', 'America/Los_Angeles') = \"1969-12-31 16:00:00\""})
public class ConvertTzFunction
implements ValueParser {
    private static final Logger log = LoggerFactory.getLogger(ConvertTzFunction.class);
    private ValueParser dateTimeParser;
    private ValueParser fromTimeZoneParser;
    private ValueParser toTimeZoneParser;

    public ConvertTzFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.dateTimeParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.fromTimeZoneParser = OperatorTools.buildParser((Expression)expressions.get(1));
        this.toTimeZoneParser = OperatorTools.buildParser((Expression)expressions.get(2));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object datetimeObj = this.dateTimeParser.parse(sourceData, rowIndex, context);
        Object fromTimeZoneObj = this.fromTimeZoneParser.parse(sourceData, rowIndex, context);
        Object toTimeZoneObj = this.toTimeZoneParser.parse(sourceData, rowIndex, context);
        if (datetimeObj == null || fromTimeZoneObj == null || toTimeZoneObj == null) {
            return null;
        }
        String dateTime = OperatorTools.parseString(datetimeObj);
        String fromTimeZone = OperatorTools.parseString(fromTimeZoneObj);
        String toTimeZone = OperatorTools.parseString(toTimeZoneObj);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime localDateTime = LocalDateTime.parse(dateTime, formatter);
        ZoneId fromZoneId = ZoneId.of(fromTimeZone);
        ZoneId toZoneId = ZoneId.of(toTimeZone);
        ZonedDateTime fromZonedDateTime = ZonedDateTime.of(localDateTime, fromZoneId);
        ZonedDateTime toZonedDateTime = fromZonedDateTime.withZoneSameInstant(toZoneId);
        return toZonedDateTime.format(formatter);
    }
}

