/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ExecConfig;
import io.fabric8.kubernetes.api.model.ExecConfigFluent;
import io.fabric8.kubernetes.api.model.ExecConfigFluentImpl;

public class ExecConfigBuilder
extends ExecConfigFluentImpl<ExecConfigBuilder>
implements VisitableBuilder<ExecConfig, ExecConfigBuilder> {
    ExecConfigFluent<?> fluent;
    Boolean validationEnabled;

    public ExecConfigBuilder() {
        this(false);
    }

    public ExecConfigBuilder(Boolean validationEnabled) {
        this(new ExecConfig(), validationEnabled);
    }

    public ExecConfigBuilder(ExecConfigFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ExecConfigBuilder(ExecConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ExecConfig(), validationEnabled);
    }

    public ExecConfigBuilder(ExecConfigFluent<?> fluent, ExecConfig instance) {
        this(fluent, instance, false);
    }

    public ExecConfigBuilder(ExecConfigFluent<?> fluent, ExecConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withArgs(instance.getArgs());
        fluent.withCommand(instance.getCommand());
        fluent.withEnv(instance.getEnv());
        fluent.withInstallHint(instance.getInstallHint());
        fluent.withInteractiveMode(instance.getInteractiveMode());
        fluent.withProvideClusterInfo(instance.getProvideClusterInfo());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ExecConfigBuilder(ExecConfig instance) {
        this(instance, (Boolean)false);
    }

    public ExecConfigBuilder(ExecConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withArgs(instance.getArgs());
        this.withCommand(instance.getCommand());
        this.withEnv(instance.getEnv());
        this.withInstallHint(instance.getInstallHint());
        this.withInteractiveMode(instance.getInteractiveMode());
        this.withProvideClusterInfo(instance.getProvideClusterInfo());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ExecConfig build() {
        ExecConfig buildable = new ExecConfig(this.fluent.getApiVersion(), this.fluent.getArgs(), this.fluent.getCommand(), this.fluent.getEnv(), this.fluent.getInstallHint(), this.fluent.getInteractiveMode(), this.fluent.getProvideClusterInfo());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

