/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.enums;

import com.google.common.collect.Lists;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.util.InlongCollectionUtils;

public enum ApplicationEnv {
    DEV,
    TEST,
    PROD;

    private static final Map<String, ApplicationEnv> NAME_MAP;

    public static ApplicationEnv forName(String name) {
        String nameUpper = StringUtils.upperCase((String)name);
        if (!NAME_MAP.containsKey(nameUpper)) {
            throw new IllegalArgumentException("ApplicationEnv type not support");
        }
        return NAME_MAP.get(nameUpper);
    }

    static {
        NAME_MAP = InlongCollectionUtils.transformToImmutableMap(Lists.newArrayList((Object[])ApplicationEnv.values()), Enum::name, Function.identity());
    }
}

