/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.enums;

public enum CompressFormat {
    NONE("none"),
    DEFLATE("deflate"),
    GZIP("gzip"),
    BZIP2("bzip2"),
    LZ4("lz4"),
    SNAPPY("snappy");

    private final String name;

    private CompressFormat(String name) {
        this.name = name;
    }

    public static CompressFormat forName(String name) {
        for (CompressFormat compressFormat : CompressFormat.values()) {
            if (!compressFormat.getName().equalsIgnoreCase(name)) continue;
            return compressFormat;
        }
        throw new IllegalArgumentException(String.format("Unsupport CompressionFormat:%s", name));
    }

    public String getName() {
        return this.name;
    }
}

