/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.lucene.analysis.TokenStream;
import org.elasticsearch.Version;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.index.analysis.MultiTermAwareComponent;
import org.elasticsearch.index.analysis.PreConfiguredAnalysisComponent;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.indices.analysis.PreBuiltCacheFactory;

public final class PreConfiguredTokenFilter
extends PreConfiguredAnalysisComponent<TokenFilterFactory> {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(PreConfiguredTokenFilter.class));
    private final boolean useFilterForMultitermQueries;
    private final boolean allowForSynonymParsing;
    private final BiFunction<TokenStream, Version, TokenStream> create;

    public static PreConfiguredTokenFilter singleton(String name, boolean useFilterForMultitermQueries, Function<TokenStream, TokenStream> create) {
        return new PreConfiguredTokenFilter(name, useFilterForMultitermQueries, true, PreBuiltCacheFactory.CachingStrategy.ONE, (tokenStream, version) -> (TokenStream)create.apply((TokenStream)tokenStream));
    }

    public static PreConfiguredTokenFilter singleton(String name, boolean useFilterForMultitermQueries, boolean allowForSynonymParsing, Function<TokenStream, TokenStream> create) {
        return new PreConfiguredTokenFilter(name, useFilterForMultitermQueries, allowForSynonymParsing, PreBuiltCacheFactory.CachingStrategy.ONE, (tokenStream, version) -> (TokenStream)create.apply((TokenStream)tokenStream));
    }

    public static PreConfiguredTokenFilter singletonWithVersion(String name, boolean useFilterForMultitermQueries, BiFunction<TokenStream, Version, TokenStream> create) {
        return new PreConfiguredTokenFilter(name, useFilterForMultitermQueries, true, PreBuiltCacheFactory.CachingStrategy.ONE, (tokenStream, version) -> (TokenStream)create.apply((TokenStream)tokenStream, (Version)version));
    }

    public static PreConfiguredTokenFilter singletonWithVersion(String name, boolean useFilterForMultitermQueries, boolean useFilterForParsingSynonyms, BiFunction<TokenStream, Version, TokenStream> create) {
        return new PreConfiguredTokenFilter(name, useFilterForMultitermQueries, useFilterForParsingSynonyms, PreBuiltCacheFactory.CachingStrategy.ONE, (tokenStream, version) -> (TokenStream)create.apply((TokenStream)tokenStream, (Version)version));
    }

    public static PreConfiguredTokenFilter luceneVersion(String name, boolean useFilterForMultitermQueries, BiFunction<TokenStream, org.apache.lucene.util.Version, TokenStream> create) {
        return new PreConfiguredTokenFilter(name, useFilterForMultitermQueries, true, PreBuiltCacheFactory.CachingStrategy.LUCENE, (tokenStream, version) -> (TokenStream)create.apply((TokenStream)tokenStream, version.luceneVersion));
    }

    public static PreConfiguredTokenFilter elasticsearchVersion(String name, boolean useFilterForMultitermQueries, BiFunction<TokenStream, Version, TokenStream> create) {
        return new PreConfiguredTokenFilter(name, useFilterForMultitermQueries, true, PreBuiltCacheFactory.CachingStrategy.ELASTICSEARCH, create);
    }

    private PreConfiguredTokenFilter(String name, boolean useFilterForMultitermQueries, boolean allowForSynonymParsing, PreBuiltCacheFactory.CachingStrategy cache, BiFunction<TokenStream, Version, TokenStream> create) {
        super(name, cache);
        this.useFilterForMultitermQueries = useFilterForMultitermQueries;
        this.allowForSynonymParsing = allowForSynonymParsing;
        this.create = create;
    }

    public boolean shouldUseFilterForMultitermQueries() {
        return this.useFilterForMultitermQueries;
    }

    @Override
    protected TokenFilterFactory create(final Version version) {
        if (this.useFilterForMultitermQueries) {
            return new MultiTermAwareTokenFilterFactory(){

                @Override
                public String name() {
                    return PreConfiguredTokenFilter.this.getName();
                }

                @Override
                public TokenStream create(TokenStream tokenStream) {
                    return (TokenStream)PreConfiguredTokenFilter.this.create.apply(tokenStream, version);
                }

                @Override
                public Object getMultiTermComponent() {
                    return this;
                }

                @Override
                public TokenFilterFactory getSynonymFilter() {
                    if (PreConfiguredTokenFilter.this.allowForSynonymParsing) {
                        return this;
                    }
                    DEPRECATION_LOGGER.deprecatedAndMaybeLog(this.name(), "Token filter [" + this.name() + "] will not be usable to parse synonyms after v7.0", new Object[0]);
                    return this;
                }
            };
        }
        return new TokenFilterFactory(){

            @Override
            public String name() {
                return PreConfiguredTokenFilter.this.getName();
            }

            @Override
            public TokenStream create(TokenStream tokenStream) {
                return (TokenStream)PreConfiguredTokenFilter.this.create.apply(tokenStream, version);
            }

            @Override
            public TokenFilterFactory getSynonymFilter() {
                if (PreConfiguredTokenFilter.this.allowForSynonymParsing) {
                    return this;
                }
                DEPRECATION_LOGGER.deprecatedAndMaybeLog(this.name(), "Token filter [" + this.name() + "] will not be usable to parse synonyms after v7.0", new Object[0]);
                return this;
            }
        };
    }

    private static interface MultiTermAwareTokenFilterFactory
    extends TokenFilterFactory,
    MultiTermAwareComponent {
    }
}

