/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.tophits;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.tophits.TopHits;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class InternalTopHits
extends InternalAggregation
implements TopHits {
    private int from;
    private int size;
    private TopDocs topDocs;
    private SearchHits searchHits;

    public InternalTopHits(String name, int from, int size, TopDocs topDocs, SearchHits searchHits, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.from = from;
        this.size = size;
        this.topDocs = topDocs;
        this.searchHits = searchHits;
    }

    public InternalTopHits(StreamInput in) throws IOException {
        super(in);
        this.from = in.readVInt();
        this.size = in.readVInt();
        this.topDocs = Lucene.readTopDocs(in);
        this.searchHits = SearchHits.readSearchHits(in);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.from);
        out.writeVInt(this.size);
        Lucene.writeTopDocs(out, this.topDocs);
        this.searchHits.writeTo(out);
    }

    @Override
    public String getWriteableName() {
        return "top_hits";
    }

    @Override
    public SearchHits getHits() {
        return this.searchHits;
    }

    TopDocs getTopDocs() {
        return this.topDocs;
    }

    int getFrom() {
        return this.from;
    }

    int getSize() {
        return this.size;
    }

    @Override
    public InternalAggregation doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        TopDocs reducedTopDocs;
        TopDocs[] shardDocs;
        int size;
        int from;
        SearchHits[] shardHits = new SearchHits[aggregations.size()];
        if (reduceContext.isFinalReduce()) {
            from = this.from;
            size = this.size;
        } else {
            from = 0;
            size = this.from + this.size;
        }
        if (this.topDocs instanceof TopFieldDocs) {
            Sort sort = new Sort(((TopFieldDocs)this.topDocs).fields);
            shardDocs = new TopFieldDocs[aggregations.size()];
            for (int i = 0; i < shardDocs.length; ++i) {
                InternalTopHits topHitsAgg = (InternalTopHits)aggregations.get(i);
                shardDocs[i] = topHitsAgg.topDocs;
                shardHits[i] = topHitsAgg.searchHits;
            }
            reducedTopDocs = TopDocs.merge((Sort)sort, (int)from, (int)size, (TopFieldDocs[])((TopFieldDocs[])shardDocs), (boolean)true);
        } else {
            shardDocs = new TopDocs[aggregations.size()];
            for (int i = 0; i < shardDocs.length; ++i) {
                InternalTopHits topHitsAgg = (InternalTopHits)aggregations.get(i);
                shardDocs[i] = topHitsAgg.topDocs;
                shardHits[i] = topHitsAgg.searchHits;
            }
            reducedTopDocs = TopDocs.merge((int)from, (int)size, (TopDocs[])shardDocs, (boolean)true);
        }
        int[] tracker = new int[shardHits.length];
        SearchHit[] hits = new SearchHit[reducedTopDocs.scoreDocs.length];
        for (int i = 0; i < reducedTopDocs.scoreDocs.length; ++i) {
            int position;
            ScoreDoc scoreDoc = reducedTopDocs.scoreDocs[i];
            do {
                int n = scoreDoc.shardIndex;
                tracker[n] = tracker[n] + 1;
            } while (shardDocs[scoreDoc.shardIndex].scoreDocs[position] != scoreDoc);
            hits[i] = shardHits[scoreDoc.shardIndex].getAt(position);
        }
        return new InternalTopHits(this.name, this.from, this.size, reducedTopDocs, new SearchHits(hits, reducedTopDocs.totalHits, reducedTopDocs.getMaxScore()), this.pipelineAggregators(), this.getMetaData());
    }

    @Override
    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + path);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.searchHits.toXContent(builder, params);
        return builder;
    }

    @Override
    protected boolean doEquals(Object obj) {
        InternalTopHits other = (InternalTopHits)obj;
        if (this.from != other.from) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        if (this.topDocs.totalHits != other.topDocs.totalHits) {
            return false;
        }
        if (this.topDocs.scoreDocs.length != other.topDocs.scoreDocs.length) {
            return false;
        }
        for (int d = 0; d < this.topDocs.scoreDocs.length; ++d) {
            ScoreDoc thisDoc = this.topDocs.scoreDocs[d];
            ScoreDoc otherDoc = other.topDocs.scoreDocs[d];
            if (thisDoc.doc != otherDoc.doc) {
                return false;
            }
            if (Double.compare(thisDoc.score, otherDoc.score) != 0) {
                return false;
            }
            if (thisDoc.shardIndex != otherDoc.shardIndex) {
                return false;
            }
            if (!(thisDoc instanceof FieldDoc)) continue;
            if (!(otherDoc instanceof FieldDoc)) {
                return false;
            }
            FieldDoc thisFieldDoc = (FieldDoc)thisDoc;
            FieldDoc otherFieldDoc = (FieldDoc)otherDoc;
            if (thisFieldDoc.fields.length != otherFieldDoc.fields.length) {
                return false;
            }
            for (int f = 0; f < thisFieldDoc.fields.length; ++f) {
                if (thisFieldDoc.fields[f].equals(otherFieldDoc.fields[f])) continue;
                return false;
            }
        }
        return this.searchHits.equals(other.searchHits);
    }

    @Override
    protected int doHashCode() {
        int hashCode = this.from;
        hashCode = 31 * hashCode + this.size;
        hashCode = 31 * hashCode + Long.hashCode(this.topDocs.totalHits);
        for (int d = 0; d < this.topDocs.scoreDocs.length; ++d) {
            ScoreDoc doc = this.topDocs.scoreDocs[d];
            hashCode = 31 * hashCode + doc.doc;
            hashCode = 31 * hashCode + Float.floatToIntBits(doc.score);
            hashCode = 31 * hashCode + doc.shardIndex;
            if (!(doc instanceof FieldDoc)) continue;
            FieldDoc fieldDoc = (FieldDoc)doc;
            hashCode = 31 * hashCode + Arrays.hashCode(fieldDoc.fields);
        }
        hashCode = 31 * hashCode + this.searchHits.hashCode();
        return hashCode;
    }
}

