/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.Weight;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.search.dfs.AggregatedDfs;
import org.elasticsearch.search.internal.CancellableBulkScorer;
import org.elasticsearch.search.profile.Timer;
import org.elasticsearch.search.profile.query.ProfileWeight;
import org.elasticsearch.search.profile.query.QueryProfileBreakdown;
import org.elasticsearch.search.profile.query.QueryProfiler;
import org.elasticsearch.search.profile.query.QueryTimingType;

public class ContextIndexSearcher
extends IndexSearcher
implements Releasable {
    private final IndexSearcher in;
    private AggregatedDfs aggregatedDfs;
    private final Engine.Searcher engineSearcher;
    private QueryProfiler profiler;
    private Runnable checkCancelled;

    public ContextIndexSearcher(Engine.Searcher searcher, QueryCache queryCache, QueryCachingPolicy queryCachingPolicy) {
        super(searcher.reader());
        this.in = searcher.searcher();
        this.engineSearcher = searcher;
        this.setSimilarity(searcher.searcher().getSimilarity(true));
        this.setQueryCache(queryCache);
        this.setQueryCachingPolicy(queryCachingPolicy);
    }

    @Override
    public void close() {
    }

    public void setProfiler(QueryProfiler profiler) {
        this.profiler = profiler;
    }

    public void setCheckCancelled(Runnable checkCancelled) {
        this.checkCancelled = checkCancelled;
    }

    public void setAggregatedDfs(AggregatedDfs aggregatedDfs) {
        this.aggregatedDfs = aggregatedDfs;
    }

    public Query rewrite(Query original) throws IOException {
        if (this.profiler != null) {
            this.profiler.startRewriteTime();
        }
        try {
            Query query = this.in.rewrite(original);
            return query;
        }
        finally {
            if (this.profiler != null) {
                this.profiler.stopAndAddRewriteTime();
            }
        }
    }

    public Weight createNormalizedWeight(Query query, boolean needsScores) throws IOException {
        if (this.aggregatedDfs != null && needsScores) {
            return super.createNormalizedWeight(query, needsScores);
        }
        if (this.profiler != null) {
            return super.createNormalizedWeight(query, needsScores);
        }
        return this.in.createNormalizedWeight(query, needsScores);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Weight createWeight(Query query, boolean needsScores, float boost) throws IOException {
        if (this.profiler != null) {
            Weight weight;
            QueryProfileBreakdown profile = (QueryProfileBreakdown)this.profiler.getQueryBreakdown(query);
            Timer timer = profile.getTimer(QueryTimingType.CREATE_WEIGHT);
            timer.start();
            try {
                weight = super.createWeight(query, needsScores, boost);
            }
            finally {
                timer.stop();
                this.profiler.pollLastElement();
            }
            return new ProfileWeight(query, weight, profile);
        }
        return super.createWeight(query, needsScores, boost);
    }

    protected void search(List<LeafReaderContext> leaves, final Weight weight, Collector collector) throws IOException {
        Weight cancellableWeight = this.checkCancelled != null ? new Weight(weight.getQuery()){

            public void extractTerms(Set<Term> terms) {
                throw new UnsupportedOperationException();
            }

            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                throw new UnsupportedOperationException();
            }

            public Scorer scorer(LeafReaderContext context) throws IOException {
                throw new UnsupportedOperationException();
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                throw new UnsupportedOperationException();
            }

            public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
                BulkScorer in = weight.bulkScorer(context);
                if (in != null) {
                    return new CancellableBulkScorer(in, ContextIndexSearcher.this.checkCancelled);
                }
                return null;
            }
        } : weight;
        super.search(leaves, cancellableWeight, collector);
    }

    public Explanation explain(Query query, int doc) throws IOException {
        if (this.aggregatedDfs != null) {
            return super.explain(this.createNormalizedWeight(query, true), doc);
        }
        return this.in.explain(query, doc);
    }

    public TermStatistics termStatistics(Term term, TermContext context) throws IOException {
        if (this.aggregatedDfs == null) {
            return super.termStatistics(term, context);
        }
        TermStatistics termStatistics = (TermStatistics)this.aggregatedDfs.termStatistics().get((Object)term);
        if (termStatistics == null) {
            return super.termStatistics(term, context);
        }
        return termStatistics;
    }

    public CollectionStatistics collectionStatistics(String field) throws IOException {
        if (this.aggregatedDfs == null) {
            return super.collectionStatistics(field);
        }
        CollectionStatistics collectionStatistics = (CollectionStatistics)this.aggregatedDfs.fieldStatistics().get((Object)field);
        if (collectionStatistics == null) {
            return super.collectionStatistics(field);
        }
        return collectionStatistics;
    }

    public DirectoryReader getDirectoryReader() {
        return this.engineSearcher.getDirectoryReader();
    }

    public Engine.Searcher getEngineSearcher() {
        return this.engineSearcher;
    }
}

