/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.client.config;

import org.apache.inlong.tubemq.client.common.TClientConstants;
import org.apache.inlong.tubemq.client.config.TubeClientConfig;
import org.apache.inlong.tubemq.client.consumer.ConsumePosition;
import org.apache.inlong.tubemq.corebase.cluster.MasterInfo;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;

public class ConsumerConfig
extends TubeClientConfig {
    private final String consumerGroup;
    private ConsumePosition consumePosition = ConsumePosition.CONSUMER_FROM_LATEST_OFFSET;
    private int maxSubInfoReportIntvlTimes = 6;
    private long msgNotFoundWaitPeriodMs = 400L;
    private long pullConsumeReadyWaitPeriodMs = 90000L;
    private long pullConsumeReadyChkSliceMs = 5L;
    private long shutDownRebalanceWaitPeriodMs = 10000L;
    private long partMetaInfoCheckPeriodMs = 10000L;
    private int pushFetchThreadCnt = TClientConstants.CFG_DEFAULT_CLIENT_PUSH_FETCH_THREAD_CNT;
    private boolean pushListenerWaitTimeoutRollBack = true;
    private boolean pushListenerThrowedRollBack = false;
    private long pushListenerWaitPeriodMs = 3000L;
    private boolean pullRebConfirmTimeoutRollBack = true;
    private long pullRebConfirmWaitPeriodMs = 3000L;
    private long pullProtectConfirmTimeoutMs = 60000L;
    private boolean pullConfirmInLocal = false;

    public ConsumerConfig(String masterAddrInfo, String consumerGroup) {
        this(new MasterInfo(masterAddrInfo), consumerGroup);
    }

    public ConsumerConfig(MasterInfo masterInfo, String consumerGroup) {
        super(masterInfo);
        this.validConsumerGroupParameter(consumerGroup);
        this.consumerGroup = consumerGroup.trim();
    }

    @Deprecated
    public ConsumerConfig(String localHostIP, String masterAddrInfo, String consumerGroup) throws Exception {
        this(localHostIP, new MasterInfo(masterAddrInfo), consumerGroup);
    }

    @Deprecated
    public ConsumerConfig(String localHostIP, MasterInfo masterInfo, String consumerGroup) throws Exception {
        super(localHostIP, masterInfo);
        this.validConsumerGroupParameter(consumerGroup);
        this.consumerGroup = consumerGroup.trim();
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public ConsumePosition getConsumePosition() {
        return this.consumePosition;
    }

    public void setConsumePosition(ConsumePosition consumePosition) {
        this.consumePosition = consumePosition;
    }

    @Deprecated
    public int getConsumeModel() {
        return this.consumePosition.getCode();
    }

    @Deprecated
    public void setConsumeModel(int consumeModel) {
        this.setConsumePosition(ConsumePosition.valueOf(consumeModel));
    }

    public long getMsgNotFoundWaitPeriodMs() {
        return this.msgNotFoundWaitPeriodMs;
    }

    public void setMsgNotFoundWaitPeriodMs(long msgNotFoundWaitPeriodMs) {
        this.msgNotFoundWaitPeriodMs = msgNotFoundWaitPeriodMs;
    }

    public long getPullConsumeReadyWaitPeriodMs() {
        return this.pullConsumeReadyWaitPeriodMs;
    }

    public void setPullConsumeReadyWaitPeriodMs(long pullConsumeReadyWaitPeriodMs) {
        this.pullConsumeReadyWaitPeriodMs = pullConsumeReadyWaitPeriodMs;
    }

    public long getPullConsumeReadyChkSliceMs() {
        return this.pullConsumeReadyChkSliceMs;
    }

    public void setPullConsumeReadyChkSliceMs(long pullConsumeReadyChkSliceMs) {
        if (pullConsumeReadyChkSliceMs >= 0L && pullConsumeReadyChkSliceMs <= 1000L) {
            this.pullConsumeReadyChkSliceMs = pullConsumeReadyChkSliceMs;
        }
    }

    public long getShutDownRebalanceWaitPeriodMs() {
        return this.shutDownRebalanceWaitPeriodMs;
    }

    public void setShutDownRebalanceWaitPeriodMs(long shutDownRebalanceWaitPeriodMs) {
        this.shutDownRebalanceWaitPeriodMs = shutDownRebalanceWaitPeriodMs;
    }

    public long getPartMetaInfoCheckPeriodMs() {
        return this.partMetaInfoCheckPeriodMs;
    }

    public void setPartMetaInfoCheckPeriodMs(long partMetaInfoCheckPeriodMs) {
        if (partMetaInfoCheckPeriodMs < 5000L) {
            this.partMetaInfoCheckPeriodMs = 5000L;
        }
        this.partMetaInfoCheckPeriodMs = partMetaInfoCheckPeriodMs;
    }

    public int getPushFetchThreadCnt() {
        return this.pushFetchThreadCnt;
    }

    public void setPushFetchThreadCnt(int pushFetchThreadCnt) {
        this.pushFetchThreadCnt = pushFetchThreadCnt <= 0 ? TClientConstants.CFG_DEFAULT_CLIENT_PUSH_FETCH_THREAD_CNT : pushFetchThreadCnt;
    }

    public boolean isPushListenerWaitTimeoutRollBack() {
        return this.pushListenerWaitTimeoutRollBack;
    }

    public void setPushListenerWaitTimeoutRollBack(boolean pushListenerWaitTimeoutRollBack) {
        this.pushListenerWaitTimeoutRollBack = pushListenerWaitTimeoutRollBack;
    }

    public boolean isPushListenerThrowedRollBack() {
        return this.pushListenerThrowedRollBack;
    }

    public void setPushListenerThrowedRollBack(boolean pushListenerThrowedRollBack) {
        this.pushListenerThrowedRollBack = pushListenerThrowedRollBack;
    }

    public long getPushListenerWaitPeriodMs() {
        return this.pushListenerWaitPeriodMs;
    }

    public void setPushListenerWaitPeriodMs(long pushListenerWaitPeriodMs) {
        this.pushListenerWaitPeriodMs = pushListenerWaitPeriodMs;
    }

    public boolean isPullRebConfirmTimeoutRollBack() {
        return this.pullRebConfirmTimeoutRollBack;
    }

    public void setPullRebConfirmTimeoutRollBack(boolean pullRebConfirmTimeoutRollBack) {
        this.pullRebConfirmTimeoutRollBack = pullRebConfirmTimeoutRollBack;
    }

    public long getPullRebConfirmWaitPeriodMs() {
        return this.pullRebConfirmWaitPeriodMs;
    }

    public void setPullRebConfirmWaitPeriodMs(long pullRebConfirmWaitPeriodMs) {
        this.pullRebConfirmWaitPeriodMs = pullRebConfirmWaitPeriodMs;
    }

    public boolean isPullConfirmInLocal() {
        return this.pullConfirmInLocal;
    }

    public void setPullConfirmInLocal(boolean pullConfirmInLocal) {
        this.pullConfirmInLocal = pullConfirmInLocal;
    }

    public long getPullProtectConfirmTimeoutMs() {
        return this.pullProtectConfirmTimeoutMs;
    }

    public void setPullProtectConfirmTimeoutMs(long pullProtectConfirmTimeoutMs) {
        this.pullProtectConfirmTimeoutMs = pullProtectConfirmTimeoutMs;
    }

    public int getMaxSubInfoReportIntvlTimes() {
        return this.maxSubInfoReportIntvlTimes;
    }

    public void setMaxSubInfoReportIntvlTimes(int maxSubInfoReportIntvlTimes) {
        this.maxSubInfoReportIntvlTimes = Math.max(maxSubInfoReportIntvlTimes, 3);
    }

    private void validConsumerGroupParameter(String consumerGroup) {
        if (TStringUtils.isBlank((String)consumerGroup)) {
            throw new IllegalArgumentException("Illegal parameter: consumerGroup is Blank!");
        }
        String tmpConsumerGroup = consumerGroup.trim();
        if (tmpConsumerGroup.length() > 1024) {
            throw new IllegalArgumentException(new StringBuilder(512).append("Illegal parameter: the max length of consumerGroup is ").append(1024).append(" characters").toString());
        }
        if (!tmpConsumerGroup.matches("^[a-zA-Z][\\w-]+$")) {
            throw new IllegalArgumentException(new StringBuilder(512).append("Illegal parameter: the value of consumerGroup").append(" must begin with a letter, ").append("can only contain characters,numbers,hyphen,and underscores").toString());
        }
    }

    public String toString() {
        return new StringBuilder(512).append("\"ConsumerConfig\":{").append("\"consumerGroup\":\"").append(this.consumerGroup).append("\",\"maxSubInfoReportIntvlTimes\":").append(this.maxSubInfoReportIntvlTimes).append(",\"consumePosition\":").append((Object)this.consumePosition).append(",\"msgNotFoundWaitPeriodMs\":").append(this.msgNotFoundWaitPeriodMs).append(",\"shutDownRebalanceWaitPeriodMs\":").append(this.shutDownRebalanceWaitPeriodMs).append(",\"pushFetchThreadCnt\":").append(this.pushFetchThreadCnt).append(",\"pushListenerWaitTimeoutRollBack\":").append(this.pushListenerWaitTimeoutRollBack).append(",\"pushListenerThrowedRollBack\":").append(this.pushListenerThrowedRollBack).append(",\"pushListenerWaitPeriodMs\":").append(this.pushListenerWaitPeriodMs).append(",\"pullRebConfirmTimeoutRollBack\":").append(this.pullRebConfirmTimeoutRollBack).append(",\"pullConfirmWaitPeriodMs\":").append(this.pullRebConfirmWaitPeriodMs).append(",\"pullProtectConfirmTimeoutPeriodMs\":").append(this.pullProtectConfirmTimeoutMs).append(",\"pullConfirmInLocal\":").append(this.pullConfirmInLocal).append(",\"maxSubInfoReportIntvlTimes\":").append(this.maxSubInfoReportIntvlTimes).append(",\"partMetaInfoCheckPeriodMs\":").append(this.partMetaInfoCheckPeriodMs).append(",\"ClientConfig\":").append(this.toJsonString()).append("}").toString();
    }
}

